/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RollupPanel;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainMenuState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MainMenuState.class);
    public static final FunctionId F_SETTINGS = new FunctionId("Show Menus");
    private String appName;
    private Container mainWindow;
    private TabbedPanel tabs;
    private boolean originalCursorEventsEnabled = false;

    public MainMenuState(String appName) {
        this.appName = appName;
        this.setEnabled(true);
    }

    public static void initializeDefaultMappings(InputMapper inputMapper) {
        inputMapper.map(F_SETTINGS, 15, new Object[0]);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected Node getGuiNode() {
        return ((SimpleApplication)this.getApplication()).getGuiNode();
    }

    public TabbedPanel getTabs() {
        return this.tabs;
    }

    protected void initialize(Application app) {
        GuiGlobals.getInstance().getInputMapper().addDelegate(F_SETTINGS, (Object)this, "toggleEnabled");
        this.mainWindow = new Container();
        RollupPanel rollup = (RollupPanel)this.mainWindow.addChild((Node)new RollupPanel(this.appName, null), new Object[0]);
        this.tabs = new TabbedPanel();
        rollup.setContents((Panel)this.tabs);
        this.mainWindow.setLocalTranslation(10.0f, (float)(app.getCamera().getHeight() - 10), 0.0f);
    }

    protected void cleanup(Application app) {
        GuiGlobals.getInstance().getInputMapper().removeDelegate(F_SETTINGS, (Object)this, "toggleEnabled");
    }

    protected void onEnable() {
        this.getGuiNode().attachChild((Spatial)this.mainWindow);
        GuiGlobals.getInstance().requestCursorEnabled((Object)this);
    }

    protected void onDisable() {
        this.mainWindow.removeFromParent();
        GuiGlobals.getInstance().releaseCursorEnabled((Object)this);
    }
}

