/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeshUtils {
    static Logger log = LoggerFactory.getLogger(MeshUtils.class);

    public static Vector2f getBarycentricCoord(Mesh mesh, int triangleIndex, Vector3f point) {
        IndexBuffer ib = mesh.getIndicesAsList();
        VertexBuffer pb = mesh.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer fpb = (FloatBuffer)pb.getData();
        int vertIndex = triangleIndex * 3;
        int i1 = ib.get(vertIndex);
        int i2 = ib.get(vertIndex + 1);
        int i3 = ib.get(vertIndex + 2);
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        Vector3f v3 = new Vector3f();
        BufferUtils.populateFromBuffer((Vector3f)v1, (FloatBuffer)fpb, (int)i1);
        BufferUtils.populateFromBuffer((Vector3f)v2, (FloatBuffer)fpb, (int)i2);
        BufferUtils.populateFromBuffer((Vector3f)v3, (FloatBuffer)fpb, (int)i3);
        Vector3f vr0 = v3.subtract(v1);
        Vector3f vr1 = v2.subtract(v1);
        Vector3f vr2 = point.subtract(v1);
        float dot00 = vr0.dot(vr0);
        float dot01 = vr0.dot(vr1);
        float dot02 = vr0.dot(vr2);
        float dot11 = vr1.dot(vr1);
        float dot12 = vr1.dot(vr2);
        float invDenom = 1.0f / (dot00 * dot11 - dot01 * dot01);
        float bu = (dot11 * dot02 - dot01 * dot12) * invDenom;
        float bv = (dot00 * dot12 - dot01 * dot02) * invDenom;
        return new Vector2f(bu, bv);
    }

    public static Vector2f getTextureCoordinate(Mesh mesh, int triangleIndex, Vector2f bary) {
        IndexBuffer ib = mesh.getIndicesAsList();
        VertexBuffer tb = mesh.getBuffer(VertexBuffer.Type.TexCoord);
        FloatBuffer ftb = (FloatBuffer)tb.getData();
        int vertIndex = triangleIndex * 3;
        int i1 = ib.get(vertIndex);
        int i2 = ib.get(vertIndex + 1);
        int i3 = ib.get(vertIndex + 2);
        Vector2f uv1 = new Vector2f();
        Vector2f uv2 = new Vector2f();
        Vector2f uv3 = new Vector2f();
        BufferUtils.populateFromBuffer((Vector2f)uv1, (FloatBuffer)ftb, (int)i1);
        BufferUtils.populateFromBuffer((Vector2f)uv2, (FloatBuffer)ftb, (int)i2);
        BufferUtils.populateFromBuffer((Vector2f)uv3, (FloatBuffer)ftb, (int)i3);
        Vector2f t2 = uv2.subtract(uv1);
        Vector2f t1 = uv3.subtract(uv1);
        Vector2f newUV = uv1.add(t1.mult(bary.x)).add(t2.mult(bary.y));
        return newUV;
    }
}

