/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.tool.OrbitCameraFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrbitCameraState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(OrbitCameraState.class);
    private static final float MIN_PITCH = -1.5550884f;
    private static final float MAX_PITCH = 1.5550884f;
    private static final float MIN_DISTANCE = 1.0f;
    private static final float MAX_DISTANCE = 20.0f;
    private InputMapper inputMapper;
    private Spatial center;
    private Node centerMarker;
    private Camera camera;
    private MovementHandler movementHandler = new MovementHandler();
    private float yaw = 0.0f;
    private float pitch = -0.62831855f;
    private float distance = 5.0f;
    private float movementSpeed = 2.0f;
    private boolean invalid = true;
    private Vector3f startOffset;
    private boolean centerActive = false;

    public OrbitCameraState() {
        this(5.0f, new Vector3f(0.0f, 1.0f, 0.0f));
    }

    public OrbitCameraState(float distance) {
        this(distance, new Vector3f(0.0f, 1.0f, 0.0f));
    }

    public OrbitCameraState(float distance, Vector3f startOffset) {
        this.distance = distance;
        this.startOffset = startOffset;
    }

    protected void initialize(Application app) {
        this.camera = app.getCamera();
        if (this.inputMapper == null) {
            this.inputMapper = GuiGlobals.getInstance().getInputMapper();
        }
        this.inputMapper.addAnalogListener((AnalogFunctionListener)this.movementHandler, new FunctionId[]{OrbitCameraFunctions.F_YAW, OrbitCameraFunctions.F_PITCH, OrbitCameraFunctions.F_ZOOM, OrbitCameraFunctions.F_ELEVATE, OrbitCameraFunctions.F_STRAFE});
        this.inputMapper.addStateListener((StateFunctionListener)this.movementHandler, new FunctionId[]{OrbitCameraFunctions.F_MOVE_TOGGLE});
        this.center = new Node("center");
        this.centerMarker = new Node("axis");
        Sphere sphere = new Sphere(4, 4, 0.1f);
        Geometry geom = new Geometry("centerMarker", (Mesh)sphere);
        Material mat = GuiGlobals.getInstance().createMaterial(ColorRGBA.Yellow, false).getMaterial();
        mat.getAdditionalRenderState().setWireframe(true);
        geom.setMaterial(mat);
        geom.rotate(1.5707964f, 0.0f, 0.0f);
        this.centerMarker.attachChild((Spatial)geom);
        this.center.move(this.startOffset);
        this.resetCenterActive();
    }

    protected void cleanup(Application app) {
        this.inputMapper.removeAnalogListener((AnalogFunctionListener)this.movementHandler, new FunctionId[]{OrbitCameraFunctions.F_YAW, OrbitCameraFunctions.F_PITCH, OrbitCameraFunctions.F_ZOOM, OrbitCameraFunctions.F_ELEVATE, OrbitCameraFunctions.F_STRAFE});
        this.inputMapper.removeStateListener((StateFunctionListener)this.movementHandler, new FunctionId[]{OrbitCameraFunctions.F_MOVE_TOGGLE});
    }

    protected void onEnable() {
        this.inputMapper.activateGroup("Orbit");
        ((SimpleApplication)this.getApplication()).getRootNode().attachChild((Spatial)this.centerMarker);
    }

    public void update(float tpf) {
        if (this.invalid) {
            this.invalid = false;
            this.resetCamera();
        }
    }

    protected void onDisable() {
        this.centerMarker.removeFromParent();
        this.inputMapper.deactivateGroup("Orbit");
    }

    private void resetCamera() {
        this.center.setLocalRotation(new Quaternion().fromAngles(this.pitch, this.yaw, 0.0f));
        Vector3f pos = this.center.localToWorld(new Vector3f(0.0f, 0.0f, this.distance), null);
        this.camera.setLocation(pos);
        this.camera.lookAt(this.center.getWorldTranslation(), Vector3f.UNIT_Y);
        this.centerMarker.setLocalTranslation(this.center.getLocalTranslation());
    }

    private void resetCenterActive() {
        this.centerMarker.setLocalScale(this.centerActive ? 1.0f : 0.1f);
    }

    private class MovementHandler
    implements AnalogFunctionListener,
    StateFunctionListener {
        private MovementHandler() {
        }

        public void valueChanged(FunctionId func, InputState value, double tpf) {
            OrbitCameraState.this.centerActive = value.asNumber() != 0;
            OrbitCameraState.this.resetCenterActive();
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (func == OrbitCameraFunctions.F_YAW) {
                OrbitCameraState.this.yaw = (float)((double)OrbitCameraState.this.yaw + value * tpf);
                OrbitCameraState.this.invalid = true;
            } else if (func == OrbitCameraFunctions.F_PITCH) {
                OrbitCameraState.this.pitch = (float)((double)OrbitCameraState.this.pitch - value * tpf);
                OrbitCameraState.this.pitch = FastMath.clamp((float)OrbitCameraState.this.pitch, (float)-1.5550884f, (float)1.5550884f);
                OrbitCameraState.this.invalid = true;
            } else if (func == OrbitCameraFunctions.F_STRAFE) {
                Vector3f side = OrbitCameraState.this.center.getLocalRotation().mult(Vector3f.UNIT_X);
                OrbitCameraState.this.center.move((float)((double)side.x * (value *= (double)OrbitCameraState.this.movementSpeed) * tpf), 0.0f, (float)((double)side.z * value * tpf));
                OrbitCameraState.this.invalid = true;
            } else if (func == OrbitCameraFunctions.F_ELEVATE) {
                OrbitCameraState.this.center.move(0.0f, (float)((value *= (double)OrbitCameraState.this.movementSpeed) * tpf), 0.0f);
                OrbitCameraState.this.invalid = true;
            } else if (func == OrbitCameraFunctions.F_ZOOM) {
                OrbitCameraState.this.distance = (float)((double)OrbitCameraState.this.distance + (value *= (double)OrbitCameraState.this.movementSpeed) * tpf);
                OrbitCameraState.this.distance = FastMath.clamp((float)OrbitCameraState.this.distance, (float)1.0f, (float)20.0f);
                OrbitCameraState.this.invalid = true;
            }
        }
    }
}

