/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mathd.Vec3d;

public class Vec3dEditor
extends Panel
implements VersionedObject<Vec3d> {
    private Vec3d value = new Vec3d();
    private long version;
    private EditorEntry[] editors = new EditorEntry[3];

    public Vec3dEditor() {
        this(Axis.X);
    }

    public Vec3dEditor(Axis axis) {
        this(axis, 0.0, 1.0, 0.05, 0.01);
    }

    public Vec3dEditor(Axis axis, double min, double max, double step, double precision) {
        for (int i = 0; i < 3; ++i) {
            SequenceModel model = SequenceModels.rangedSequence((RangedValueModel)new DefaultRangedValueModel(min, max, 0.0), (double)step, (double)precision);
            this.editors[i] = new EditorEntry(i, (SequenceModel<Double>)model);
        }
        this.setBackground(null);
        if (axis == Axis.Y) {
            SpringGridLayout layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last);
            ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)layout);
            layout.addChild((Node)new Label("x:"), new Object[0]);
            layout.addChild(this.editors[0].editor, new Object[]{1});
            layout.addChild((Node)new Label("y:"), new Object[0]);
            layout.addChild(this.editors[1].editor, new Object[]{1});
            layout.addChild((Node)new Label("z:"), new Object[0]);
            layout.addChild(this.editors[2].editor, new Object[]{1});
        } else if (axis == Axis.X) {
            SpringGridLayout layout = new SpringGridLayout(Axis.X, Axis.Y, FillMode.ForcedEven, FillMode.Last);
            ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)layout);
            Container column = (Container)layout.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.Last)), new Object[0]);
            column.setBackground(null);
            column.addChild((Node)new Label("x:"), new Object[0]);
            column.addChild(this.editors[0].editor, new Object[0]);
            column = (Container)layout.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.Last)), new Object[0]);
            column.setBackground(null);
            column.addChild((Node)new Label("y:"), new Object[0]);
            column.addChild(this.editors[1].editor, new Object[0]);
            column = (Container)layout.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.Last)), new Object[0]);
            column.setBackground(null);
            column.addChild((Node)new Label("z:"), new Object[0]);
            column.addChild(this.editors[2].editor, new Object[0]);
        } else {
            throw new UnsupportedOperationException("Z axis not yet supported");
        }
    }

    public void setObject(Vec3d value) {
        if (this.value == value) {
            return;
        }
        this.value.set(value);
        ++this.version;
        this.resetView();
    }

    public Vec3d getObject() {
        return this.value;
    }

    public long getVersion() {
        return this.version;
    }

    public VersionedReference<Vec3d> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    protected void resetView() {
        for (EditorEntry e : this.editors) {
            e.resetView();
        }
    }

    public void setAxisModel(int axis, SequenceModel<Double> model) {
        this.editors[axis].setModel(model);
    }

    public SequenceModel<Double> getAxisModel(int axis) {
        return this.editors[axis].model;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        boolean changed = false;
        for (EditorEntry e : this.editors) {
            if (!e.update()) continue;
            changed = true;
        }
        if (changed) {
            ++this.version;
        }
    }

    private class EditorEntry {
        Spinner<Double> editor;
        SequenceModel<Double> model;
        VersionedReference<Double> valueRef;
        int index;

        public EditorEntry(int index, SequenceModel<Double> model) {
            this.index = index;
            this.model = model;
            this.valueRef = model.createReference();
            DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)"%.2f", (String)"error");
            this.editor = new Spinner(model, (ValueRenderer)renderer);
            this.editor.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)"%.2f"));
        }

        public void setModel(SequenceModel<Double> model) {
            if (this.model == model) {
                return;
            }
            this.model = model;
            this.editor.setModel(model);
            this.valueRef = model.createReference();
        }

        public void resetView() {
            this.model.setObject((Object)Vec3dEditor.this.value.get(this.index));
        }

        public boolean update() {
            if (this.valueRef.update()) {
                Vec3dEditor.this.value.set(this.index, ((Double)this.model.getObject()).doubleValue());
                return true;
            }
            return false;
        }
    }
}

