/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.math.Vector2f;
import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.value.DefaultValueRenderer;

public class Vector2fEditor
extends Panel
implements VersionedObject<Vector2f> {
    private Vector2f value = new Vector2f();
    private long version;
    private EditorEntry[] editors = new EditorEntry[2];

    public Vector2fEditor() {
        this(Axis.X);
    }

    public Vector2fEditor(Axis axis) {
        this(axis, 0.0, 1.0, 0.05, 0.01);
    }

    public Vector2fEditor(Axis axis, double min, double max, double step, double precision) {
        for (int i = 0; i < this.editors.length; ++i) {
            SequenceModel model = SequenceModels.rangedSequence((RangedValueModel)new DefaultRangedValueModel(min, max, 0.0), (double)step, (double)precision);
            this.editors[i] = new EditorEntry(i, (SequenceModel<Double>)model, precision);
        }
        this.setBackground(null);
        if (axis == Axis.Y) {
            SpringGridLayout layout = new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last);
            ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)layout);
            layout.addChild((Node)new Label("x:"), new Object[0]);
            layout.addChild(this.editors[0].editor, new Object[]{1});
            layout.addChild((Node)new Label("y:"), new Object[0]);
            layout.addChild(this.editors[1].editor, new Object[]{1});
        } else if (axis == Axis.X) {
            SpringGridLayout layout = new SpringGridLayout(Axis.X, Axis.Y, FillMode.ForcedEven, FillMode.Last);
            ((GuiControl)this.getControl(GuiControl.class)).setLayout((GuiLayout)layout);
            Container column = (Container)layout.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.Last)), new Object[0]);
            column.setBackground(null);
            column.addChild((Node)new Label("x:"), new Object[0]);
            column.addChild(this.editors[0].editor, new Object[0]);
            column = (Container)layout.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.Last)), new Object[0]);
            column.setBackground(null);
            column.addChild((Node)new Label("y:"), new Object[0]);
            column.addChild(this.editors[1].editor, new Object[0]);
        } else {
            throw new UnsupportedOperationException("Z axis not yet supported");
        }
    }

    public void setObject(Vector2f value) {
        if (this.value == value) {
            return;
        }
        this.value.set(value);
        ++this.version;
        this.resetView();
    }

    public Vector2f getObject() {
        return this.value;
    }

    public long getVersion() {
        return this.version;
    }

    public VersionedReference<Vector2f> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    protected void resetView() {
        for (EditorEntry e : this.editors) {
            e.resetView();
        }
    }

    public void setAxisModel(int axis, SequenceModel<Double> model) {
        this.editors[axis].setModel(model);
    }

    public SequenceModel<Double> getAxisModel(int axis) {
        return this.editors[axis].model;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        boolean changed = false;
        for (EditorEntry e : this.editors) {
            if (!e.update()) continue;
            changed = true;
        }
        if (changed) {
            ++this.version;
        }
    }

    private class EditorEntry {
        Spinner<Double> editor;
        SequenceModel<Double> model;
        VersionedReference<Double> valueRef;
        int index;

        public EditorEntry(int index, SequenceModel<Double> model, double precision) {
            this.index = index;
            this.model = model;
            this.valueRef = model.createReference();
            String format = precision < 0.001 ? "%.4f" : (precision < 0.01 ? "%.3f" : (precision < 0.1 ? "%.2f" : "%.1f"));
            DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)format, (String)"error");
            this.editor = new Spinner(model, (ValueRenderer)renderer);
            this.editor.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)format));
        }

        public void setModel(SequenceModel<Double> model) {
            if (this.model == model) {
                return;
            }
            this.model = model;
            this.editor.setModel(model);
            this.valueRef = model.createReference();
        }

        public void resetView() {
            float val = this.index == 0 ? ((Vector2fEditor)Vector2fEditor.this).value.x : ((Vector2fEditor)Vector2fEditor.this).value.y;
            this.model.setObject((Object)val);
        }

        public boolean update() {
            if (this.valueRef.update()) {
                double val = (Double)this.model.getObject();
                if (this.index == 0) {
                    ((Vector2fEditor)Vector2fEditor.this).value.x = (float)val;
                } else if (this.index == 1) {
                    ((Vector2fEditor)Vector2fEditor.this).value.y = (float)val;
                }
                return true;
            }
            return false;
        }
    }
}

