/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys;

import com.google.common.base.Predicate;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.phys.BlockColliderIterator;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.MBlockContact;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mblock.phys.collision.CubeCollider;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.CollisionSystem;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.ContactListener;
import com.simsilica.mphys.Hit;
import com.simsilica.mphys.HitResults;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;
import com.simsilica.mworld.BlockIterator;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBlockCollisionSystem<K>
implements CollisionSystem<K, MBlockShape> {
    static Logger log = LoggerFactory.getLogger(MBlockCollisionSystem.class);
    private double restitution = 0.1;
    private double friction = 0.7;
    private World world;
    private Collider[] colliders;
    boolean debug = false;

    public MBlockCollisionSystem(World world, Collider[] colliders) {
        this.world = world;
        this.colliders = colliders;
    }

    public BlockColliderIterator rayIterator(Rayd ray, double limit) {
        BlockIterator worldIterator = new BlockIterator(this.world, ray, limit);
        return new BlockColliderIterator(worldIterator, this.colliders);
    }

    public void setRestitution(double restitution) {
        this.restitution = restitution;
    }

    public double getRestitution() {
        return this.restitution;
    }

    public void setFriction(double friction) {
        this.friction = friction;
    }

    public double getFriction() {
        return this.friction;
    }

    public void generateWorldCollisions(RigidBody<K, MBlockShape> body, ContactListener<K, MBlockShape> results) {
        Part rootPart = ((MBlockShape)body.shape).getPart();
        this.generateWorldCollisions(rootPart, ((MBlockShape)body.shape).getMass().getCog(), body, results);
    }

    private void generateWorldCollisions(Part part, Vec3d rootCog, RigidBody<K, MBlockShape> body, ContactListener<K, MBlockShape> results) {
        if (part instanceof Group) {
            for (Part child : ((Group)part).traverse()) {
                this.generateWorldCollisions(child, rootCog, body, results);
            }
            return;
        }
        Vec3d cogPos = part.getShapeRelativeCog().subtract(rootCog);
        body.localToWorld(cogPos, cogPos);
        Vec3d partOrigin = part.getShapeRelativePosition().subtract(rootCog);
        body.localToWorld(partOrigin, partOrigin);
        Quatd partOrientation = body.orientation.mult(part.getShapeRelativeOrientation());
        double radius = part.getMass().getRadius();
        Vec3i min = LeafId.fromWorld((double)(cogPos.x - radius), (double)(cogPos.y - radius), (double)(cogPos.z - radius)).getWorld(null);
        Vec3i max = LeafId.fromWorld((double)(cogPos.x + radius), (double)(cogPos.y + radius), (double)(cogPos.z + radius)).getWorld(null);
        int size = 32;
        if (part instanceof CellArrayPart) {
            CellArrayPart cellPart = (CellArrayPart)part;
            Vec3d pos = new Vec3d();
            for (int x = min.x; x <= max.x; x += size) {
                for (int y = min.y; y <= max.y; y += size) {
                    block7: for (int z = min.z; z <= max.z; z += size) {
                        LeafId leafId = LeafId.fromWorld((int)x, (int)y, (int)z);
                        LeafData leaf = this.world.getLeaf(leafId);
                        if (leaf == null || leaf.isEmpty()) continue;
                        pos.set((double)x, (double)y, (double)z);
                        switch (cellPart.getType()) {
                            case Sphere: {
                                this.sphereToWorld(body, cogPos, radius, pos, leaf.getRawCells(), results);
                                continue block7;
                            }
                            case Blocks: {
                                this.blocksToWorld(body, cellPart, partOrigin, partOrientation, pos, leaf.getRawCells(), results);
                            }
                        }
                    }
                }
            }
        } else {
            Vec3d pos = new Vec3d();
            for (int x = min.x; x <= max.x; x += size) {
                for (int y = min.y; y <= max.y; y += size) {
                    for (int z = min.z; z <= max.z; z += size) {
                        LeafId leafId = LeafId.fromWorld((int)x, (int)y, (int)z);
                        LeafData leaf = this.world.getLeaf(leafId);
                        if (leaf == null || leaf.isEmpty()) continue;
                        pos.set((double)x, (double)y, (double)z);
                        this.sphereToWorld(body, cogPos, radius, pos, leaf.getRawCells(), results);
                    }
                }
            }
        }
    }

    private static Vec3d toNormal(Vec3d delta, double dist) {
        if (dist > 0.0) {
            return delta.mult(1.0 / dist);
        }
        log.trace("Random deflect.");
        delta.x = Math.random() * 0.1;
        delta.y = Math.random() * 0.1;
        delta.z = Math.random() * 0.1;
        return delta.normalizeLocal();
    }

    private static Vec3d toNormal(Vec3d delta, double dist, Vec3d fallback) {
        if (dist > 0.0) {
            return delta.mult(1.0 / dist);
        }
        if (fallback.lengthSq() == 1.0) {
            return fallback;
        }
        return MBlockCollisionSystem.toNormal(fallback, fallback.length());
    }

    private boolean broadPhase(AbstractBody<K, MBlockShape> b1, Part p1, AbstractBody<K, MBlockShape> b2, Part p2) {
        Vec3d cog1 = p1.getShapeRelativeCog().subtract(((MBlockShape)b1.shape).getPart().getMass().getCog());
        b1.localToWorld(cog1, cog1);
        Vec3d cog2 = p2.getShapeRelativeCog().subtract(((MBlockShape)b2.shape).getPart().getMass().getCog());
        b2.localToWorld(cog2, cog2);
        double distSq = cog1.distanceSq(cog2);
        double rrSq = p1.getMass().getRadius() + p2.getMass().getRadius();
        rrSq *= rrSq;
        return distSq <= rrSq;
    }

    private void checkStaticContact(RigidBody<K, MBlockShape> body, StaticBody<K, MBlockShape> world, ContactListener<K, MBlockShape> results) {
        if (!this.broadPhase((AbstractBody<K, MBlockShape>)body, ((MBlockShape)body.shape).getPart(), (AbstractBody<K, MBlockShape>)world, ((MBlockShape)world.shape).getPart())) {
            return;
        }
        Part[] arr1 = ((MBlockShape)body.shape).getPart().traverse();
        Part[] arr2 = ((MBlockShape)world.shape).getPart().traverse();
        for (int i = 0; i < arr1.length; ++i) {
            CellArrayPart p1 = (CellArrayPart)arr1[i];
            CellArrayPart.Type type1 = p1.getType();
            for (int j = 0; j < arr2.length; ++j) {
                CellArrayPart p2 = (CellArrayPart)arr2[j];
                CellArrayPart.Type type2 = p2.getType();
                if (type1 == type2) {
                    if (type1 == CellArrayPart.Type.Sphere) {
                        this.sphereToSphere(body, p1, (AbstractBody<K, MBlockShape>)world, p2, results);
                        continue;
                    }
                    this.blocksToBlocks(body, p1, (AbstractBody<K, MBlockShape>)world, p2, results);
                    continue;
                }
                if (type1 == CellArrayPart.Type.Sphere) {
                    this.sphereToBlocks(body, p1, (AbstractBody<K, MBlockShape>)world, p2, results);
                    continue;
                }
                if (type1 == CellArrayPart.Type.Blocks) {
                    this.sphereToSphere(body, p1, (AbstractBody<K, MBlockShape>)world, p2, results);
                    continue;
                }
                throw new UnsupportedOperationException((Object)((Object)type1) + " to " + (Object)((Object)type2) + " collisions not yet supported.");
            }
        }
    }

    private void checkContact(RigidBody<K, MBlockShape> b1, RigidBody<K, MBlockShape> b2, ContactListener<K, MBlockShape> results) {
        if (b1.shape == null) {
            throw new IllegalArgumentException("Body:" + b1.id + " has null shape");
        }
        if (b2.shape == null) {
            throw new IllegalArgumentException("Body:" + b2.id + " has null shape");
        }
        if (!this.broadPhase((AbstractBody<K, MBlockShape>)b1, ((MBlockShape)b1.shape).getPart(), (AbstractBody<K, MBlockShape>)b2, ((MBlockShape)b2.shape).getPart())) {
            return;
        }
        Part[] arr1 = ((MBlockShape)b1.shape).getPart().traverse();
        Part[] arr2 = ((MBlockShape)b2.shape).getPart().traverse();
        for (int i = 0; i < arr1.length; ++i) {
            CellArrayPart p1 = (CellArrayPart)arr1[i];
            CellArrayPart.Type type1 = p1.getType();
            for (int j = 0; j < arr2.length; ++j) {
                CellArrayPart p2 = (CellArrayPart)arr2[j];
                CellArrayPart.Type type2 = p2.getType();
                if (type1 == type2) {
                    double priority2;
                    if (type1 == CellArrayPart.Type.Sphere) {
                        this.sphereToSphere(b1, p1, (AbstractBody<K, MBlockShape>)b2, p2, results);
                        continue;
                    }
                    double priority1 = p1.getBlockCollisionPriority();
                    if (priority1 <= (priority2 = p2.getBlockCollisionPriority())) {
                        this.blocksToBlocks(b1, p1, (AbstractBody<K, MBlockShape>)b2, p2, results);
                        continue;
                    }
                    this.blocksToBlocks(b2, p2, (AbstractBody<K, MBlockShape>)b1, p1, results);
                    continue;
                }
                if (type1 == CellArrayPart.Type.Sphere) {
                    this.sphereToBlocks(b1, p1, (AbstractBody<K, MBlockShape>)b2, p2, results);
                    continue;
                }
                if (type1 == CellArrayPart.Type.Blocks) {
                    this.sphereToBlocks(b2, p2, (AbstractBody<K, MBlockShape>)b1, p1, results);
                    continue;
                }
                throw new UnsupportedOperationException((Object)((Object)type1) + " to " + (Object)((Object)type2) + " collisions not yet supported.");
            }
        }
    }

    public void generateStaticCollisions(RigidBody<K, MBlockShape> body, StaticBody<K, MBlockShape>[] staticObjects, ContactListener<K, MBlockShape> results) {
        for (StaticBody<K, MBlockShape> world : staticObjects) {
            this.checkStaticContact(body, world, results);
        }
    }

    public void generateBodyCollisions(RigidBody<K, MBlockShape> body, RigidBody<K, MBlockShape>[] inactiveObjects, ContactListener<K, MBlockShape> results) {
        for (RigidBody<K, MBlockShape> sleeper : inactiveObjects) {
            this.checkContact(body, sleeper, results);
        }
    }

    public void generateBodyCollisions(RigidBody<K, MBlockShape>[] bodies, ContactListener<K, MBlockShape> results) {
        for (int i = 0; i < bodies.length; ++i) {
            RigidBody<K, MBlockShape> b1 = bodies[i];
            for (int j = i + 1; j < bodies.length; ++j) {
                RigidBody<K, MBlockShape> b2 = bodies[j];
                this.checkContact(b1, b2, results);
            }
        }
    }

    public void generateStaticCollisions(RigidBody<K, MBlockShape> body, StaticBody<K, MBlockShape>[] staticObjects, Predicate<? super StaticBody<K, MBlockShape>> bodyFilter, ContactListener<K, MBlockShape> results) {
        for (StaticBody<K, MBlockShape> world : staticObjects) {
            if (!bodyFilter.apply(world)) continue;
            this.checkStaticContact(body, world, results);
        }
    }

    public void generateBodyCollisions(RigidBody<K, MBlockShape> body, RigidBody<K, MBlockShape>[] inactiveObjects, Predicate<? super RigidBody<K, MBlockShape>> bodyFilter, ContactListener<K, MBlockShape> results) {
        for (RigidBody<K, MBlockShape> sleeper : inactiveObjects) {
            if (!bodyFilter.apply(sleeper)) continue;
            this.checkContact(body, sleeper, results);
        }
    }

    private boolean inRange(AbstractBody b1, AbstractBody b2) {
        double r1 = b1.shape.getMass().getRadius();
        double r2 = b2.shape.getMass().getRadius();
        double threshold = (r1 + r2) * (r1 + r2);
        double distSq = b1.position.distanceSq(b2.position);
        return distSq <= threshold;
    }

    private Collider getCollider(int type) {
        return this.colliders[type];
    }

    private void sphereToSphere(RigidBody<K, MBlockShape> b1, Part p1, AbstractBody<K, MBlockShape> b2, Part p2, ContactListener<K, MBlockShape> results) {
        Vec3d cp;
        Vec3d cog1 = p1.getShapeRelativeCog().subtract(((MBlockShape)b1.shape).getPart().getMass().getCog());
        b1.localToWorld(cog1, cog1);
        Vec3d cog2 = p2.getShapeRelativeCog().subtract(((MBlockShape)b2.shape).getPart().getMass().getCog());
        b2.localToWorld(cog2, cog2);
        double r1 = p1.getMass().getRadius();
        double r2 = p2.getMass().getRadius();
        double threshold = (r1 + r2) * (r1 + r2);
        double distSq = cog1.distanceSq(cog2);
        if (distSq > threshold) {
            return;
        }
        double dist = Math.sqrt(distSq);
        if (dist > 0.0) {
            Vec3d delta = cog1.subtract(cog2);
            cp = delta.multLocal(r2 / dist).addLocal(cog2);
        } else {
            cp = cog1;
        }
        Vec3d cn = MBlockCollisionSystem.toNormal(cog1.subtract(cog2), dist);
        double penetration = r1 - (dist - r2);
        MBlockContact<K> contact = new MBlockContact<K>(b1, b2, cp, cn, penetration);
        contact.part1 = p1;
        contact.part2 = p2;
        contact.restitution = this.restitution;
        contact.friction = this.friction;
        if (log.isTraceEnabled()) {
            log.trace("sphereToSphere(): Contact:" + contact);
        }
        results.newContact(contact);
    }

    private void sphereToBlocks(RigidBody<K, MBlockShape> b1, CellArrayPart p1, AbstractBody<K, MBlockShape> b2, CellArrayPart p2, ContactListener<K, MBlockShape> results) {
        Vec3d world = p1.getWorldPosition((AbstractBody<?, MBlockShape>)b1, null);
        if (this.debug) {
            System.out.println("Sphere world:" + world + "\nblocks world:" + p2.getWorldPosition(b2, null));
        }
        Vec3d local = b2.worldToLocal(world, null);
        if (this.debug) {
            System.out.println("raw local:" + local);
        }
        if (this.debug) {
            System.out.println("part cog:" + ((MBlockShape)b2.shape).getPart().getMass().getCog());
        }
        local.addLocal(((MBlockShape)b2.shape).getPart().getMass().getCog());
        if (this.debug) {
            System.out.println("adjusted local:" + local);
        }
        Vec3d spherePos = p2.shapeToCell(local, null);
        if (this.debug) {
            System.out.println("Sphere in local:" + spherePos);
        }
        double sphereRadius = p1.getRadius() * p1.getScale();
        double localRadius = sphereRadius / p2.getScale();
        if (this.debug) {
            System.out.println("Sphere world radius:" + sphereRadius + "  localRadius:" + localRadius);
        }
        int xStart = (int)Math.floor(spherePos.x - localRadius);
        int yStart = (int)Math.floor(spherePos.y - localRadius);
        int zStart = (int)Math.floor(spherePos.z - localRadius);
        int xEnd = (int)Math.floor(spherePos.x + localRadius);
        int yEnd = (int)Math.floor(spherePos.y + localRadius);
        int zEnd = (int)Math.floor(spherePos.z + localRadius);
        if (this.debug) {
            System.out.println("start:" + xStart + ", " + yStart + ", " + zStart);
            System.out.println("end:" + xEnd + ", " + yEnd + ", " + zEnd);
        }
        CellArray cells = p2.getCells();
        int sx = cells.getSizeX();
        int sy = cells.getSizeY();
        int sz = cells.getSizeZ();
        if (this.debug) {
            System.out.println("cell array size:" + sx + ", " + sy + ", " + sz);
        }
        if (xStart >= sx) {
            if (this.debug) {
                System.out.println("x too high");
            }
            return;
        }
        if (yStart >= sy) {
            if (this.debug) {
                System.out.println("y too high");
            }
            return;
        }
        if (zStart >= sz) {
            if (this.debug) {
                System.out.println("z too high");
            }
            return;
        }
        if (xEnd < 0) {
            if (this.debug) {
                System.out.println("x too low");
            }
            return;
        }
        if (yEnd < 0) {
            if (this.debug) {
                System.out.println("y too low");
            }
            return;
        }
        if (zEnd < 0) {
            if (this.debug) {
                System.out.println("z too low");
            }
            return;
        }
        if (xStart < 0) {
            xStart = 0;
        }
        if (yStart < 0) {
            yStart = 0;
        }
        if (zStart < 0) {
            zStart = 0;
        }
        if (xEnd >= sx) {
            xEnd = sx - 1;
        }
        if (yEnd >= sy) {
            yEnd = sy - 1;
        }
        if (zEnd >= sz) {
            zEnd = sz - 1;
        }
        if (this.debug) {
            System.out.println("clamped start:" + xStart + ", " + yStart + ", " + zStart);
            System.out.println("clamped end:" + xEnd + ", " + yEnd + ", " + zEnd);
        }
        Vec3d cellPos = new Vec3d();
        for (int i = xStart; i <= xEnd; ++i) {
            for (int j = yStart; j <= yEnd; ++j) {
                for (int k = zStart; k <= zEnd; ++k) {
                    int type;
                    Collider collider;
                    int val = cells.getCell(i, j, k);
                    if (val == 0 || (collider = this.getCollider(type = MaskUtils.getType((int)val))) == null) continue;
                    int mask = MaskUtils.getSideMask((int)val);
                    cellPos.set((double)i, (double)j, (double)k);
                    CubeCollider.debug = this.debug;
                    MBlockContact c = collider.getSphereContact(cellPos, spherePos, localRadius, mask);
                    if (c == null) continue;
                    c.part1 = p1;
                    c.part2 = p2;
                    c.type2 = type;
                    p2.cellToWorld(b2, c.contactPoint, c.contactPoint);
                    p2.getShapeRelativeOrientation().mult(c.contactNormal, c.contactNormal);
                    b2.orientation.mult(c.contactNormal, c.contactNormal);
                    c.penetration *= p2.getScale();
                    c.setBodies(b1, b2);
                    if (log.isTraceEnabled()) {
                        log.trace("spherToBlocks(): Contact:" + (Object)((Object)c));
                    }
                    results.newContact((Contact)c);
                }
            }
        }
    }

    private void blocksToBlocks(RigidBody<K, MBlockShape> b1, CellArrayPart p1, AbstractBody<K, MBlockShape> b2, CellArrayPart p2, ContactListener<K, MBlockShape> results) {
        double targetCellSize = p2.getScale();
        double sourceCellSize = p1.getScale();
        Vec3d corner = p1.cellToWorld((AbstractBody<?, MBlockShape>)b1, new Vec3d(0.5, 0.5, 0.5), null);
        Vec3d xAxis = new Vec3d(1.0, 0.0, 0.0);
        int xStart = 0;
        int xStep = 1;
        Vec3d yAxis = new Vec3d(0.0, 1.0, 0.0);
        int yStart = 0;
        int yStep = 1;
        Vec3d zAxis = new Vec3d(0.0, 0.0, 1.0);
        int zStart = 0;
        int zStep = 1;
        Quatd orient = p1.getShapeRelativeOrientation();
        orient = b1.orientation.mult(orient);
        orient.mult(xAxis, xAxis);
        orient.mult(yAxis, yAxis);
        orient.mult(zAxis, zAxis);
        Vec3d sourceCorner = p2.worldToCell(b2, corner, null);
        Quatd toBody = b2.orientation.inverse();
        Quatd toPart = p2.getShapeRelativeOrientation().inverse().mult(toBody);
        toPart.mult(xAxis, xAxis);
        toPart.mult(yAxis, yAxis);
        toPart.mult(zAxis, zAxis);
        double sourceBlockSize = p1.getScale() / p2.getScale();
        double cellRadius = sourceBlockSize * 0.5;
        xAxis.multLocal(sourceBlockSize);
        yAxis.multLocal(sourceBlockSize);
        zAxis.multLocal(sourceBlockSize);
        CellArray sourceCells = p1.getCells();
        CellArray targetCells = p2.getCells();
        int xSize = sourceCells.getSizeX();
        int ySize = sourceCells.getSizeY();
        int zSize = sourceCells.getSizeZ();
        int xTargetSize = targetCells.getSizeX();
        int yTargetSize = targetCells.getSizeY();
        int zTargetSize = targetCells.getSizeZ();
        Vec3d px = sourceCorner.clone();
        Vec3d py = new Vec3d();
        Vec3d pz = new Vec3d();
        int sx = xStart;
        int i = 0;
        while (i < xSize) {
            py.set(px);
            int sy = yStart;
            int j = 0;
            while (j < ySize) {
                pz.set(py);
                int sz = zStart;
                int k = 0;
                while (k < zSize) {
                    int sourceType;
                    int sourceVal = sourceCells.getCell(sx, sy, sz);
                    if (sourceVal != 0 && (sourceType = MaskUtils.getType((int)sourceVal)) != 0) {
                        int xMin = Math.max(0, (int)Math.floor(pz.x - cellRadius));
                        int yMin = Math.max(0, (int)Math.floor(pz.y - cellRadius));
                        int zMin = Math.max(0, (int)Math.floor(pz.z - cellRadius));
                        int xMax = Math.min(xTargetSize - 1, (int)Math.ceil(pz.x + cellRadius));
                        int yMax = Math.min(yTargetSize - 1, (int)Math.ceil(pz.y + cellRadius));
                        int zMax = Math.min(zTargetSize - 1, (int)Math.ceil(pz.z + cellRadius));
                        Vec3d targetPos = new Vec3d();
                        for (int tx = xMin; tx <= xMax; ++tx) {
                            for (int ty = yMin; ty <= yMax; ++ty) {
                                for (int tz = zMin; tz <= zMax; ++tz) {
                                    int mask;
                                    Collider collider;
                                    int targetType;
                                    int targetVal = targetCells.getCell(tx, ty, tz);
                                    if (targetVal == 0 || (targetType = MaskUtils.getType((int)targetVal)) == 0 || (collider = this.getCollider(targetType)) == null || (mask = MaskUtils.getSideMask((int)targetVal)) == 0) continue;
                                    targetPos.set((double)tx, (double)ty, (double)tz);
                                    MBlockContact c = collider.getCubeContact(targetPos, pz, cellRadius, mask);
                                    if (c == null) continue;
                                    c.part1 = p1;
                                    c.type1 = sourceType;
                                    c.part2 = p2;
                                    c.type2 = targetType;
                                    p2.cellToWorld(b2, c.contactPoint, c.contactPoint);
                                    p2.getShapeRelativeOrientation().mult(c.contactNormal, c.contactNormal);
                                    b2.orientation.mult(c.contactNormal, c.contactNormal);
                                    c.penetration *= p2.getScale();
                                    c.setBodies(b1, b2);
                                    if (log.isTraceEnabled()) {
                                        log.trace("blocksToBlocks(): Contact:" + (Object)((Object)c));
                                    }
                                    results.newContact((Contact)c);
                                }
                            }
                        }
                    }
                    ++k;
                    pz.addLocal(zAxis);
                    sz += zStep;
                }
                ++j;
                py.addLocal(yAxis);
                sy += yStep;
            }
            ++i;
            px.addLocal(xAxis);
            sx += xStep;
        }
    }

    private void blocksToWorld(RigidBody<K, MBlockShape> body, CellArrayPart part, Vec3d sourceOrigin, Quatd sourceOrientation, Vec3d worldLoc, CellArray worldCells, ContactListener<K, MBlockShape> results) {
        Vec3d corner = new Vec3d(0.5, 0.5, 0.5).multLocal(part.getScale());
        corner = sourceOrientation.mult(corner, corner);
        corner.addLocal(sourceOrigin);
        Vec3d xAxis = new Vec3d(1.0, 0.0, 0.0);
        int xStart = 0;
        int xStep = 1;
        Vec3d yAxis = new Vec3d(0.0, 1.0, 0.0);
        int yStart = 0;
        int yStep = 1;
        Vec3d zAxis = new Vec3d(0.0, 0.0, 1.0);
        int zStart = 0;
        int zStep = 1;
        sourceOrientation.mult(xAxis, xAxis);
        sourceOrientation.mult(yAxis, yAxis);
        sourceOrientation.mult(zAxis, zAxis);
        Vec3d sourceCorner = corner.subtract(worldLoc);
        double sourceBlockSize = part.getScale();
        double cellRadius = sourceBlockSize * 0.5;
        xAxis.multLocal(sourceBlockSize);
        yAxis.multLocal(sourceBlockSize);
        zAxis.multLocal(sourceBlockSize);
        CellArray sourceCells = part.getCells();
        int xSize = sourceCells.getSizeX();
        int ySize = sourceCells.getSizeY();
        int zSize = sourceCells.getSizeZ();
        int xTargetSize = worldCells.getSizeX();
        int yTargetSize = worldCells.getSizeY();
        int zTargetSize = worldCells.getSizeZ();
        Vec3d px = sourceCorner.clone();
        Vec3d py = new Vec3d();
        Vec3d pz = new Vec3d();
        int sx = xStart;
        int i = 0;
        while (i < xSize) {
            py.set(px);
            int sy = yStart;
            int j = 0;
            while (j < ySize) {
                pz.set(py);
                int sz = zStart;
                int k = 0;
                while (k < zSize) {
                    int sourceType;
                    int sourceVal = sourceCells.getCell(sx, sy, sz);
                    if (sourceVal != 0 && (sourceType = MaskUtils.getType((int)sourceVal)) != 0) {
                        int xMin = Math.max(0, (int)Math.floor(pz.x - cellRadius));
                        int yMin = Math.max(0, (int)Math.floor(pz.y - cellRadius));
                        int zMin = Math.max(0, (int)Math.floor(pz.z - cellRadius));
                        int xMax = Math.min(xTargetSize - 1, (int)Math.ceil(pz.x + cellRadius));
                        int yMax = Math.min(yTargetSize - 1, (int)Math.ceil(pz.y + cellRadius));
                        int zMax = Math.min(zTargetSize - 1, (int)Math.ceil(pz.z + cellRadius));
                        Vec3d targetPos = new Vec3d();
                        for (int tx = xMin; tx <= xMax; ++tx) {
                            for (int ty = yMin; ty <= yMax; ++ty) {
                                for (int tz = zMin; tz <= zMax; ++tz) {
                                    int mask;
                                    Collider collider;
                                    int targetType;
                                    int targetVal = worldCells.getCell(tx, ty, tz);
                                    if (targetVal == 0 || (targetType = MaskUtils.getType((int)targetVal)) == 0 || (collider = this.getCollider(targetType)) == null || (mask = MaskUtils.getSideMask((int)targetVal)) == 0) continue;
                                    targetPos.set((double)tx, (double)ty, (double)tz);
                                    MBlockContact c = collider.getCubeContact(targetPos, pz, cellRadius, mask);
                                    if (c == null) continue;
                                    c.part1 = part;
                                    c.type1 = sourceType;
                                    c.type2 = targetType;
                                    c.contactPoint = worldLoc.add(c.contactPoint);
                                    c.setBodies(body, null);
                                    if (log.isTraceEnabled()) {
                                        log.trace("blocksToWorld(): Contact:" + (Object)((Object)c));
                                    }
                                    results.newContact((Contact)c);
                                }
                            }
                        }
                    }
                    ++k;
                    pz.addLocal(zAxis);
                    sz += zStep;
                }
                ++j;
                py.addLocal(yAxis);
                sy += yStep;
            }
            ++i;
            px.addLocal(xAxis);
            sx += xStep;
        }
    }

    private void sphereToWorld(RigidBody<K, MBlockShape> body, Vec3d sphereLoc, double radius, Vec3d worldLoc, CellArray worldCells, ContactListener<K, MBlockShape> results) {
        Vec3d pos = sphereLoc.subtract(worldLoc);
        CellArray cells = worldCells;
        int xStart = (int)Math.floor(pos.x - radius);
        int yStart = (int)Math.floor(pos.y - radius);
        int zStart = (int)Math.floor(pos.z - radius);
        int xEnd = (int)Math.floor(pos.x + radius);
        int yEnd = (int)Math.floor(pos.y + radius);
        int zEnd = (int)Math.floor(pos.z + radius);
        int sx = cells.getSizeX();
        int sy = cells.getSizeY();
        int sz = cells.getSizeZ();
        if (xStart >= sx) {
            return;
        }
        if (yStart >= sy) {
            return;
        }
        if (zStart >= sz) {
            return;
        }
        if (xEnd < 0) {
            return;
        }
        if (yEnd < 0) {
            return;
        }
        if (zEnd < 0) {
            return;
        }
        if (xStart < 0) {
            xStart = 0;
        }
        if (yStart < 0) {
            yStart = 0;
        }
        if (zStart < 0) {
            zStart = 0;
        }
        if (xEnd >= sx) {
            xEnd = sx - 1;
        }
        if (yEnd >= sy) {
            yEnd = sy - 1;
        }
        if (zEnd >= sz) {
            zEnd = sz - 1;
        }
        Vec3d cellPos = new Vec3d();
        for (int i = xStart; i <= xEnd; ++i) {
            for (int j = yStart; j <= yEnd; ++j) {
                for (int k = zStart; k <= zEnd; ++k) {
                    int type;
                    Collider collider;
                    int val = cells.getCell(i, j, k);
                    if (val == 0 || (collider = this.getCollider(type = MaskUtils.getType((int)val))) == null) continue;
                    int mask = MaskUtils.getSideMask((int)val);
                    cellPos.set((double)i, (double)j, (double)k);
                    CubeCollider.debug = false;
                    MBlockContact c = collider.getSphereContact(cellPos, pos, radius, mask);
                    if (c == null) continue;
                    c.part1 = ((MBlockShape)body.shape).getPart();
                    c.type2 = type;
                    c.contactPoint = worldLoc.add(c.contactPoint);
                    c.setBodies(body, null);
                    if (log.isTraceEnabled()) {
                        log.trace("sphereToWorld(): Contact:" + (Object)((Object)c));
                    }
                    results.newContact((Contact)c);
                }
            }
        }
    }

    public void queryWorldHits(Rayd ray, HitResults<K, MBlockShape> hits) {
        log.warn("queryWorldHits() not yet implemented.");
    }

    public void queryBodyHits(Rayd ray, RigidBody<K, MBlockShape>[] bodies, HitResults<K, MBlockShape> hits) {
        for (RigidBody<K, MBlockShape> body : bodies) {
            this.queryBody(ray, (AbstractBody<K, MBlockShape>)body, hits);
        }
    }

    public void queryStaticHits(Rayd ray, StaticBody<K, MBlockShape>[] staticObjects, HitResults<K, MBlockShape> hits) {
        for (StaticBody<K, MBlockShape> body : staticObjects) {
            this.queryBody(ray, (AbstractBody<K, MBlockShape>)body, hits);
        }
    }

    protected boolean broadPhase(Rayd ray, AbstractBody<K, MBlockShape> body, Part part, double limit) {
        Vec3d cog = part.getShapeRelativeCog().subtract(((MBlockShape)body.shape).getPart().getMass().getCog());
        body.localToWorld(cog, cog);
        double distSq = ray.distanceSq(cog, limit);
        double rSq = part.getMass().getRadius();
        rSq *= rSq;
        return distSq <= rSq;
    }

    protected void queryBody(Rayd ray, AbstractBody<K, MBlockShape> body, HitResults<K, MBlockShape> hits) {
        Part[] arr;
        double limit = hits.getMaxDistance();
        if (!this.broadPhase(ray, body, ((MBlockShape)body.shape).getPart(), limit)) {
            return;
        }
        Hit best = null;
        double minDist = limit == 0.0 ? Double.POSITIVE_INFINITY : limit;
        for (Part part : arr = ((MBlockShape)body.shape).getPart().traverse()) {
            Hit hit;
            CellArrayPart p = (CellArrayPart)part;
            CellArrayPart.Type type = p.getType();
            switch (type) {
                default: {
                    hit = this.rayToSphere(ray, limit, body, p);
                    break;
                }
                case Blocks: {
                    hit = this.rayToBlocks(ray, limit, body, p);
                }
            }
            if (hit == null || !(hit.distance < minDist)) continue;
            best = hit;
            minDist = hit.distance;
        }
        if (best != null) {
            hits.addHit(best);
        }
    }

    protected Hit rayToSphere(Rayd ray, double limit, AbstractBody<K, MBlockShape> body, CellArrayPart part) {
        if (((MBlockShape)body.shape).getPart() != part) {
            // empty if block
        }
        Vec3d center = part.getShapeRelativeCog().subtract(((MBlockShape)body.shape).getPart().getMass().getCog());
        body.localToWorld(center, center);
        double radius = part.getMass().getRadius();
        double distance = ray.intersectSphere(limit, center, radius, true);
        if (distance < 0.0) {
            return null;
        }
        Vec3d point = ray.project(distance, null);
        Vec3d normal = point.subtract(center).normalizeLocal();
        return new Hit(body, point, normal, distance);
    }

    protected Hit rayToBlocks(Rayd ray, double limit, AbstractBody<K, MBlockShape> body, CellArrayPart part) {
        if (((MBlockShape)body.shape).getPart() != part && !this.broadPhase(ray, body, part, limit)) {
            return null;
        }
        Vec3d orig = part.worldToCell(body, ray.getOrigin(), null);
        Quatd toBody = body.orientation.inverse();
        Quatd toPart = part.getShapeRelativeOrientation().inverse().mult(toBody);
        Vec3d dir = toPart.mult(ray.getDirection());
        double scaledLimit = limit / part.getScale();
        CellArray cells = part.getCells();
        double xSize = cells.getSizeX();
        double ySize = cells.getSizeY();
        double zSize = cells.getSizeZ();
        double xDist = 0.0;
        if (orig.x < 0.0) {
            if (dir.x <= 0.0) {
                return null;
            }
            xDist = -orig.x / dir.x;
        } else if (orig.x > xSize) {
            if (dir.x >= 0.0) {
                return null;
            }
            xDist = (orig.x - xSize) / -dir.x;
        }
        double yDist = 0.0;
        if (orig.y < 0.0) {
            if (dir.y <= 0.0) {
                return null;
            }
            yDist = -orig.y / dir.y;
        } else if (orig.y > ySize) {
            if (dir.y >= 0.0) {
                return null;
            }
            yDist = (orig.y - ySize) / -dir.y;
        }
        double zDist = 0.0;
        if (orig.z < 0.0) {
            if (dir.z <= 0.0) {
                return null;
            }
            zDist = -orig.z / dir.z;
        } else if (orig.z > zSize) {
            if (dir.z >= 0.0) {
                return null;
            }
            zDist = (orig.z - zSize) / -dir.z;
        }
        double dist = Math.max(xDist, Math.max(yDist, zDist));
        orig.addLocal(dir.x * dist, dir.y * dist, dir.z * dist);
        if (orig.x < 0.0 || orig.x > xSize) {
            return null;
        }
        if (orig.y < 0.0 || orig.y > ySize) {
            return null;
        }
        if (orig.z < 0.0 || orig.z > zSize) {
            return null;
        }
        Vec3d point = orig;
        part.cellToWorld(body, point, point);
        Vec3d normal = new Vec3d(0.0, 1.0, 0.0);
        return new Hit(body, point, normal, dist);
    }
}

