/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec;

import com.google.common.io.Files;
import com.jme3.asset.DesktopAssetManager;
import com.jme3.asset.ModelKey;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.scene.Spatial;
import com.simsilica.jmec.gltf.GltfExtrasLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetReader {
    public static final String DESKTOP_ASSET_CONFIG = "/com/jme3/asset/Desktop.cfg";
    static Logger log = LoggerFactory.getLogger(AssetReader.class);
    private Path root;
    private DesktopAssetManager assets;

    public AssetReader() {
        this(new File("."));
    }

    public AssetReader(File assetRoot) {
        this(assetRoot, null);
    }

    public AssetReader(File assetRoot, URL assetConfig) {
        try {
            this.root = assetRoot.getCanonicalFile().toPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Error getting canonical path for:" + assetRoot, e);
        }
        log.info("Using source asset root:" + this.root);
        if (assetConfig == null) {
            assetConfig = this.getClass().getResource(DESKTOP_ASSET_CONFIG);
            log.info("Found assetConfig:" + assetConfig);
        }
        this.assets = new DesktopAssetManager(assetConfig);
        this.assets.registerLocator(this.root.toString(), FileLocator.class);
    }

    public DesktopAssetManager getAssetManager() {
        return this.assets;
    }

    public Spatial loadModel(File f) {
        log.debug("loadModel(" + f + ")");
        if (!f.exists()) {
            throw new IllegalArgumentException("Model file does not exist:" + f);
        }
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("File cannot be converted to canonical path:" + f, e);
        }
        String path = this.root.relativize(f.getAbsoluteFile().toPath()).toString();
        log.info("Loading asset:" + path);
        this.assets.clearCache();
        String extension = Files.getFileExtension((String)f.getName());
        if ("gltf".equalsIgnoreCase(extension) || "glb".equalsIgnoreCase(extension)) {
            return this.assets.loadModel((ModelKey)GltfExtrasLoader.createModelKey(path));
        }
        return this.assets.loadModel(path);
    }
}

