/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec;

import com.google.common.io.Files;
import com.jme3.asset.AssetKey;
import com.jme3.asset.CloneableSmartAsset;
import com.jme3.asset.ModelKey;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.material.Material;
import com.jme3.material.plugin.export.material.J3MExporter;
import com.jme3.scene.AssetLinkNode;
import com.jme3.scene.Spatial;
import com.simsilica.jmec.ModelInfo;
import com.simsilica.jmec.ModelProcessor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetWriter
implements ModelProcessor {
    static Logger log = LoggerFactory.getLogger(AssetWriter.class);
    private static J3MExporter j3mExporter = new J3MExporter();
    private File target;
    private String assetPath;

    public void setTarget(File target) {
        this.target = target;
    }

    public void setAssetPath(String path) {
        this.assetPath = path;
    }

    protected String toTargetPath(AssetKey key) {
        if (this.assetPath != null) {
            return this.assetPath + "/" + key.getName();
        }
        return key.getName();
    }

    protected String toTargetPath(String path) {
        if (this.assetPath != null) {
            return this.assetPath + "/" + path;
        }
        return path;
    }

    @Override
    public void apply(ModelInfo info) {
        try {
            this.write(info);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing model:" + info.getModelName(), e);
        }
    }

    public void write(ModelInfo info) throws IOException {
        String path;
        AssetKey key;
        for (ModelInfo.Dependency dep : info.getDependencies()) {
            if (dep.getSourceFile() == null) continue;
            key = dep.getKey();
            path = this.toTargetPath(key);
            File f = new File(this.target, path);
            f.getParentFile().mkdirs();
            if (dep.getSourceFile() != null) {
                log.info("Copying:" + dep.getSourceFile() + " to:" + f);
                Files.copy((File)dep.getSourceFile(), (File)f);
            }
            AssetKey newKey = AssetWriter.rehome(path, key);
            dep.setKey(newKey);
        }
        for (ModelInfo.Dependency dep : info.getDependencies()) {
            if (dep.getSourceFile() != null) continue;
            key = dep.getKey();
            path = this.toTargetPath(key);
            AssetKey newKey = AssetWriter.rehome(path, key);
            File f = new File(this.target, path);
            f.getParentFile().mkdirs();
            dep.setKey(newKey);
            this.generateDependency(f, dep);
        }
        File outFile = new File(this.target, this.toTargetPath(info.getModelName() + ".j3o"));
        log.info("Writing:" + outFile);
        BinaryExporter.getInstance().save((Savable)info.getModelRoot(), outFile);
    }

    protected void generateDependency(File file, ModelInfo.Dependency dep) throws IOException {
        CloneableSmartAsset asset = dep.getInstances().get(0);
        if (asset instanceof Material) {
            this.writeJ3m(file, dep, (Material)asset);
        } else if (asset instanceof AssetLinkNode) {
            this.writeLinkedAsset(file, dep, (AssetLinkNode)asset);
        } else {
            throw new UnsupportedOperationException("Type not supported for generation:" + asset);
        }
    }

    protected void writeJ3m(File file, ModelInfo.Dependency dep, Material material) throws IOException {
        log.info("Writing material:" + file);
        j3mExporter.save((Savable)material, file);
    }

    protected void writeLinkedAsset(File file, ModelInfo.Dependency dep, AssetLinkNode link) throws IOException {
        log.info("Writing linked asset:" + file + "  for key:" + dep.getKey());
        if (link.getChildren().size() != 1) {
            log.warn("Not writing AssetLinkNode:" + link);
            return;
        }
        Spatial child = (Spatial)link.getChildren().get(0);
        BinaryExporter.getInstance().save((Savable)child, file);
        link.detachLinkedChildren();
        link.getAssetLoaderKeys().clear();
        link.addLinkedChild((ModelKey)dep.getKey());
    }

    private static AssetKey rehome(String newPath, AssetKey key) {
        try {
            AssetKey temp = new AssetKey(newPath);
            AssetKey result = key.clone();
            Field field = AssetKey.class.getDeclaredField("folder");
            field.setAccessible(true);
            field.set(result, field.get(temp));
            field = AssetKey.class.getDeclaredField("name");
            field.setAccessible(true);
            field.set(result, field.get(temp));
            field = AssetKey.class.getDeclaredField("extension");
            field.setAccessible(true);
            field.set(result, field.get(temp));
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Error rehoming key:" + key, e);
        }
    }
}

