/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    static Logger log = LoggerFactory.getLogger(BuildInfo.class);
    private static Properties props = new Properties();

    public static String getVersion() {
        return BuildInfo.get("git.build.version", "1.unknown");
    }

    public static String getBuildTime() {
        return BuildInfo.get("git.build.time", BuildInfo.get("build.date", "Unknown"));
    }

    public static String get(String name, String defaultValue) {
        return props.getProperty(name, defaultValue);
    }

    public static void load(String classResource) throws IOException {
        URL u = BuildInfo.class.getResource(classResource);
        if (u == null) {
            log.warn("No build info at:" + classResource);
        }
        log.debug("Loading build info from:" + u);
        try (InputStream in = u.openStream();){
            props.load(in);
        }
    }

    static {
        try {
            BuildInfo.load("/git.properties");
        }
        catch (IOException e) {
            log.error("Error reading git.properties", (Throwable)e);
        }
        try {
            BuildInfo.load("/jmec.build.date");
        }
        catch (IOException e) {
            log.error("Error reading jmec.build.date", (Throwable)e);
        }
    }
}

