/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec;

import com.jme3.scene.Spatial;
import com.simsilica.jmec.AssetReader;
import com.simsilica.jmec.AssetWriter;
import com.simsilica.jmec.BuildInfo;
import com.simsilica.jmec.JulLogSetup;
import com.simsilica.jmec.ModelInfo;
import com.simsilica.jmec.ModelProcessor;
import com.simsilica.jmec.ModelScript;
import com.simsilica.jmec.Probe;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Convert {
    public static final String[] HEADER = new String[]{"        _   __  __   ___    ___ ", "     _ | | |  \\/  | | __|  / __|", "    | || | | |\\/| | | _|  | (__ ", "     \\__/  |_|  |_| |___|  \\___|", "", "    JME3 Asset Converter v" + BuildInfo.getVersion() + " build:" + BuildInfo.getBuildTime(), ""};
    public static final String ALL_PROBE_OPTIONS = "btrscpdu";
    public static final String[] HELP = new String[]{"Usage: jmec [options] [models]", "", "Where [models] are a list of JME-compatible model files.", "", "Where [options] are:", " -sourceRoot <dir> : specifies the asset root for the models.", "       Model dependency paths will be evaluated relative to this root.", "", " -targetRoot <dir> : specifies the asset target root for writing", "       converted assets and their dependencies.", "", " -targetPath <path> : a path string specifying where to place", "       the copied/converted assets within the targetRoot.  Any", "       internal asset keys will be 'rehomed' to this path.", "", " -script <path> : a script file that will be run against the model", "       before writing out.  Any number of script files can be specified", "       and they will be run in the order specified.", "       Groovy and Javascript are supported 'out of the box' but any ", "       JSR 223 compatible scripting engine should work if on the classpath.", "", " -probe [probe options string] : configures the information that the probe", "       will output.", "       [probe options]:", "       A : all options turned on, same as: btrscpdu", "       b : show bounding volumes", "       t : show translations", "       r : show rotation", "       s : show scale", "       c : show the list of controls", "       p : show material parameters", "       u : show user-added data", "       d : list asset dependencies", "", "Examples:", "", ">jmec -sourceRoot C:\\Downloads\\CoolModel -targetRoot assets -targetPath Models/CoolModel C:\\Downloads\\CoolModel\\AwesomeThing.gltf", "", " Converts C:\\Downloads\\CoolModel\\AwesomeThing.gltf to a j3o and writes it", " to ./assets/Models/CoolModel/AwesomeThing.gltf.j3o", "", " Any dependent textures, etc. relative to C:\\Downloads\\CoolModel will", " be copied until the appropriate ./assets/Models/CoolModel/* subdirectory.", "", " For example:", "    C:\\Downloads\\CoolModel\\textures\\awesome-sauce.jpg", " Gets copied to:", "    ./assets/Models/CoolModel/textures/awesome-sauce.jpg"};
    static Logger log = LoggerFactory.getLogger(Convert.class);
    private File sourceRoot;
    private File targetRoot;
    private String targetAssetPath;
    private AssetReader assets;
    private AssetWriter writer;
    private Probe probe = null;
    private String probeOptions = null;
    private List<ModelScript> modelScripts = new ArrayList<ModelScript>();
    private List<ModelProcessor> processors = new ArrayList<ModelProcessor>();

    public AssetReader getAssetReader() {
        if (this.assets == null) {
            log.warn("No source root specified, using local directory.");
            this.setSourceRoot(new File("."));
        }
        return this.assets;
    }

    protected AssetWriter getAssetWriter() {
        if (this.writer == null) {
            this.writer = new AssetWriter();
            this.processors.add(this.writer);
        }
        return this.writer;
    }

    protected Probe getProbe() {
        if (this.probe == null) {
            this.probe = new Probe();
            this.processors.add(0, this.probe);
        }
        return this.probe;
    }

    public void setSourceRoot(File f) {
        if (!f.exists()) {
            log.error("Source root doesn't exist:" + f);
            return;
        }
        if (!f.isDirectory()) {
            log.error("Source root is not a directory:" + f);
            return;
        }
        this.sourceRoot = f;
        this.assets = new AssetReader(f);
    }

    public File getSourceRoot() {
        return this.sourceRoot;
    }

    public void setTargetRoot(File f) {
        this.targetRoot = f;
        this.getAssetWriter().setTarget(f);
    }

    public File getTargetRoot() {
        return this.targetRoot;
    }

    public void setTargetAssetPath(String path) {
        this.targetAssetPath = path;
        this.getAssetWriter().setAssetPath(path);
    }

    public String getTargetAssetPath() {
        return this.targetAssetPath;
    }

    public void setProbeOptions(String options) {
        this.probeOptions = options;
        block11: for (char c : options.toCharArray()) {
            switch (c) {
                case 'A': {
                    this.setProbeOptions(ALL_PROBE_OPTIONS);
                    continue block11;
                }
                case 'b': {
                    this.getProbe().setShowBounds(true);
                    continue block11;
                }
                case 't': {
                    this.getProbe().setShowTranslation(true);
                    continue block11;
                }
                case 'r': {
                    this.getProbe().setShowRotation(true);
                    continue block11;
                }
                case 's': {
                    this.getProbe().setShowScale(true);
                    continue block11;
                }
                case 'c': {
                    this.getProbe().setShowControls(true);
                    continue block11;
                }
                case 'p': {
                    this.getProbe().setShowAllMaterialParameters(true);
                    continue block11;
                }
                case 'd': {
                    this.getProbe().setShowDependencies(true);
                    continue block11;
                }
                case 'u': {
                    this.getProbe().setShowUserData(true);
                    continue block11;
                }
                default: {
                    log.warn("Unknown probe option:" + c);
                }
            }
        }
    }

    public String getProbeOptions() {
        return this.probeOptions;
    }

    public void addModelScript(String script) {
        this.addModelScript(new ModelScript(this, script));
    }

    public void addModelScript(ModelScript script) {
        this.modelScripts.add(script);
        this.addModelProcessor(script);
    }

    public List<ModelScript> getModelScripts() {
        return Collections.unmodifiableList(this.modelScripts);
    }

    public void addModelProcessor(ModelProcessor proc) {
        if (this.writer == null) {
            this.processors.add(proc);
        } else {
            int index = this.processors.indexOf(this.writer);
            this.processors.add(index, proc);
        }
    }

    public void clearModelScripts() {
        this.processors.removeAll(this.modelScripts);
        this.modelScripts.clear();
    }

    public ModelInfo convert(File f) throws IOException {
        if (!f.exists()) {
            log.error("File doesn't exist:" + f);
            return null;
        }
        log.info("Convert:" + f);
        Spatial s = this.getAssetReader().loadModel(f);
        ModelInfo info = new ModelInfo(this.sourceRoot, f.getName(), s);
        this.runProcessors(info);
        return info;
    }

    public void runProcessors(ModelInfo info) {
        if (this.processors.isEmpty()) {
            log.warn("No output configured, probing instead.");
            this.getProbe();
        }
        log.info("Processing:" + info.getModelName());
        for (ModelProcessor proc : this.processors) {
            proc.apply(info);
        }
    }

    public static void printMemInfo() {
        long maxMem = Runtime.getRuntime().maxMemory();
        double mem = (double)maxMem / 1048576.0;
        String s = String.format("%.2f mb", mem);
        log.info("Max memory:" + s);
    }

    public static void print(String ... lines) {
        for (String l : lines) {
            System.out.println(l);
        }
    }

    public static void main(String ... args) throws Exception {
        boolean test = true;
        JulLogSetup.initialize();
        Convert.print(HEADER);
        Convert.printMemInfo();
        if (args.length == 0) {
            Convert.print(HELP);
            if (!test) {
                return;
            }
        }
        Convert convert = new Convert();
        Iterator<String> it = Arrays.asList(args).iterator();
        while (it.hasNext()) {
            String arg = it.next();
            if ("-sourceRoot".equals(arg)) {
                convert.setSourceRoot(new File(it.next()));
                continue;
            }
            if ("-targetRoot".equals(arg)) {
                convert.setTargetRoot(new File(it.next()));
                continue;
            }
            if ("-targetPath".equals(arg)) {
                convert.setTargetAssetPath(it.next());
                continue;
            }
            if ("-script".equals(arg)) {
                convert.addModelScript(it.next());
                continue;
            }
            if ("-probe".equals(arg)) {
                convert.setProbeOptions(it.next());
                continue;
            }
            convert.convert(new File(arg));
        }
        if (args.length == 0 && test) {
            boolean testConvert = false;
            if (testConvert) {
                convert.setSourceRoot(new File("sampleSource3"));
                convert.setTargetRoot(new File("sampleTarget"));
                convert.setTargetAssetPath("foo");
                convert.setProbeOptions("bd");
                convert.convert(new File("sampleSource3/door.gltf"));
            } else {
                convert.setSourceRoot(new File("test-models"));
                convert.setProbeOptions("A");
                convert.convert(new File("test-models/test-model.gltf"));
            }
        }
    }
}

