/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec;

import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.CloneableSmartAsset;
import com.jme3.asset.FilterKey;
import com.jme3.asset.ModelKey;
import com.jme3.asset.TextureKey;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioKey;
import com.jme3.font.BitmapFont;
import com.jme3.material.Material;
import com.jme3.post.FilterPostProcessor;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.simsilica.jmec.ModelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelAssets {
    static Logger log = LoggerFactory.getLogger(ModelAssets.class);
    private ModelInfo model;
    private AssetManager assets;

    public ModelAssets(ModelInfo model, AssetManager assets) {
        this.model = model;
        this.assets = assets;
    }

    public AssetManager getAssetManager() {
        return this.assets;
    }

    protected <T> T addDependency(T asset) {
        if (asset instanceof CloneableSmartAsset) {
            this.model.addDependency((CloneableSmartAsset)asset);
        }
        return asset;
    }

    public <T> T loadAsset(AssetKey<T> key) {
        return (T)this.addDependency(this.assets.loadAsset(key));
    }

    public Object loadAsset(String name) {
        return this.addDependency(this.assets.loadAsset(name));
    }

    public Texture loadTexture(TextureKey key) {
        return this.addDependency(this.assets.loadTexture(key));
    }

    public Texture loadTexture(String name) {
        return this.addDependency(this.assets.loadTexture(name));
    }

    public Texture loadTexture(String name, boolean yFlipped) {
        return this.addDependency(this.assets.loadTexture(new TextureKey(name, yFlipped)));
    }

    public AudioData loadAudio(AudioKey key) {
        return this.addDependency(this.assets.loadAudio(key));
    }

    public AudioData loadAudio(String name) {
        return this.addDependency(this.assets.loadAudio(name));
    }

    public Spatial loadModel(ModelKey key) {
        return this.addDependency(this.assets.loadModel(key));
    }

    public Spatial loadModel(String name) {
        return this.addDependency(this.assets.loadModel(name));
    }

    public Material loadMaterial(String name) {
        return this.addDependency(this.assets.loadMaterial(name));
    }

    public BitmapFont loadFont(String name) {
        return this.addDependency(this.assets.loadFont(name));
    }

    public FilterPostProcessor loadFilter(FilterKey key) {
        return this.addDependency(this.assets.loadFilter(key));
    }

    public FilterPostProcessor loadFilter(String name) {
        return this.addDependency(this.assets.loadFilter(name));
    }
}

