/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec;

import com.jme3.asset.AssetKey;
import com.jme3.asset.CloneableSmartAsset;
import com.jme3.asset.MaterialKey;
import com.jme3.asset.ModelKey;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.math.Transform;
import com.jme3.scene.AssetLinkNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelInfo {
    static Logger log = LoggerFactory.getLogger(ModelInfo.class);
    private File root;
    private String name;
    private Spatial model;
    private Map<CloneableSmartAsset, Dependency> dependencies = new HashMap<CloneableSmartAsset, Dependency>();

    public ModelInfo(File root, String name, Spatial model) {
        this.root = root;
        this.name = name;
        this.model = model;
        this.findDependencies(model);
    }

    public List<Spatial> findAll(String name) {
        return this.findAll(name, Spatial.class);
    }

    public <T> List<T> findAll(final String name, final Class<T> type) {
        if (!Spatial.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Type is not a Spatial compatible type:" + type);
        }
        final ArrayList results = new ArrayList();
        this.model.breadthFirstTraversal(new SceneGraphVisitor(){

            public void visit(Spatial spatial) {
                if (Objects.equals(name, spatial.getName()) && type.isInstance(spatial)) {
                    results.add(type.cast(spatial));
                }
            }
        });
        return results;
    }

    public <T> List<T> findAll(final Class<T> type) {
        if (!Spatial.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException("Type is not a Spatial compatible type:" + type);
        }
        final ArrayList results = new ArrayList();
        this.model.breadthFirstTraversal(new SceneGraphVisitor(){

            public void visit(Spatial spatial) {
                if (type.isInstance(spatial)) {
                    results.add(type.cast(spatial));
                }
            }
        });
        return results;
    }

    public Spatial findFirst(String name) {
        return this.findFirst(name, Spatial.class);
    }

    public <T> T findFirst(String name, Class<T> type) {
        List<T> results = this.findAll(name, type);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    public Spatial getModelRoot() {
        return this.model;
    }

    public void setModelName(String name) {
        this.name = name;
    }

    public String getModelName() {
        return this.name;
    }

    public Collection<Dependency> getDependencies() {
        return this.dependencies.values();
    }

    public Dependency getDependency(CloneableSmartAsset asset) {
        return this.dependencies.get(asset);
    }

    public void generateMaterial(Material material, String assetName) {
        log.debug("generateMaterial(" + material + ", " + assetName + ")");
        if (!assetName.toLowerCase().endsWith(".j3m")) {
            assetName = assetName + ".j3m";
        }
        Dependency dep = this.addDependency(null, (CloneableSmartAsset)material);
        dep.setKey((AssetKey)new MaterialKey(assetName));
    }

    public AssetLinkNode extractSubmodel(Spatial submodel, String assetName) {
        Node parent;
        log.debug("extractSubmodel(" + submodel + ", " + assetName + ")");
        if (!assetName.toLowerCase().endsWith(".j3o")) {
            assetName = assetName + ".j3o";
        }
        if ((parent = submodel.getParent()) == null) {
            throw new IllegalArgumentException("Submodel has no parent, only children can be extracted:" + submodel);
        }
        ModelKey key = new ModelKey(assetName);
        AssetLinkNode link = new AssetLinkNode(key);
        link.setLocalTransform(submodel.getLocalTransform());
        submodel.setLocalTransform(new Transform());
        link.attachLinkedChild(submodel, key);
        parent.attachChild((Spatial)link);
        Dependency dep = this.addDependency(null, (CloneableSmartAsset)link);
        dep.setKey((AssetKey)key);
        return link;
    }

    private void findDependencies(Spatial s) {
        log.debug("findDependencies(" + s + ")");
        if (s instanceof Node) {
            Node n = (Node)s;
            for (Spatial child : n.getChildren()) {
                this.findDependencies(child);
            }
        } else if (s instanceof Geometry) {
            this.findDependencies(((Geometry)s).getMaterial());
        }
    }

    private void findDependencies(Material m) {
        log.debug("findDependencies(" + m + ")");
        if (m.getKey() != null) {
            this.dependencies.put((CloneableSmartAsset)m, new Dependency(this.root, (CloneableSmartAsset)m));
        }
        for (MatParam mp : m.getParams()) {
            log.debug("Checking:" + mp);
            Object val = mp.getValue();
            if (!(val instanceof CloneableSmartAsset)) continue;
            CloneableSmartAsset asset = (CloneableSmartAsset)val;
            log.debug("material asset:" + asset);
            if (asset.getKey() == null) continue;
            this.addDependency(this.root, asset);
        }
    }

    public <T extends CloneableSmartAsset> T addDependency(T asset) {
        this.addDependency(this.root, asset);
        return asset;
    }

    public <T extends CloneableSmartAsset> T addExternalDependency(File root, T asset) {
        this.addDependency(root, asset);
        return asset;
    }

    private Dependency addDependency(File root, CloneableSmartAsset asset) {
        Dependency result = this.dependencies.get(asset);
        if (result == null) {
            result = new Dependency(root, asset);
            this.dependencies.put(asset, result);
            return result;
        }
        result.instances.add(asset);
        return result;
    }

    public static class Dependency
    implements Comparable<Dependency> {
        private AssetKey originalKey;
        private File file;
        private List<CloneableSmartAsset> instances = new ArrayList<CloneableSmartAsset>();

        public Dependency(File root, CloneableSmartAsset asset) {
            this.instances.add(asset);
            this.originalKey = asset.getKey();
            if (asset.getKey() != null) {
                this.file = new File(root, asset.getKey().getName());
            }
        }

        @Override
        public int compareTo(Dependency other) {
            String s1 = this.originalKey.getName();
            String s2 = other.getKey().getName();
            return s1.compareTo(s2);
        }

        public AssetKey getOriginalKey() {
            return this.originalKey;
        }

        public void setKey(AssetKey key) {
            for (CloneableSmartAsset asset : this.instances) {
                asset.setKey(key);
            }
        }

        public AssetKey getKey() {
            return this.instances.get(0).getKey();
        }

        public File getSourceFile() {
            return this.file;
        }

        public List<CloneableSmartAsset> getInstances() {
            return this.instances;
        }

        public String toString() {
            return "Dependency[file=" + this.file + ", originalKey=" + this.originalKey + "]";
        }
    }
}

