/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.jme3.asset.AssetManager;
import com.simsilica.jmec.Convert;
import com.simsilica.jmec.ModelAssets;
import com.simsilica.jmec.ModelInfo;
import com.simsilica.jmec.ModelProcessor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelScript
implements ModelProcessor {
    static Logger log = LoggerFactory.getLogger(ModelScript.class);
    private static ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
    private Convert convert;
    private String scriptName;
    private String script;
    private ScriptEngine engine;
    private CompiledScript compiledScript;
    private Bindings bindings;

    public ModelScript(Convert convert, String scriptName) {
        this(convert, scriptName, ModelScript.loadScript(scriptName));
    }

    public ModelScript(Convert convert, String scriptName, String script) {
        this.convert = convert;
        this.scriptName = scriptName;
        this.script = script;
        String ext = Files.getFileExtension((String)scriptName);
        this.engine = scriptEngineManager.getEngineByExtension(ext);
        this.bindings = this.engine.createBindings();
        this.bindings.put("convert", (Object)convert);
        this.bindings.put("assets", (Object)convert.getAssetReader().getAssetManager());
        this.bindings.put("log", (Object)LoggerFactory.getLogger((String)("script." + scriptName)));
        log.info("Script engine:" + this.engine);
        if (this.engine instanceof Compilable) {
            try {
                this.compiledScript = ((Compilable)((Object)this.engine)).compile(script);
            }
            catch (Exception e) {
                throw new RuntimeException("Error compiling:" + scriptName, e);
            }
        }
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public static final String loadScript(String scriptName) {
        File f = new File(scriptName);
        if (f.exists()) {
            return ModelScript.loadScript(f);
        }
        URL u = ModelScript.class.getResource(scriptName);
        if (u != null) {
            return ModelScript.loadScript(u);
        }
        throw new IllegalArgumentException("Unable to load script as file or resource:" + scriptName);
    }

    public static final String loadScript(File f) {
        try {
            return Files.toString((File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading file:" + f, e);
        }
    }

    public static final String loadScript(URL u) {
        try {
            return Resources.toString((URL)u, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading resource:" + u, e);
        }
    }

    @Override
    public void apply(ModelInfo model) {
        log.info("Running script:" + this.scriptName + " against:" + model.getModelName());
        this.bindings.put("model", (Object)model);
        this.bindings.put("assets", (Object)new ModelAssets(model, (AssetManager)this.convert.getAssetReader().getAssetManager()));
        try {
            if (this.compiledScript != null) {
                this.compiledScript.eval(this.bindings);
            } else {
                this.engine.eval(this.script, this.bindings);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script:" + this.scriptName + " against:" + model.getModelName(), e);
        }
    }
}

