/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec;

import com.jme3.asset.CloneableSmartAsset;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.simsilica.jmec.ModelInfo;
import com.simsilica.jmec.ModelProcessor;
import java.util.Objects;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Probe
implements ModelProcessor {
    static Logger log = LoggerFactory.getLogger(Probe.class);
    private boolean showBounds;
    private boolean showTranslation;
    private boolean showRotation;
    private boolean showScale;
    private boolean showControls;
    private boolean showAllMaterialParameters;
    private boolean showDependencies;
    private boolean showUserData;

    public void setShowDependencies(boolean showDependencies) {
        this.showDependencies = showDependencies;
    }

    public boolean getShowDependencies() {
        return this.showDependencies;
    }

    public void setShowUserData(boolean showUserData) {
        this.showUserData = showUserData;
    }

    public boolean getShowUserData() {
        return this.showUserData;
    }

    public void setShowBounds(boolean showBounds) {
        this.showBounds = showBounds;
    }

    public boolean getShowBounds() {
        return this.showBounds;
    }

    public void setShowTranslation(boolean showTranslation) {
        this.showTranslation = showTranslation;
    }

    public boolean getShowTranslation() {
        return this.showTranslation;
    }

    public void setShowRotation(boolean showRotation) {
        this.showRotation = showRotation;
    }

    public boolean getShowRotation() {
        return this.showRotation;
    }

    public void setShowScale(boolean showScale) {
        this.showScale = showScale;
    }

    public boolean getShowScale() {
        return this.showScale;
    }

    public void setShowControls(boolean showControls) {
        this.showControls = showControls;
    }

    public boolean getShowControls() {
        return this.showControls;
    }

    public void setShowAllMaterialParameters(boolean showAllMaterialParameters) {
        this.showAllMaterialParameters = showAllMaterialParameters;
    }

    public boolean getShowAllMaterialParameters() {
        return this.showAllMaterialParameters;
    }

    @Override
    public void apply(ModelInfo info) {
        this.probe("", info.getModelRoot(), info);
        if (this.showDependencies) {
            this.listDependencies("", info);
        }
    }

    protected void listDependencies(String indent, ModelInfo info) {
        if (info.getDependencies().isEmpty()) {
            return;
        }
        log.info(indent + "Asset dependencies:");
        TreeSet<ModelInfo.Dependency> deps = new TreeSet<ModelInfo.Dependency>(info.getDependencies());
        for (ModelInfo.Dependency dep : deps) {
            this.probe(indent + "  ", dep, info);
        }
    }

    protected void probe(String indent, ModelInfo.Dependency dep, ModelInfo info) {
        StringBuilder sb = new StringBuilder();
        if (dep.getSourceFile() == null) {
            sb.append(dep.getKey());
        } else {
            sb.append(dep.getSourceFile());
        }
        if (!Objects.equals(dep.getKey().toString(), dep.getOriginalKey().toString())) {
            sb.append(" -> " + dep.getKey());
        }
        if (dep.getInstances().size() > 1) {
            sb.append(" (x" + dep.getInstances().size() + ")");
        }
        log.info(indent + sb);
    }

    protected void probe(String indent, Spatial s, ModelInfo info) {
        StringBuilder sb = new StringBuilder();
        if (s.getName() == null) {
            sb.append(s.getClass().getSimpleName() + "()");
        } else {
            sb.append(s.getClass().getSimpleName() + "(" + s.getName() + ")");
        }
        if (s.getKey() != null) {
            sb.append(" key:" + s.getKey());
        }
        log.info(indent + sb);
        this.writeAttributes(indent + "   -> ", s, info);
        if (s instanceof Node) {
            Node n = (Node)s;
            for (Spatial child : n.getChildren()) {
                this.probe(indent + "  ", child, info);
            }
        }
        if (s instanceof Geometry) {
            this.probe(indent + "      ", ((Geometry)s).getMaterial(), info);
        }
    }

    protected void writeAttributes(String indent, Spatial s, ModelInfo info) {
        if (this.showBounds) {
            log.info(indent + "worldBounds:" + s.getWorldBound());
        }
        if (this.showTranslation) {
            log.info(indent + "localTranslation:" + s.getLocalTranslation());
        }
        if (this.showRotation) {
            log.info(indent + "localRotation:" + s.getLocalRotation());
        }
        if (this.showScale) {
            log.info(indent + "localScale:" + s.getLocalScale());
        }
        if (this.showUserData) {
            this.writeUserData(indent + "userData:", s);
        }
        if (this.showControls && s.getNumControls() > 0) {
            log.info(indent + "controls:");
            for (int i = 0; i < s.getNumControls(); ++i) {
                Control c = s.getControl(i);
                log.info(indent + " [" + i + "]:" + c);
            }
        }
    }

    protected void writeUserData(String indent, Spatial s) {
        for (String name : s.getUserDataKeys()) {
            log.info(indent + name + "=" + s.getUserData(name));
        }
    }

    protected void probe(String indent, Material m, ModelInfo info) {
        ModelInfo.Dependency dep;
        StringBuilder sb = new StringBuilder();
        sb.append(m.toString());
        if (m.getKey() != null) {
            sb.append("  key:" + m.getKey());
        }
        log.info(indent + sb);
        if (m.getKey() != null && (dep = info.getDependency((CloneableSmartAsset)m)) != null && dep.getSourceFile() != null) {
            log.info(indent + "  -> source:" + dep.getSourceFile());
        }
        if (this.showAllMaterialParameters) {
            for (MatParam mp : m.getParams()) {
                CloneableSmartAsset asset;
                ModelInfo.Dependency dep2;
                log.info(indent + "  " + mp);
                Object val = mp.getValue();
                if (!(val instanceof CloneableSmartAsset) || (dep2 = info.getDependency(asset = (CloneableSmartAsset)val)) == null || dep2.getSourceFile() == null) continue;
                log.info(indent + "    -> source:" + dep2.getSourceFile());
            }
        }
    }
}

