/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec.gltf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.gltf.ExtrasLoader;
import com.jme3.scene.plugins.gltf.GltfLoader;
import com.jme3.scene.plugins.gltf.GltfModelKey;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GltfExtrasLoader
implements ExtrasLoader {
    static Logger log = LoggerFactory.getLogger(GltfExtrasLoader.class);
    public static final GltfExtrasLoader INSTANCE = new GltfExtrasLoader();

    public static GltfModelKey createModelKey(String path) {
        GltfModelKey key = new GltfModelKey(path);
        key.setExtrasLoader((ExtrasLoader)INSTANCE);
        return key;
    }

    public Object handleExtras(GltfLoader loader, String parentName, JsonElement parent, JsonElement extras, Object input) {
        log.debug("handleExtras(" + loader + ", " + parentName + ", " + parent + ", " + extras + ", " + input + ")");
        if (!extras.isJsonObject()) {
            log.warn("Skipping extras:" + extras);
            return input;
        }
        JsonObject jo = extras.getAsJsonObject();
        this.apply(input, jo);
        return input;
    }

    protected void apply(Object input, JsonObject extras) {
        if (input == null) {
            return;
        }
        if (input.getClass().isArray()) {
            this.applyToArray(input, extras);
        } else if (input instanceof Spatial) {
            this.applyToSpatial((Spatial)input, extras);
        } else {
            log.warn("Unhandled input type:" + input.getClass());
        }
    }

    protected void applyToArray(Object array, JsonObject extras) {
        int size = Array.getLength(array);
        for (int i = 0; i < size; ++i) {
            Object o = Array.get(array, i);
            log.debug("processing array[" + i + "]:" + o);
            this.apply(o, extras);
        }
    }

    protected void applyToSpatial(Spatial spatial, JsonObject extras) {
        for (Map.Entry el : extras.entrySet()) {
            log.debug(el.toString());
            Object val = this.toAttribute((JsonElement)el.getValue(), false);
            if (log.isDebugEnabled()) {
                log.debug("setUserData(" + (String)el.getKey() + ", " + val + ")");
            }
            spatial.setUserData((String)el.getKey(), val);
        }
    }

    protected Object toAttribute(JsonElement el, boolean nested) {
        if (el.isJsonObject()) {
            return this.toAttribute(el.getAsJsonObject(), nested);
        }
        if (el.isJsonArray()) {
            return this.toAttribute(el.getAsJsonArray(), nested);
        }
        if (el.isJsonPrimitive()) {
            return this.toAttribute(el.getAsJsonPrimitive(), nested);
        }
        if (el.isJsonNull()) {
            return null;
        }
        log.warn("Unhandled extras element:" + el);
        return null;
    }

    protected Object toAttribute(JsonObject jo, boolean nested) {
        HashMap result = new HashMap();
        for (Map.Entry el : jo.entrySet()) {
            result.put(el.getKey(), this.toAttribute((JsonElement)el.getValue(), true));
        }
        return result;
    }

    protected Object toAttribute(JsonArray ja, boolean nested) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (JsonElement el : ja) {
            result.add(this.toAttribute(el, true));
        }
        return result;
    }

    protected Object toAttribute(JsonPrimitive jp, boolean nested) {
        if (jp.isBoolean()) {
            return jp.getAsBoolean();
        }
        if (jp.isNumber()) {
            if (nested) {
                return jp.getAsString();
            }
            Number num = jp.getAsNumber();
            return num.doubleValue();
        }
        if (jp.isString()) {
            return jp.getAsString();
        }
        log.warn("Unhandled primitive:" + jp);
        return null;
    }
}

