/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.jmec.view;

import com.google.common.io.Files;
import com.jme3.asset.AssetManager;
import com.jme3.scene.AssetLinkNode;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.jmec.Convert;
import com.simsilica.jmec.ModelInfo;
import com.simsilica.jmec.ModelScript;
import java.io.File;
import java.io.IOException;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmecNode
extends Node {
    static Logger log = LoggerFactory.getLogger(JmecNode.class);
    private Convert convert = new Convert();
    private ModelInfo model;
    private VersionedFile modelFile;
    private SafeArrayList<VersionedScript> scripts = new SafeArrayList(VersionedScript.class);
    private AssetManager assets;

    public JmecNode() {
        this((File)null);
    }

    public JmecNode(String modelFile) {
        this(new File(modelFile));
    }

    public JmecNode(File modelFile) {
        this.setRequiresUpdates(true);
        if (modelFile != null) {
            this.modelFile = new VersionedFile(modelFile);
            this.setName(modelFile.getName());
        }
        this.convert.setTargetRoot(new File("assets"));
        this.convert.setTargetAssetPath("Models/" + Files.getNameWithoutExtension((String)modelFile.getName()));
    }

    public void setModelFile(File modelFile) {
        if (modelFile == null) {
            this.modelFile = null;
            return;
        }
        this.modelFile = new VersionedFile(modelFile);
        if (this.getName() == null) {
            this.setName(modelFile.getName());
        }
    }

    public File getModelFile() {
        return this.modelFile != null ? this.modelFile.getFile() : null;
    }

    public Convert getConvert() {
        return this.convert;
    }

    public void addModelScript(File f) {
        this.scripts.add((Object)new VersionedScript(f));
    }

    public void setAssetManager(AssetManager assets) {
        this.assets = assets;
    }

    public AssetManager getAssetManager() {
        return this.assets;
    }

    public void updateLogicalState(float tpf) {
        if (this.updateDependencies()) {
            Spatial child;
            if (this.model != null && this.model.getModelRoot() != null) {
                this.model.getModelRoot().removeFromParent();
            }
            if ((child = this.loadModel()) != null) {
                this.attachChild(child);
            }
        }
        super.updateLogicalState(tpf);
    }

    protected Spatial loadModel() {
        if (this.modelFile == null) {
            throw new RuntimeException("No model file has been set");
        }
        File f = this.modelFile.getFile();
        if (!f.exists()) {
            throw new RuntimeException("Model does not exist:" + f);
        }
        if (this.convert.getSourceRoot() == null) {
            this.convert.setSourceRoot(f.getParentFile());
        }
        if (!this.scripts.isEmpty()) {
            this.convert.clearModelScripts();
            for (VersionedScript script : (VersionedScript[])this.scripts.getArray()) {
                try {
                    this.convert.addModelScript(script.getScript());
                }
                catch (RuntimeException e) {
                    log.error("Error compiling script:" + script.getScript().getScriptName(), e.getCause());
                }
            }
        }
        try {
            this.model = this.convert.convert(f);
            for (ModelInfo.Dependency dep : this.model.getDependencies()) {
                log.info("Clear cached dependency for:" + dep.getKey());
                if (this.deleteFromCache(dep)) continue;
            }
            this.model.getModelRoot().depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

                public void visit(Node node) {
                    if (node instanceof AssetLinkNode) {
                        if (JmecNode.this.assets == null) {
                            log.error("No AssetManager specified, cannot load asset link:" + node);
                        } else {
                            log.info("Loading linked assets for:" + node);
                            AssetLinkNode link = (AssetLinkNode)node;
                            link.attachLinkedChildren(JmecNode.this.assets);
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            log.error("Cannot load:" + f, (Throwable)e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof ScriptException) {
                log.error("Script error", e.getCause());
            }
            throw e;
        }
        return this.model == null ? null : this.model.getModelRoot();
    }

    protected boolean deleteFromCache(ModelInfo.Dependency dep) {
        return this.assets.deleteFromCache(dep.getKey());
    }

    protected boolean updateDependencies() {
        boolean changed = false;
        if (this.modelFile != null && this.modelFile.update()) {
            changed = true;
        }
        for (VersionedScript f : (VersionedScript[])this.scripts.getArray()) {
            if (!f.update()) continue;
            changed = true;
        }
        return changed;
    }

    protected class VersionedScript {
        File file;
        ModelScript script;
        long lastVersion;

        public VersionedScript(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public ModelScript getScript() {
            if (this.script == null) {
                String text = ModelScript.loadScript(this.file);
                this.script = new ModelScript(JmecNode.this.convert, this.file.getName(), text);
            }
            return this.script;
        }

        public boolean update() {
            long time = this.file.lastModified();
            if (this.lastVersion == time) {
                return false;
            }
            this.lastVersion = time;
            this.script = null;
            return true;
        }
    }

    protected static class VersionedFile {
        File file;
        long lastVersion;

        public VersionedFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public boolean update() {
            long time = this.file.lastModified();
            if (this.lastVersion == time) {
                return false;
            }
            this.lastVersion = time;
            return true;
        }
    }
}

