/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import com.jme3.network.HostedConnection;
import com.simsilica.ethereal.ConnectionStats;
import com.simsilica.ethereal.EtherealHost;
import com.simsilica.ethereal.IdIndex;
import com.simsilica.ethereal.LocalZoneIndex;
import com.simsilica.ethereal.SharedObject;
import com.simsilica.ethereal.SharedObjectSpace;
import com.simsilica.ethereal.net.ClientStateMessage;
import com.simsilica.ethereal.net.SentState;
import com.simsilica.ethereal.net.StateWriter;
import com.simsilica.ethereal.zone.StateBlock;
import com.simsilica.ethereal.zone.StateListener;
import com.simsilica.ethereal.zone.ZoneGrid;
import com.simsilica.ethereal.zone.ZoneKey;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import com.simsilica.util.BufferedHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkStateListener
implements StateListener {
    static Logger log = LoggerFactory.getLogger(NetworkStateListener.class);
    public static final String ATTRIBUTE_KEY = "networkStateListener";
    private EtherealHost host;
    private HostedConnection conn;
    private LocalZoneIndex zoneIndex;
    private IdIndex idIndex;
    private SharedObjectSpace space;
    private BufferedHashSet<Long> activeIds = new BufferedHashSet();
    private Long self;
    private final Vec3d selfPosition = new Vec3d();
    private boolean zonesChanged = false;
    private final List<ZoneKey> entered = new ArrayList<ZoneKey>();
    private final List<ZoneKey> exited = new ArrayList<ZoneKey>();
    private StateWriter stateWriter;
    private ConcurrentLinkedQueue<ClientStateMessage> acked = new ConcurrentLinkedQueue();
    private long pingTime = 0L;
    private long windowMax = 100L;
    private long windowSize = 0L;
    private ConnectionStats stats = new ConnectionStats();

    public NetworkStateListener(EtherealHost host, HostedConnection conn, ZoneGrid grid, int zoneRadius) {
        this(host, conn, new LocalZoneIndex(grid, zoneRadius), new IdIndex(10));
    }

    public NetworkStateListener(EtherealHost host, HostedConnection conn, ZoneGrid grid, Vec3i zoneExtents) {
        this(host, conn, new LocalZoneIndex(grid, zoneExtents), new IdIndex(10));
    }

    public NetworkStateListener(EtherealHost host, HostedConnection conn, LocalZoneIndex zoneIndex, IdIndex idIndex) {
        this.host = host;
        this.conn = conn;
        this.zoneIndex = zoneIndex;
        this.idIndex = idIndex;
        this.space = new SharedObjectSpace(host.getObjectProtocol());
        this.stateWriter = new StateWriter(conn, host.getObjectProtocol(), host.getTimeSource(), this.stats);
    }

    public void setSelf(Long self, Vec3d startingPosition) {
        this.self = self;
        this.selfPosition.set(startingPosition);
    }

    public Long getSelf() {
        return this.self;
    }

    public Set<Long> getActiveIds() {
        return this.activeIds.getSnapshot();
    }

    public ConnectionStats getConnectionStats() {
        return this.stats;
    }

    public void setMaxMessageSize(int max) {
        this.stateWriter.setMaxMessageSize(max);
    }

    public int getMaxMessageSize() {
        return this.stateWriter.getMaxMessageSize();
    }

    @Override
    public boolean hasChangedZones() {
        return this.zonesChanged;
    }

    @Override
    public List<ZoneKey> getEnteredZones() {
        return this.entered;
    }

    @Override
    public List<ZoneKey> getExitedZones() {
        return this.exited;
    }

    protected void postResponse(ClientStateMessage m) {
        m.resetReceivedTime();
        long ping = m.getReceivedTime() - m.getTime();
        this.stats.addPingTime(ping);
        long newPing = (ping + this.pingTime * this.windowSize) / (this.windowSize + 1L);
        if (this.windowSize < this.windowMax) {
            ++this.windowSize;
        }
        long delta = Math.abs(newPing - this.pingTime);
        this.pingTime = newPing;
        if (delta > 10000000L && log.isDebugEnabled()) {
            log.debug("********** " + this.conn + "  avg ping:" + this.pingTime + "  " + (double)this.pingTime / 1000000.0 + " ms");
        }
        if (log.isTraceEnabled()) {
            log.trace("received message:" + m.getId());
        }
        this.acked.add(m);
    }

    @Override
    public void beginFrameBlock() {
    }

    @Override
    public void endFrameBlock() {
        try {
            this.stateWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Error flushing", e);
        }
    }

    @Override
    public void beginFrame(long time) {
        if (log.isTraceEnabled()) {
            log.trace(this.self + ":beginFrame(" + time + ") selfPosition:" + this.selfPosition);
        }
        if (this.zonesChanged) {
            this.entered.clear();
            this.exited.clear();
            this.zonesChanged = false;
        }
    }

    @Override
    public void endFrame(long time) {
        ClientStateMessage ackedMsg;
        if (log.isTraceEnabled()) {
            log.trace(this.self + ":endFrame(" + time + ") selfPosition:" + this.selfPosition);
            log.trace("endFrame() acked queue size:" + this.acked.size());
        }
        while ((ackedMsg = this.acked.poll()) != null) {
            this.stats.incrementAcks();
            SentState sentState = this.stateWriter.ackSentState(ackedMsg.getId());
            if (sentState == null) {
                this.stats.incrementAckMisses();
                continue;
            }
            this.space.updateBaseline(sentState.frames);
        }
        try {
            ZoneKey center = this.zoneIndex.getCenter();
            this.stateWriter.startFrame(time, center);
            Iterator<SharedObject> it = this.space.objects().iterator();
            while (it.hasNext()) {
                SharedObject so = it.next();
                if (!so.isMarkedRemoved() && so.getVersion() < time) {
                    if (log.isDebugEnabled()) {
                        log.debug("Object no longer in active zones, marking removed:" + so.getEntityId());
                    }
                    so.markRemoved(time);
                }
                this.stateWriter.addState(so.getDelta());
                if (so.isFullyMarkedRemoved()) {
                    if (log.isDebugEnabled()) {
                        log.debug("State entry is removed for:" + so.getEntityId());
                    }
                    it.remove();
                    this.idIndex.retireId(so.getNetworkId());
                    this.activeIds.remove(so.getEntityId());
                    continue;
                }
                this.activeIds.add(so.getEntityId());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing state", e);
        }
        if (this.self != null && this.selfPosition != null && this.zoneIndex.setCenter(this.selfPosition, this.entered, this.exited)) {
            this.zonesChanged = true;
        }
        this.activeIds.commit();
    }

    @Override
    public void stateChanged(StateBlock b) {
        if (log.isTraceEnabled()) {
            log.trace(this.self + ":stateChanged(" + b + ")");
        }
        long time = b.getTime();
        ZoneKey zone = b.getZone();
        int zoneId = this.zoneIndex.getZoneId(zone);
        if (zoneId <= 0) {
            System.err.println("No zone ID for changed zone:" + zone + "  received:" + zoneId);
        }
        if (log.isTraceEnabled()) {
            log.trace("stateChanged() zone:" + zone + " updates:" + b.getUpdates() + " removals:" + b.getRemovals());
        }
        if (b.getUpdates() != null) {
            for (StateBlock.StateEntry stateEntry : b.getUpdates()) {
                Vec3d pos = stateEntry.getPosition();
                Quatd rot = stateEntry.getRotation();
                int networkId = this.idIndex.getId(stateEntry.getEntity(), true);
                Long entityId = stateEntry.getEntity();
                Long parentId = stateEntry.getParent();
                SharedObject so = this.space.getObject(networkId, entityId);
                if (!so.updateState(time, zone, zoneId, parentId, pos, rot) || !Objects.equals(this.self, entityId)) continue;
                this.selfPosition.set(pos);
            }
        } else if (log.isTraceEnabled()) {
            log.trace(this.self + ":No updates");
        }
        if (b.getRemovals() != null) {
            for (Long l : b.getRemovals()) {
                SharedObject so;
                int networkId = this.idIndex.getId(l, false);
                if (networkId == -1 || (so = this.space.getObject(networkId)) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("StateBlock - Marking removed:" + l);
                }
                so.markRemoved(time);
            }
        }
    }
}

