/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.texture.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.texture.Image;
import com.jme3.util.BufferUtils;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;

public class AWTLoader
implements AssetLoader {
    public static final ColorModel AWT_RGBA4444 = new DirectColorModel(16, 61440, 3840, 240, 15);
    public static final ColorModel AWT_RGBA5551 = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{5, 5, 5, 1}, true, false, 2, 0);

    private Object extractImageData(BufferedImage img) {
        DataBuffer buf = img.getRaster().getDataBuffer();
        switch (buf.getDataType()) {
            case 0: {
                DataBufferByte byteBuf = (DataBufferByte)buf;
                return byteBuf.getData();
            }
            case 1: {
                DataBufferUShort shortBuf = (DataBufferUShort)buf;
                return shortBuf.getData();
            }
        }
        return null;
    }

    private void flipImage(byte[] img, int width, int height, int bpp) {
        int scSz = width * bpp / 8;
        byte[] sln = new byte[scSz];
        int y2 = 0;
        for (int y1 = 0; y1 < height / 2; ++y1) {
            y2 = height - y1 - 1;
            System.arraycopy(img, y1 * scSz, sln, 0, scSz);
            System.arraycopy(img, y2 * scSz, img, y1 * scSz, scSz);
            System.arraycopy(sln, 0, img, y2 * scSz, scSz);
        }
    }

    private void flipImage(short[] img, int width, int height, int bpp) {
        int scSz = width * bpp / 8;
        short[] sln = new short[scSz /= 2];
        int y2 = 0;
        for (int y1 = 0; y1 < height / 2; ++y1) {
            y2 = height - y1 - 1;
            System.arraycopy(img, y1 * scSz, sln, 0, scSz);
            System.arraycopy(img, y2 * scSz, img, y1 * scSz, scSz);
            System.arraycopy(sln, 0, img, y2 * scSz, scSz);
        }
    }

    public Image load(BufferedImage img, boolean flipY) {
        int width = img.getWidth();
        int height = img.getHeight();
        switch (img.getType()) {
            case 6: {
                byte[] dataBuf1 = (byte[])this.extractImageData(img);
                if (flipY) {
                    this.flipImage(dataBuf1, width, height, 32);
                }
                ByteBuffer data1 = BufferUtils.createByteBuffer((int)(img.getWidth() * img.getHeight() * 4));
                data1.put(dataBuf1);
                return new Image(Image.Format.ABGR8, width, height, data1, null, com.jme3.texture.image.ColorSpace.sRGB);
            }
            case 5: {
                byte[] dataBuf2 = (byte[])this.extractImageData(img);
                if (flipY) {
                    this.flipImage(dataBuf2, width, height, 24);
                }
                ByteBuffer data2 = BufferUtils.createByteBuffer((int)(img.getWidth() * img.getHeight() * 3));
                data2.put(dataBuf2);
                return new Image(Image.Format.BGR8, width, height, data2, null, com.jme3.texture.image.ColorSpace.sRGB);
            }
            case 10: {
                byte[] dataBuf3 = (byte[])this.extractImageData(img);
                if (flipY) {
                    this.flipImage(dataBuf3, width, height, 8);
                }
                ByteBuffer data3 = BufferUtils.createByteBuffer((int)(img.getWidth() * img.getHeight()));
                data3.put(dataBuf3);
                return new Image(Image.Format.Luminance8, width, height, data3, null, com.jme3.texture.image.ColorSpace.sRGB);
            }
        }
        if (img.getTransparency() == 1) {
            ByteBuffer data = BufferUtils.createByteBuffer((int)(img.getWidth() * img.getHeight() * 3));
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int ny = y;
                    if (flipY) {
                        ny = height - y - 1;
                    }
                    int rgb = img.getRGB(x, ny);
                    byte r = (byte)((rgb & 0xFF0000) >> 16);
                    byte g = (byte)((rgb & 0xFF00) >> 8);
                    byte b = (byte)(rgb & 0xFF);
                    data.put(r).put(g).put(b);
                }
            }
            data.flip();
            return new Image(Image.Format.RGB8, width, height, data, null, com.jme3.texture.image.ColorSpace.sRGB);
        }
        ByteBuffer data = BufferUtils.createByteBuffer((int)(img.getWidth() * img.getHeight() * 4));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int ny = y;
                if (flipY) {
                    ny = height - y - 1;
                }
                int rgb = img.getRGB(x, ny);
                byte a = (byte)((rgb & 0xFF000000) >> 24);
                byte r = (byte)((rgb & 0xFF0000) >> 16);
                byte g = (byte)((rgb & 0xFF00) >> 8);
                byte b = (byte)(rgb & 0xFF);
                data.put(r).put(g).put(b).put(a);
            }
        }
        data.flip();
        return new Image(Image.Format.RGBA8, width, height, data, null, com.jme3.texture.image.ColorSpace.sRGB);
    }

    public Image load(InputStream in, boolean flipY) throws IOException {
        ImageIO.setUseCache(false);
        BufferedImage img = ImageIO.read(in);
        if (img == null) {
            return null;
        }
        return this.load(img, flipY);
    }

    /*
     * Exception decompiling
     */
    public Object load(AssetInfo info) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

