/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.jme3.anim.AnimComposer;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.anim.interpolator.AnimInterpolator;
import com.jme3.animation.CompactQuaternionArray;
import com.jme3.animation.CompactVector3Array;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimComposerDebug {
    static Logger log = LoggerFactory.getLogger(AnimComposerDebug.class);
    private static Gson animGson = AnimComposerDebug.createAnimGson();
    private static Gson skinGson = AnimComposerDebug.createSkinGson();

    private static Gson createAnimGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        gsonBuilder.serializeSpecialFloatingPointValues();
        IndexedExclusionStrategy index = new IndexedExclusionStrategy();
        gsonBuilder.addSerializationExclusionStrategy((ExclusionStrategy)index);
        gsonBuilder.registerTypeAdapter(CompactQuaternionArray.class, (Object)new JsonSerializer<CompactQuaternionArray>(){

            public JsonElement serialize(CompactQuaternionArray src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray result = new JsonArray();
                for (Quaternion q : (Quaternion[])src.toObjectArray()) {
                    result.add(context.serialize((Object)q));
                }
                return result;
            }
        });
        gsonBuilder.registerTypeAdapter(CompactVector3Array.class, (Object)new JsonSerializer<CompactVector3Array>(){

            public JsonElement serialize(CompactVector3Array src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray result = new JsonArray();
                for (Vector3f v : (Vector3f[])src.toObjectArray()) {
                    result.add(context.serialize((Object)v));
                }
                return result;
            }
        });
        gsonBuilder.registerTypeAdapter(AnimInterpolator.class, (Object)new JsonSerializer<AnimInterpolator>(){

            public JsonElement serialize(AnimInterpolator src, Type typeOfSrc, JsonSerializationContext context) {
                String val = AnimComposerDebug.toString(src);
                return new JsonPrimitive(val);
            }
        });
        gsonBuilder.registerTypeAdapter(Vector3f.class, (Object)new JsonSerializer<Vector3f>(){

            public JsonElement serialize(Vector3f src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive("vec3" + src);
            }
        });
        gsonBuilder.registerTypeAdapter(Quaternion.class, (Object)new JsonSerializer<Quaternion>(){

            public JsonElement serialize(Quaternion src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive("quat" + src);
            }
        });
        gsonBuilder.registerTypeAdapter(Joint.class, (Object)new JsonSerializer<Joint>(){

            public JsonElement serialize(Joint src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive("joint[" + src.getName() + "@" + src.getId() + "]");
            }
        });
        gsonBuilder.registerTypeAdapter(Class.class, (Object)new JsonSerializer<Class>(){

            public JsonElement serialize(Class src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(String.valueOf(src));
            }
        });
        gsonBuilder.registerTypeAdapter(Matrix4f.class, (Object)new JsonSerializer<Matrix4f>(){

            public JsonElement serialize(Matrix4f src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray result = new JsonArray();
                result.add("[" + src.m00 + "][" + src.m01 + "][" + src.m02 + "][" + src.m03 + "]");
                result.add("[" + src.m10 + "][" + src.m11 + "][" + src.m12 + "][" + src.m13 + "]");
                result.add("[" + src.m20 + "][" + src.m21 + "][" + src.m22 + "][" + src.m23 + "]");
                result.add("[" + src.m30 + "][" + src.m31 + "][" + src.m32 + "][" + src.m33 + "]");
                return result;
            }
        });
        return gsonBuilder.create();
    }

    private static Gson createSkinGson() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        gsonBuilder.serializeSpecialFloatingPointValues();
        IndexedExclusionStrategy index = new IndexedExclusionStrategy();
        gsonBuilder.addSerializationExclusionStrategy((ExclusionStrategy)index);
        gsonBuilder.registerTypeAdapter(CompactQuaternionArray.class, (Object)new JsonSerializer<CompactQuaternionArray>(){

            public JsonElement serialize(CompactQuaternionArray src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray result = new JsonArray();
                for (Quaternion q : (Quaternion[])src.toObjectArray()) {
                    result.add(context.serialize((Object)q));
                }
                return result;
            }
        });
        gsonBuilder.registerTypeAdapter(CompactVector3Array.class, (Object)new JsonSerializer<CompactVector3Array>(){

            public JsonElement serialize(CompactVector3Array src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray result = new JsonArray();
                for (Vector3f v : (Vector3f[])src.toObjectArray()) {
                    result.add(context.serialize((Object)v));
                }
                return result;
            }
        });
        gsonBuilder.registerTypeAdapter(AnimInterpolator.class, (Object)new JsonSerializer<AnimInterpolator>(){

            public JsonElement serialize(AnimInterpolator src, Type typeOfSrc, JsonSerializationContext context) {
                String val = AnimComposerDebug.toString(src);
                return new JsonPrimitive(val);
            }
        });
        gsonBuilder.registerTypeAdapter(Vector3f.class, (Object)new JsonSerializer<Vector3f>(){

            public JsonElement serialize(Vector3f src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive("vec3" + src);
            }
        });
        gsonBuilder.registerTypeAdapter(Quaternion.class, (Object)new JsonSerializer<Quaternion>(){

            public JsonElement serialize(Quaternion src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive("quat" + src);
            }
        });
        gsonBuilder.registerTypeAdapter(Class.class, (Object)new JsonSerializer<Class>(){

            public JsonElement serialize(Class src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(String.valueOf(src));
            }
        });
        gsonBuilder.registerTypeAdapter(Matrix4f.class, (Object)new JsonSerializer<Matrix4f>(){

            public JsonElement serialize(Matrix4f src, Type typeOfSrc, JsonSerializationContext context) {
                JsonArray result = new JsonArray();
                String format = "[%9.05f, %9.05f, %9.05f, %9.05f]";
                result.add(String.format(format, Float.valueOf(src.m00), Float.valueOf(src.m01), Float.valueOf(src.m02), Float.valueOf(src.m03)));
                result.add(String.format(format, Float.valueOf(src.m10), Float.valueOf(src.m11), Float.valueOf(src.m12), Float.valueOf(src.m13)));
                result.add(String.format(format, Float.valueOf(src.m20), Float.valueOf(src.m21), Float.valueOf(src.m22), Float.valueOf(src.m23)));
                result.add(String.format(format, Float.valueOf(src.m30), Float.valueOf(src.m31), Float.valueOf(src.m32), Float.valueOf(src.m33)));
                return result;
            }
        });
        return gsonBuilder.create();
    }

    public static void writeJson(AnimComposer anim, File f) {
        try {
            log.info("Storing:" + f);
            try (FileWriter out = new FileWriter(f);){
                animGson.toJson((Object)anim, (Appendable)out);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing:" + f, e);
        }
    }

    public static void writeJson(SkinningControl skin, File f) {
        try {
            log.info("Storing:" + f);
            try (FileWriter out = new FileWriter(f);){
                skinGson.toJson((Object)skin, (Appendable)out);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing:" + f, e);
        }
    }

    public static String toString(AnimInterpolator ai) {
        return String.valueOf(ai);
    }

    public static class IndexedExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipClass(Class<?> clazz) {
            log.info("shouldSkipClass(" + clazz + ")");
            if (clazz == Spatial.class) {
                log.info("  skipping Spatial.class");
                return true;
            }
            if (Spatial.class.isAssignableFrom(clazz)) {
                log.info("  skipping:" + clazz);
                return true;
            }
            if (String.valueOf(clazz).indexOf("com.jme3.scene.Spatial") >= 0) {
                log.info("  skipping Spatial inner class/enum");
                return true;
            }
            if (clazz == LightList.class) {
                log.info("  skipping:" + clazz);
                return true;
            }
            if (clazz == Light.class) {
                log.info("  skipping:" + clazz);
                return true;
            }
            return false;
        }

        public boolean shouldSkipField(FieldAttributes f) {
            log.info("shouldSkipField(declaredType:" + f.getDeclaredType() + ", declaredClass:" + f.getDeclaredClass() + ", declaringClass:" + f.getDeclaringClass() + ", name:" + f.getName() + ")");
            if (f.hasModifier(8)) {
                log.info("  skipping static field");
                return true;
            }
            if (f.getDeclaringClass() == AbstractControl.class && "spatial".equals(f.getName())) {
                log.info("  skipping control 'spatial'");
                return true;
            }
            if ("com.jme3.anim.AnimComposer$Layer".equals(f.getDeclaringClass().getName()) && "ac".equals(f.getName())) {
                log.info("  skipping Layer.ac");
                return true;
            }
            String id = f.getDeclaringClass().getName() + ":" + f.getName();
            log.info("checking:" + id);
            if ("com.jme3.anim.interpolator.FrameInterpolator:translationReader".equals(id)) {
                return true;
            }
            if ("com.jme3.anim.interpolator.FrameInterpolator:rotationReader".equals(id)) {
                return true;
            }
            if ("com.jme3.anim.interpolator.FrameInterpolator:scaleReader".equals(id)) {
                return true;
            }
            if ("com.jme3.anim.interpolator.FrameInterpolator:timesReader".equals(id)) {
                return true;
            }
            if ("com.jme3.anim.interpolator.FrameInterpolator:transforms".equals(id)) {
                return true;
            }
            if ("com.jme3.anim.SkinningControl:targets".equals(id)) {
                return true;
            }
            return "com.jme3.anim.Joint:parent".equals(id);
        }
    }
}

