/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Checkbox;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.RollupPanel;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.tool.ArmatureViewState;
import com.simsilica.tool.AttachmentManager;
import com.simsilica.tool.ColliderManager;
import com.simsilica.tool.ColliderViewState;
import com.simsilica.tool.OverlayManager;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigInfo;
import com.simsilica.tool.RigViewState;
import com.simsilica.tool.ToolState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnimationState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(AnimationState.class);
    private VersionedReference<Rig> rigRef;
    private Rig rig;
    private RigInfo rigInfo;
    private Container window;
    private VersionedReference<TabbedPanel.Tab> tabRef;
    private VersionedReference<Boolean> collidersOpen;
    private Checkbox showArmature;
    private VersionedReference<Boolean> showArmatureRef;
    private VersionedList<String> clipNames = new VersionedList();
    private Selector<String> clipSelector;
    private VersionedReference<String> clipRef;
    private Spinner<Double> blend;
    private VersionedReference<Double> blendRef;
    private AttachmentManager attachmentMgr;
    private ColliderManager colliderMgr;
    private OverlayManager overlayMgr;

    protected void initialize(Application app) {
        this.rigRef = ((RigViewState)this.getState(RigViewState.class, true)).createRigReference();
        this.window = new Container();
        ((ToolState)this.getState(ToolState.class)).getTabs().addTab("Rig", (Panel)this.window);
        this.tabRef = ((ToolState)this.getState(ToolState.class)).getTabs().getSelectionModel().createReference();
        this.showArmature = (Checkbox)this.window.addChild((Node)new Checkbox("Show Armature"), new Object[0]);
        this.showArmature.setChecked(((ArmatureViewState)this.getState(ArmatureViewState.class)).isEnabled());
        this.showArmatureRef = this.showArmature.getModel().createReference();
        Container panel = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        panel.addChild((Node)new Label("Clip:"), new Object[0]);
        this.clipSelector = (Selector)panel.addChild((Node)new Selector(this.clipNames), new Object[]{1});
        this.clipRef = this.clipSelector.createSelectedItemReference();
        panel.addChild((Node)new Label("Blend:"), new Object[0]);
        SequenceModel model = SequenceModels.rangedSequence((RangedValueModel)new DefaultRangedValueModel(0.0, 1.0, 0.0), (double)0.1, (double)0.01);
        DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)"%.2f", (String)"error");
        this.blend = (Spinner)panel.addChild((Node)new Spinner(model, (ValueRenderer)renderer), new Object[]{1});
        this.blend.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)"%.2f"));
        this.blend.setEnabled(false);
        this.blendRef = model.createReference();
        this.attachmentMgr = new AttachmentManager();
        RollupPanel attRollup = (RollupPanel)this.window.addChild((Node)new RollupPanel("Attachments", (Panel)this.attachmentMgr, null), new Object[0]);
        this.colliderMgr = new ColliderManager();
        RollupPanel collRollup = (RollupPanel)this.window.addChild((Node)new RollupPanel("Colliders", (Panel)this.colliderMgr, null), new Object[0]);
        this.collidersOpen = collRollup.getOpenModel().createReference();
        this.overlayMgr = new OverlayManager();
        RollupPanel overlayRollup = (RollupPanel)this.window.addChild((Node)new RollupPanel("Action Overlays", (Panel)this.overlayMgr, null), new Object[0]);
        this.resetRig((Rig)this.rigRef.get());
    }

    protected void resetRig(Rig rig) {
        this.attachmentMgr.setRig(rig);
        this.colliderMgr.setRig(rig);
        this.overlayMgr.setRig(rig);
        if (rig == null) {
            return;
        }
        this.rig = rig;
        this.rigInfo = rig.getRigInfo();
        this.clipNames.clear();
        this.clipNames.addAll(rig.getClipNames());
        this.clipSelector.setSelectedItem(null);
        this.clipSelector.setSelectedItem((Object)"Idle");
    }

    protected void tabVisible() {
        this.rig.setCurrentAction((String)this.clipRef.get());
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    public void update(float tpf) {
        String clip;
        if (this.rigRef.update()) {
            this.resetRig((Rig)this.rigRef.get());
        }
        if (this.tabRef.update() && this.tabRef.get() != null && ((TabbedPanel.Tab)this.tabRef.get()).getContents() == this.window) {
            this.tabVisible();
        }
        if (this.clipRef.update()) {
            clip = (String)this.clipRef.get();
            this.rig.setCurrentAction(clip);
            if (this.rig.isBlendable(clip)) {
                this.blend.setEnabled(true);
                this.rig.setBlendFactor(clip, (Double)this.blend.getValue());
            } else {
                this.blend.setEnabled(false);
            }
        }
        if (this.blendRef.update() && this.rig.isBlendable(clip = (String)this.clipRef.get())) {
            this.rig.setBlendFactor(clip, (Double)this.blend.getValue());
        }
        if (this.collidersOpen.update()) {
            ((ColliderViewState)this.getState(ColliderViewState.class)).setEnabled((Boolean)this.collidersOpen.get());
        }
        if (this.showArmatureRef.update()) {
            ((ArmatureViewState)this.getState(ArmatureViewState.class)).setEnabled((Boolean)this.showArmatureRef.get());
        }
    }

    protected void onDisable() {
    }
}

