/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Line;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigViewState;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArmatureViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ArmatureViewState.class);
    private VersionedReference<Rig> rigRef;
    private Rig rig;
    private Node modelRoot;
    private SkinningControl skin;
    private Armature armature;
    private Map<Joint, View> viewIndex = new HashMap<Joint, View>();
    private SafeArrayList<View> views = new SafeArrayList(View.class);
    private View selectedView;

    public ArmatureViewState() {
        this.setEnabled(false);
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void setRig(Rig rig) {
        if (this.rig == rig) {
            return;
        }
        this.rig = rig;
        this.skin = rig == null ? null : rig.getSkinningControl();
        Armature armature = this.armature = this.skin == null ? null : this.skin.getArmature();
        if (rig != null) {
            Spatial rigView = this.skin.getSpatial();
            this.modelRoot.setLocalTranslation(rigView.getWorldTranslation());
            this.modelRoot.setLocalRotation(rigView.getWorldRotation());
            this.modelRoot.setLocalScale(rigView.getWorldScale());
        }
        this.resetViews();
    }

    protected void initialize(Application app) {
        this.modelRoot = new Node("modelRoot");
        this.getRoot().attachChild((Spatial)this.modelRoot);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.rigRef = ((RigViewState)this.getState(RigViewState.class, true)).createRigReference();
        this.setRig((Rig)this.rigRef.get());
    }

    protected void onDisable() {
        this.rigRef = null;
        this.setRig(null);
    }

    public void update(float tpf) {
        if (this.rigRef.update()) {
            this.setRig((Rig)this.rigRef.get());
        }
        if (this.rig == null) {
            return;
        }
        for (View view : (View[])this.views.getArray()) {
            view.update();
        }
    }

    protected void resetViews() {
        this.viewIndex.clear();
        for (View view : this.views) {
            view.release();
        }
        this.views.clear();
        if (this.armature == null) {
            return;
        }
        for (Joint joint : this.armature.getJointList()) {
            View view = new View(joint);
            this.viewIndex.put(joint, view);
            this.views.add((Object)view);
        }
    }

    protected Spatial createJointView(String name, ColorRGBA color) {
        Node result = new Node("JointHolder:" + name);
        Material material = GuiGlobals.getInstance().createMaterial(color, false).getMaterial();
        material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        Geometry geom = new Geometry("Joint", (Mesh)new Box(0.01f, 0.01f, 0.01f));
        geom.setMaterial(material);
        result.attachChild((Spatial)geom);
        geom.setQueueBucket(RenderQueue.Bucket.Translucent);
        material.getAdditionalRenderState().setDepthTest(false);
        return result;
    }

    protected Geometry createBoneView(String name, Mesh boneMesh, ColorRGBA color) {
        Material material = GuiGlobals.getInstance().createMaterial(color, false).getMaterial();
        material.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        Geometry geom = new Geometry("Bone", boneMesh);
        geom.setMaterial(material);
        geom.setQueueBucket(RenderQueue.Bucket.Translucent);
        material.getAdditionalRenderState().setDepthTest(false);
        return geom;
    }

    private class View {
        Joint joint;
        Node holder;
        ColorRGBA color = new ColorRGBA(1.0f, 1.0f, 0.0f, 0.5f);
        ColorRGBA boneColor = new ColorRGBA(1.0f, 0.5f, 0.0f, 0.5f);
        Spatial jointView;
        Geometry boneView;
        Line boneMesh;

        public View(Joint joint) {
            this.joint = joint;
            this.holder = new Node("JointHolder:" + joint.getName());
            ArmatureViewState.this.modelRoot.attachChild((Spatial)this.holder);
            this.jointView = ArmatureViewState.this.createJointView(joint.getName(), this.color);
            this.holder.attachChild(this.jointView);
            this.boneMesh = new Line(new Vector3f(), new Vector3f());
            this.boneView = ArmatureViewState.this.createBoneView(joint.getName(), (Mesh)this.boneMesh, this.boneColor);
            this.holder.attachChild((Spatial)this.boneView);
            if (joint.getParent() == null) {
                this.boneColor.set(0.1f, 0.1f, 0.1f, 0.5f);
            }
            this.update();
        }

        public void update() {
            Transform xform = this.joint.getModelTransform();
            this.jointView.setLocalTranslation(xform.getTranslation());
            this.jointView.setLocalRotation(xform.getRotation());
            this.jointView.setLocalScale(xform.getScale());
            Joint parent = this.joint.getParent();
            Vector3f start = xform.getTranslation();
            Vector3f end = new Vector3f();
            if (parent != null) {
                end = parent.getModelTransform().getTranslation();
            }
            this.boneMesh.updatePoints(start, end);
            this.boneMesh.updateBound();
            this.boneView.updateModelBound();
        }

        public void release() {
            this.holder.removeFromParent();
        }
    }
}

