/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.tool.AttachmentInfo;
import com.simsilica.tool.EulerRotationEditor;
import com.simsilica.tool.Vec3dEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(AttachmentEditor.class);
    private AttachmentInfo attachment;
    private TextField nameField;
    private Selector<String> jointField;
    private Vec3dEditor offsetEditor;
    private EulerRotationEditor orientEditor;
    private VersionedReference nameRef;
    private VersionedReference<String> jointRef;
    private VersionedReference<Vec3d> offsetRef;
    private VersionedReference<Quatd> orientRef;

    public AttachmentEditor(VersionedList<String> jointNames) {
        Container props = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        props.addChild((Node)new Label("Name:"), new Object[0]);
        this.nameField = (TextField)props.addChild((Node)new TextField(""), new Object[]{1});
        this.nameRef = this.nameField.getDocumentModel().createReference();
        props.addChild((Node)new Label("Joint:"), new Object[0]);
        this.jointField = (Selector)props.addChild((Node)new Selector(jointNames), new Object[]{1});
        this.jointRef = this.jointField.createSelectedItemReference();
        props.addChild((Node)new Label("Offset:"), new Object[0]);
        this.offsetEditor = (Vec3dEditor)props.addChild((Node)new Vec3dEditor(Axis.X, -1.0, 1.0, 0.01, 0.01), new Object[]{1});
        this.offsetRef = this.offsetEditor.createReference();
        props.addChild((Node)new Label("Orient:"), new Object[0]);
        this.orientEditor = (EulerRotationEditor)props.addChild((Node)new EulerRotationEditor(Axis.X), new Object[]{1});
        this.orientRef = this.orientEditor.createReference();
    }

    public void setAttachment(AttachmentInfo attachment) {
        this.attachment = attachment;
        this.resetFields();
    }

    public AttachmentInfo getAttachment() {
        return this.attachment;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.nameRef.update()) {
            this.attachment.setName(this.nameField.getText());
        }
        if (this.jointRef.update()) {
            this.attachment.setJoint((String)this.jointRef.get());
        }
        if (this.offsetRef.update()) {
            this.attachment.setOffset((Vec3d)this.offsetRef.get());
        }
        if (this.orientRef.update()) {
            this.attachment.setOrientation((Quatd)this.orientRef.get());
        }
    }

    protected void resetFields() {
        if (this.attachment == null) {
            this.nameField.setText("");
            this.jointField.setSelectedItem(null);
            this.offsetEditor.setObject(new Vec3d());
            this.orientEditor.setObject(new Quatd());
        } else {
            this.nameField.setText(this.attachment.getName());
            this.jointField.setSelectedItem((Object)this.attachment.getJoint());
            this.offsetEditor.setObject(this.attachment.getOffset());
            this.orientEditor.setObject(this.attachment.getOrientation());
        }
    }
}

