/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.scene.Node;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GridPanel;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.tool.AttachmentEditor;
import com.simsilica.tool.AttachmentInfo;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentManager
extends Container {
    static Logger log = LoggerFactory.getLogger(AttachmentManager.class);
    private Rig rig;
    private RigInfo rigInfo;
    private VersionedList<String> jointNames = new VersionedList();
    private VersionedReference<AttachmentInfo> selectedAttachmentRef;
    private ListBox<AttachmentInfo> attachmentList = (ListBox)this.addChild((Node)new ListBox(), new Object[0]);
    private VersionedReference<Integer> listSelectionRef = this.attachmentList.getSelectionModel().createSelectionReference();
    private Container editorHolder;
    private AttachmentEditor attachmentEditor;
    private VersionedReference<AttachmentInfo> attRef;

    public AttachmentManager() {
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("New", (Object)this, "addAttachment")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Remove", (Object)this, "removeAttachment")), new Object[0]);
        this.editorHolder = (Container)this.addChild((Node)new Container(), new Object[0]);
        this.editorHolder.setBackground(null);
        this.attachmentEditor = new AttachmentEditor(this.jointNames);
    }

    public void setRig(Rig rig) {
        if (this.rig == rig) {
            return;
        }
        this.rig = rig;
        if (rig == null) {
            this.rigInfo = null;
            this.jointNames.clear();
            this.selectedAttachmentRef = null;
            this.attachmentList.setModel(new VersionedList());
            this.attachmentEditor.setAttachment(null);
        } else {
            this.rigInfo = rig.getRigInfo();
            this.attachmentList.setModel(this.rigInfo.getAttachments());
            this.jointNames.clear();
            this.jointNames.addAll(rig.getJointNames());
            this.selectedAttachmentRef = rig.createSelectedAttachmentReference();
        }
    }

    public Rig getRig() {
        return this.rig;
    }

    protected void addAttachment() {
        int index = this.rigInfo.getAttachments().size();
        AttachmentInfo item = new AttachmentInfo("att_" + index);
        this.rigInfo.getAttachments().add((Object)item);
        this.attachmentList.getSelectionModel().setSelection(Integer.valueOf(index));
    }

    protected void removeAttachment() {
        this.rigInfo.getAttachments().remove(this.attachmentList.getSelectedItem());
    }

    protected void selectAttachment() {
        AttachmentInfo item = (AttachmentInfo)this.attachmentList.getSelectedItem();
        this.rig.setSelectedAttachment(item);
        this.attRef = item == null ? null : item.createReference();
    }

    protected void editAttachment() {
        AttachmentInfo item = (AttachmentInfo)this.selectedAttachmentRef.get();
        log.info("editAttachment():" + item);
        int index = this.rigInfo.getAttachments().indexOf((Object)item);
        Integer selection = this.attachmentList.getSelectionModel().getSelection();
        selection = selection == null ? -1 : selection;
        if (selection != index) {
            this.attachmentList.getSelectionModel().setSelection(Integer.valueOf(index));
        }
        this.attachmentEditor.setAttachment(item);
        if (item == null) {
            this.attachmentEditor.removeFromParent();
        } else {
            this.editorHolder.addChild((Node)this.attachmentEditor, new Object[0]);
        }
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.listSelectionRef.update()) {
            this.selectAttachment();
        }
        if (this.selectedAttachmentRef != null && this.selectedAttachmentRef.update()) {
            this.editAttachment();
        }
        if (this.attRef != null && this.attRef.update()) {
            log.info("refresh list");
            GridPanel grid = this.attachmentList.getGridPanel();
            grid.setVisibleRows(grid.getVisibleRows());
        }
    }
}

