/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.input.event.MouseButtonEvent;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GridPanel;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.component.TbtQuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.DefaultMouseListener;
import com.simsilica.lemur.event.MouseEventControl;
import com.simsilica.lemur.event.MouseListener;
import com.simsilica.lemur.grid.ArrayGridModel;
import com.simsilica.lemur.grid.GridModel;
import com.simsilica.lemur.grid.GridModelWrapper;
import com.simsilica.mathd.Vec3i;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellSelector
extends Container {
    static Logger log = LoggerFactory.getLogger(CellSelector.class);
    private static final ColorRGBA TRANSPARENT = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
    private Texture background;
    private int width;
    private int height;
    private int cellSize;
    private Vec3i[][] cells;
    private ArrayGridModel<Vec3i> cellGridModel;
    private CellAdapter cellPanels;
    private GridPanel grid;
    private VersionedHolder<Vec3i> selectedType = new VersionedHolder((Object)new Vec3i(0, 0, 0));
    private VersionedReference<Vec3i> selectionRef = this.selectedType.createReference();
    private Vec3i lastCell = null;

    public CellSelector(Texture background, int width, int height, int cellSize) {
        super((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.None));
        this.background = background;
        this.width = width;
        this.height = height;
        this.cellSize = cellSize;
        this.cells = new Vec3i[height][width];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                this.cells[j][i] = new Vec3i(i, j, 0);
            }
        }
        this.cellGridModel = new ArrayGridModel((Object[][])this.cells);
        this.cellPanels = new CellAdapter(this.cellGridModel);
        this.grid = (GridPanel)this.addChild((Node)new GridPanel((GridModel)this.cellPanels), new Object[0]);
        this.grid.setVisibleSize(width, height);
        this.grid.setBackground((GuiComponent)new QuadBackgroundComponent(background));
        this.resetSelection();
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.selectionRef.update()) {
            this.resetSelection();
        }
    }

    public void setSelectedCell(Vec3i cell) {
        this.selectedType.setObject((Object)cell);
    }

    public Vec3i getSelectedCell() {
        return (Vec3i)this.selectedType.getObject();
    }

    private void resetSelection() {
        Panel p;
        if (this.lastCell != null) {
            p = this.cellPanels.getPanel(this.lastCell);
            ((TbtQuadBackgroundComponent)p.getBackground()).setColor(TRANSPARENT);
        }
        this.lastCell = (Vec3i)this.selectionRef.get();
        if (this.lastCell != null) {
            p = this.cellPanels.getPanel(this.lastCell);
            ((TbtQuadBackgroundComponent)p.getBackground()).setColor(ColorRGBA.White);
        }
    }

    private class CellAdapter
    extends GridModelWrapper<Vec3i, Panel> {
        private Panel[][] panels;

        public CellAdapter(ArrayGridModel<Vec3i> delegate) {
            super(delegate);
            this.panels = new Panel[CellSelector.this.height][CellSelector.this.width];
            for (int i = 0; i < CellSelector.this.width; ++i) {
                for (int j = 0; j < CellSelector.this.height; ++j) {
                    Panel panel = new Panel();
                    this.panels[j][i] = panel;
                    Panel p = panel;
                    p.setPreferredSize(new Vector3f((float)CellSelector.this.cellSize, (float)CellSelector.this.cellSize, 1.0f));
                    p.setInsets(new Insets3f(0.0f, 0.0f, 0.0f, 0.0f));
                    Texture border = GuiGlobals.getInstance().loadTexture("com/simsilica/lemur/icons/border.png", false, false);
                    TbtQuadBackgroundComponent bg = TbtQuadBackgroundComponent.create((Texture)border, (float)1.0f, (int)2, (int)2, (int)6, (int)6, (float)0.0f, (boolean)false);
                    bg.setColor(TRANSPARENT);
                    p.setBackground((GuiComponent)bg);
                    MouseEventControl.addListenersToSpatial((Spatial)p, (MouseListener[])new MouseListener[]{new PaletteListener(new Vec3i(i, j, 0))});
                }
            }
        }

        public Panel getPanel(Vec3i cell) {
            return this.panels[cell.y][cell.x];
        }

        public Panel getCell(int row, int col, Panel existing) {
            if (existing != null) {
                return existing;
            }
            Vec3i cell = (Vec3i)this.getDelegate().getCell(row, col, null);
            if (cell == null) {
                return null;
            }
            return this.panels[row][col];
        }

        public void setCell(int row, int col, Panel value) {
        }
    }

    private class PaletteListener
    extends DefaultMouseListener {
        private Vec3i cell;

        public PaletteListener(Vec3i cell) {
            this.cell = cell;
        }

        protected void click(MouseButtonEvent event, Spatial target, Spatial capture) {
            CellSelector.this.setSelectedCell(this.cell);
        }
    }
}

