/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mblock.CellArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingBuilder
implements VersionedObject<ClothingBuilder> {
    static Logger log = LoggerFactory.getLogger(ClothingBuilder.class);
    private CellArray swatches;
    private int[][] levels;
    private long version;

    public ClothingBuilder(int width, int height, int layers) {
        this.swatches = new CellArray(width, height, layers);
        this.levels = new int[width][height];
    }

    public static int toCell(int shape, int fabric) {
        return shape << 16 | fabric;
    }

    public static int toShape(int value) {
        return value >> 16 & 0xFFFF;
    }

    public static int toFabric(int value) {
        return value & 0xFFFF;
    }

    public void clear() {
        this.swatches.clear(0);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                this.levels[i][j] = 0;
            }
        }
    }

    public int getValue(int x, int y, int layer) {
        return this.swatches.getCell(x, y, layer);
    }

    public void setCells(CellArray source) {
        this.swatches.set(source);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int level = 0;
                for (int k = 0; k < 32; ++k) {
                    if (this.swatches.getCell(i, j, k) == 0) continue;
                    ++level;
                }
                this.levels[i][j] = level;
            }
        }
    }

    public CellArray getCells() {
        return this.swatches;
    }

    public long getVersion() {
        return this.version;
    }

    public ClothingBuilder getObject() {
        return this;
    }

    public VersionedReference<ClothingBuilder> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    public int getLayer(int x, int y) {
        return this.levels[x][y];
    }

    public boolean addSwatch(int x, int y, int shape, int fabric) {
        log.info("addSwatch(" + x + ", " + y + ", " + shape + ", " + fabric + ")");
        if (x < 0 || x >= 32 || y < 0 || y >= 32) {
            return false;
        }
        int value = ClothingBuilder.toCell(shape, fabric);
        return this.addValue(x, y, value);
    }

    protected boolean addValue(int x, int y, int value) {
        int layer = this.levels[x][y];
        if (layer >= 32) {
            return false;
        }
        if (layer > 0 && this.swatches.getCell(x, y, layer - 1) == value) {
            return false;
        }
        this.swatches.setCell(x, y, layer, value);
        ++this.version;
        this.levels[x][y] = layer + 1;
        return true;
    }

    public int removeSwatch(int x, int y) {
        int existing;
        log.info("removeSwatch(" + x + ", " + y + ")");
        int layer = this.levels[x][y];
        if (layer <= 0) {
            return 0;
        }
        if ((existing = this.swatches.getCell(x, y, --layer)) != 0) {
            this.swatches.setCell(x, y, layer, 0);
            ++this.version;
        }
        this.levels[x][y] = layer;
        return existing;
    }
}

