/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.math.ColorRGBA;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.image.ImageRaster;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingPainter {
    static Logger log = LoggerFactory.getLogger(ClothingPainter.class);
    private Image baseImage = ClothingPainter.createImage(1024, 1024);
    private Image normalImage = ClothingPainter.createImage(1024, 1024);
    private Image metalRoughImage = ClothingPainter.createImage(1024, 1024);
    private Texture baseTexture = new Texture2D(this.baseImage);
    private Texture normalTexture = new Texture2D(this.normalImage);
    private Texture metalRoughTexture = new Texture2D(this.metalRoughImage);
    private ImageRaster baseRaster = ImageRaster.create((Image)this.baseImage);
    private ImageRaster normalRaster = ImageRaster.create((Image)this.normalImage);
    private ImageRaster metalRoughRaster = ImageRaster.create((Image)this.metalRoughImage);

    public ClothingPainter() {
        ColorRGBA defaultNormal = new ColorRGBA(0.5f, 0.5f, 1.0f, 0.0f);
        ClothingPainter.fillRaster(this.normalRaster, defaultNormal);
    }

    public static Image createImage(int width, int height) {
        int size = width * height * 3;
        ByteBuffer data = BufferUtils.createByteBuffer((int)size);
        return new Image(Image.Format.BGR8, width, height, data, ColorSpace.Linear);
    }

    public static void fillRaster(ImageRaster raster, ColorRGBA value) {
        int width = raster.getWidth();
        int height = raster.getHeight();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < width; ++j) {
                raster.setPixel(i, j, value);
            }
        }
    }

    public int getWidth() {
        return 1024;
    }

    public int getHeight() {
        return 1024;
    }

    protected int clamp(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public void paint(int x, int y, ColorRGBA base, ColorRGBA normal, ColorRGBA metalRough) {
        ColorRGBA existing;
        x = this.clamp(x, 0, this.getWidth() - 1);
        y = this.clamp(y, 0, this.getHeight() - 1);
        if (base.a < 1.0f) {
            existing = this.baseRaster.getPixel(x, y);
            existing.interpolateLocal(base, base.a);
            this.baseRaster.setPixel(x, y, existing);
        } else {
            this.baseRaster.setPixel(x, y, base);
        }
        this.normalRaster.setPixel(x, y, normal);
        if (metalRough.a < 1.0f) {
            existing = this.metalRoughRaster.getPixel(x, y);
            existing.interpolateLocal(metalRough, metalRough.a);
            this.metalRoughRaster.setPixel(x, y, existing);
        } else {
            this.metalRoughRaster.setPixel(x, y, metalRough);
        }
    }

    public Texture getBaseTexture() {
        return this.baseTexture;
    }

    public Texture getNormalTexture() {
        return this.normalTexture;
    }

    public Texture getMetalRoughnessTexture() {
        return this.metalRoughTexture;
    }
}

