/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.google.common.base.Function;
import com.google.common.io.Files;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.asset.AssetManager;
import com.jme3.collision.CollisionResult;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import com.jme3.texture.image.ImageRaster;
import com.jme3.util.TangentBinormalGenerator;
import com.simsilica.jmec.AssetReader;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.EmptyAction;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.component.DynamicInsetsComponent;
import com.simsilica.lemur.component.InsetsComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import com.simsilica.lemur.event.DefaultCursorListener;
import com.simsilica.lemur.event.PopupState;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mathd.Vec3i;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.Direction;
import com.simsilica.tool.AddSwatch;
import com.simsilica.tool.CellSelector;
import com.simsilica.tool.ClothingBuilder;
import com.simsilica.tool.ClothingPainter;
import com.simsilica.tool.ColliderViewState;
import com.simsilica.tool.CreateClothingDialog;
import com.simsilica.tool.DirMaskEditor;
import com.simsilica.tool.Edit;
import com.simsilica.tool.EditHistory;
import com.simsilica.tool.Fabric;
import com.simsilica.tool.FabricInfo;
import com.simsilica.tool.FileDialog;
import com.simsilica.tool.ImageSource;
import com.simsilica.tool.ImageSources;
import com.simsilica.tool.ImageUtils;
import com.simsilica.tool.MainAppFunctions;
import com.simsilica.tool.MeshUtils;
import com.simsilica.tool.RemoveSwatch;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigInfo;
import com.simsilica.tool.RigViewState;
import com.simsilica.tool.RiggerConfig;
import com.simsilica.tool.SwatchIndex;
import com.simsilica.tool.SwatchShape;
import com.simsilica.tool.ToolState;
import com.simsilica.tool.io.ClothingFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ClothingState.class);
    private VersionedReference<Rig> rigRef;
    private Rig rig;
    private RigInfo rigInfo;
    private boolean tabEnabled;
    private Container window;
    private VersionedReference<TabbedPanel.Tab> selectedTabRef;
    private boolean clothingEnabled = false;
    private String originalAction = null;
    private PaintListener paintListener = new PaintListener();
    private ClothingPainter clothingPainter;
    private AssetReader assetReader;
    private ClothingBuilder clothingBuilder;
    private VersionedReference<ClothingBuilder> builderRef;
    private boolean[][] filledCells;
    private boolean[][] changedCells;
    private EditHistory history = new EditHistory(500);
    private Edit lastEdit;
    private VersionedList<FabricInfo> fabricInfos = new VersionedList();
    private Selector<FabricInfo> fabricSelector;
    private VersionedReference<Integer> selectedFabricRef;
    private FabricInfo currentFabricInfo;
    private Fabric currentFabric;
    private int currentFabricIndex = -1;
    private ColorRGBA defaultMetalRough = new ColorRGBA(0.0f, 0.5f, 0.0f, 0.0f);
    private DirMaskEditor dirMaskEditor;
    private SwatchIndex shapeIndex = new SwatchIndex();
    private CellSelector shapeSelector;
    private List<Fabric> fabrics = new ArrayList<Fabric>();
    private ClothingFormat clothingFormat;
    private List<Geometry> geometryList = new ArrayList<Geometry>();
    private File currentFile;
    private FileDialog fileDialog;
    private Container fileSaveDialog;
    private TextField fileEntry;

    public static ColorRGBA parseColor(String s) {
        int r = Integer.parseInt(s.substring(1, 3), 16);
        int g = Integer.parseInt(s.substring(3, 5), 16);
        int b = Integer.parseInt(s.substring(5, 7), 16);
        return new ColorRGBA((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    protected void clear() {
        if (this.lastEdit != this.history.getLastEdit()) {
            ((OptionPanelState)this.getState(OptionPanelState.class)).show("Clear All Clothing", "Really clear clothing?", new Action[]{new CallMethodAction("Yes", (Object)this, "resetWorkspace"), new EmptyAction("No"), new EmptyAction("Cancel")});
        } else {
            this.resetWorkspace();
        }
    }

    protected List<String> getFileList() {
        ArrayList<String> results = new ArrayList<String>();
        File root = RiggerConfig.getInstance().getFile("clothing");
        if (!root.exists()) {
            root.mkdirs();
        }
        for (File f : root.listFiles()) {
            if (f.isDirectory() || !f.getName().endsWith(".clothing")) continue;
            results.add(this.toName(f));
        }
        return results;
    }

    public void open() {
        System.out.println("open()");
        if (this.lastEdit != this.history.getLastEdit()) {
            ((OptionPanelState)this.getState(OptionPanelState.class)).show("Abandon Changes?", "Really abandon current changes?", new Action[]{new CallMethodAction("Yes", (Object)this, "selectFile"), new EmptyAction("No"), new EmptyAction("Cancel")});
        } else {
            this.selectFile();
        }
    }

    protected void selectFile() {
        log.info("selectFile()");
        this.fileDialog = new FileDialog("Open Workspace", this.getFileList(), "Load", () -> this.openFile());
        GuiGlobals.getInstance().getPopupState().centerInGui((Spatial)this.fileDialog);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.fileDialog);
    }

    protected void openFile() {
        log.info("openFile:" + this.fileDialog.getSelectedFile());
        if (this.fileDialog.getSelectedFile() == null) {
            return;
        }
        File f = this.toFile(this.fileDialog.getSelectedFile());
        this.doOpen(f);
    }

    public void save() {
        log.info("save()");
        if (this.currentFile == null) {
            this.saveAs();
            return;
        }
        this.doSave(this.currentFile);
    }

    protected void saveAs() {
        log.info("saveAs()");
        if (this.currentFile != null) {
            this.fileEntry.setText(this.toName(this.currentFile));
        }
        Vector3f pref = this.fileSaveDialog.getPreferredSize();
        Vector3f loc = new Vector3f((float)this.getApplication().getCamera().getWidth() * 0.5f, (float)this.getApplication().getCamera().getHeight() * 0.5f, 0.0f);
        loc.x -= pref.x * 0.5f;
        loc.y += pref.y * 0.5f;
        this.fileSaveDialog.setLocalTranslation(loc);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.fileSaveDialog);
    }

    protected void cancelSave() {
        this.fileSaveDialog.removeFromParent();
    }

    protected String toName(File f) {
        return Files.getNameWithoutExtension((String)f.getName());
    }

    protected File toFile(String name) {
        if (!name.endsWith(".clothing")) {
            name = name + ".clothing";
        }
        return RiggerConfig.getInstance().getFile("clothing/" + name);
    }

    protected void saveFile() {
        this.fileSaveDialog.removeFromParent();
        String name = this.fileEntry.getText();
        File file = this.toFile(name);
        if (file.exists()) {
            ((OptionPanelState)this.getState(OptionPanelState.class)).show("Overwrite?", "Really overwrite existing file:" + name + "?", new Action[]{new CallMethodAction("Yes", (Object)this, "doSave"), new CallMethodAction("No", (Object)this, "saveAs"), new EmptyAction("Cancel")});
        } else {
            this.doSave(file);
        }
    }

    protected void doOpen(File file) {
        try {
            if (file.exists()) {
                log.info("Loading:" + file);
                this.clothingBuilder.setCells(this.readCells(file));
                this.currentFile = file;
                this.history.clear();
                this.repaint(true);
            }
        }
        catch (IOException e) {
            log.error("Error reading cells", (Throwable)e);
        }
    }

    protected void doSave() {
        String name = this.fileEntry.getText();
        File file = this.toFile(name);
        this.doSave(file);
    }

    protected void doSave(File file) {
        try {
            log.info("Saving:" + file);
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            this.saveCells(file, this.clothingBuilder.getCells());
            this.currentFile = file;
            this.lastEdit = this.history.getLastEdit();
        }
        catch (IOException e) {
            log.error("Error saving cells", (Throwable)e);
        }
    }

    protected void addClothingFromTemplate() {
        CreateClothingDialog dialog = new CreateClothingDialog(this, this.clothingBuilder, this.history, this.fabricInfos, this.clothingFormat);
        ((PopupState)this.getState(PopupState.class)).centerInGui((Spatial)dialog);
        ((PopupState)this.getState(PopupState.class)).showModalPopup((Spatial)dialog);
    }

    protected void initialize(Application app) {
        this.rigRef = ((RigViewState)this.getState(RigViewState.class, true)).createRigReference();
        this.clothingBuilder = new ClothingBuilder(32, 32, 32);
        this.builderRef = this.clothingBuilder.createReference();
        this.clothingPainter = new ClothingPainter();
        this.filledCells = new boolean[32][32];
        this.changedCells = new boolean[32][32];
        this.fileSaveDialog = new Container();
        this.fileSaveDialog.addChild((Node)new Label("Save As...", new ElementId("title.label")), new Object[0]);
        this.fileEntry = (TextField)this.fileSaveDialog.addChild((Node)new TextField("MyFile"), new Object[0]);
        Container buttons = (Container)this.fileSaveDialog.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Save", (Object)this, "saveFile")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Cancel", (Object)this, "cancelSave")), new Object[0]);
        this.window = new Container();
        ((ToolState)this.getState(ToolState.class)).getTabs().addTab("Clothing", (Panel)this.window);
        Container actions = (Container)this.window.addChild((Node)new Container(), new Object[0]);
        actions.addChild((Node)new ActionButton((Action)new CallMethodAction("Reset Clothing", (Object)this, "clear")), new Object[0]);
        actions.addChild((Node)new ActionButton((Action)new CallMethodAction("Open Clothing...", (Object)this, "open")), new Object[0]);
        actions.addChild((Node)new ActionButton((Action)new CallMethodAction("Save Clothing", (Object)this, "save")), new Object[0]);
        actions.addChild((Node)new ActionButton((Action)new CallMethodAction("Save As Clothing...", (Object)this, "saveAs")), new Object[0]);
        actions.addChild((Node)new Label(" "), new Object[0]);
        actions.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "addClothingFromTemplate")), new Object[0]);
        Container properties = (Container)this.window.addChild((Node)new Container(), new Object[0]);
        properties.addChild((Node)new Label("Fabric:"), new Object[0]);
        this.fabricSelector = (Selector)properties.addChild((Node)new Selector(this.fabricInfos), new Object[0]);
        Function func = fabricInfo -> fabricInfo == null ? "None" : fabricInfo.getName();
        this.fabricSelector.setValueRenderer((ValueRenderer)new DefaultValueRenderer(func));
        this.selectedFabricRef = this.fabricSelector.getSelectionModel().createSelectionReference();
        this.selectedTabRef = ((ToolState)this.getState(ToolState.class)).getTabs().getSelectionModel().createReference();
        this.window.addChild((Node)new Label("Hard edges:"), new Object[0]);
        this.dirMaskEditor = (DirMaskEditor)this.window.addChild((Node)new DirMaskEditor(), new Object[0]);
        this.dirMaskEditor.setInsetsComponent((InsetsComponent)new DynamicInsetsComponent(0.0f, 0.0f, 0.0f, 1.0f));
        this.window.addChild((Node)new Label("Shapes:"), new Object[0]);
        this.assetReader = new AssetReader(RiggerConfig.getInstance().getProjectDir());
        Texture baseShapeAtlas = this.assetReader.getAssetManager().loadTexture("textures/shapes.png");
        ImageSource<Texture> atlasSource = ImageSources.texture(baseShapeAtlas);
        SwatchShape shape = new SwatchShape("full", 0, 7);
        shape.addEdges(Direction.North, Direction.South, Direction.East, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("halfbar-n", 1, 7);
        shape.addEdges(Direction.North, Direction.East, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("halfbar-w", 2, 7);
        shape.addEdges(Direction.North, Direction.South, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("halfbar-s", 3, 7);
        shape.addEdges(Direction.South, Direction.East, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("halfbar-e", 4, 7);
        shape.addEdges(Direction.North, Direction.East, Direction.South);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("halfbar-ns", 5, 7);
        shape.addEdges(Direction.North, Direction.South);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("halfbar-ew", 6, 7);
        shape.addEdges(Direction.East, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("square", 7, 7);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("frayed-n", 2, 2);
        shape.addEdges(Direction.North, Direction.East, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("frayed-w", 3, 2);
        shape.addEdges(Direction.North, Direction.South, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("frayed-s", 4, 2);
        shape.addEdges(Direction.South, Direction.East, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("frayed-e", 5, 2);
        shape.addEdges(Direction.North, Direction.East, Direction.South);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("tri-nw", 0, 6);
        shape.addEdges(Direction.North, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("tri-ne", 1, 6);
        shape.addEdges(Direction.North, Direction.East);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("tri-sw", 0, 5);
        shape.addEdges(Direction.South, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("tri-se", 1, 5);
        shape.addEdges(Direction.South, Direction.East);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("tri-n", 2, 6);
        shape.addEdges(Direction.North);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("tri-w", 3, 6);
        shape.addEdges(Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("tri-s", 4, 6);
        shape.addEdges(Direction.South);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("tri-e", 5, 6);
        shape.addEdges(Direction.East);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("sm-tri-nw", 0, 2);
        shape.addEdges(Direction.North, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("sm-tri-ne", 1, 2);
        shape.addEdges(Direction.North, Direction.East);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("sm-tri-sw", 0, 1);
        shape.addEdges(Direction.South, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("sm-tri-se", 1, 1);
        shape.addEdges(Direction.South, Direction.East);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("button-n", 2, 5);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("button-w", 3, 5);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("button-s", 4, 5);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("button-e", 5, 5);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("button", 6, 5);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("buckle", 0, 4);
        shape.setForcedMask(SwatchShape.dirsToMask(Direction.North, Direction.South, Direction.East, Direction.West));
        this.shapeIndex.add(shape);
        shape = new SwatchShape("buckle-n", 1, 4);
        shape.addEdges(Direction.North);
        shape.setForcedMask(SwatchShape.dirsToMask(Direction.East, Direction.West));
        this.shapeIndex.add(shape);
        shape = new SwatchShape("buckle-w", 2, 4);
        shape.addEdges(Direction.West);
        shape.setForcedMask(SwatchShape.dirsToMask(Direction.North, Direction.South));
        this.shapeIndex.add(shape);
        shape = new SwatchShape("buckle-s", 3, 4);
        shape.addEdges(Direction.South);
        shape.setForcedMask(SwatchShape.dirsToMask(Direction.East, Direction.West));
        this.shapeIndex.add(shape);
        shape = new SwatchShape("buckle-e", 4, 4);
        shape.addEdges(Direction.East);
        shape.setForcedMask(SwatchShape.dirsToMask(Direction.North, Direction.South));
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces", 7, 5);
        shape.addEdges(Direction.North);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-e", 5, 4);
        shape.addEdges(Direction.East);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-ew", 6, 4);
        shape.addEdges(Direction.East, Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-w", 7, 4);
        shape.addEdges(Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-n", 6, 6);
        shape.addEdges(Direction.North);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-s", 7, 6);
        shape.addEdges(Direction.South);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag1", 0, 3);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag1-e", 2, 3);
        shape.addEdges(Direction.East);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag1-w", 3, 3);
        shape.addEdges(Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag1-s", 6, 3);
        shape.addEdges(Direction.South);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag1-n", 6, 2);
        shape.addEdges(Direction.North);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag2", 1, 3);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag2-e", 4, 3);
        shape.addEdges(Direction.East);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag2-w", 5, 3);
        shape.addEdges(Direction.West);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag2-s", 7, 3);
        shape.addEdges(Direction.South);
        this.shapeIndex.add(shape);
        shape = new SwatchShape("laces-diag2-n", 7, 2);
        shape.addEdges(Direction.North);
        this.shapeIndex.add(shape);
        this.shapeIndex.buildVariants(atlasSource);
        Texture2D t = new Texture2D(ImageUtils.createImage(Image.Format.ABGR8, 256, 256));
        ImageRaster selectorRaster = ImageRaster.create((Image)t.getImage());
        List<SwatchShape> baseShapes = this.shapeIndex.getBaseShapes();
        for (int i = 0; i < baseShapes.size(); ++i) {
            SwatchShape ss = baseShapes.get(i);
            Vec3i cell = ss.getSourceCell();
            int xShape = cell.x;
            int yShape = cell.y;
            ImageSource<ImageSource> source = ImageSources.subimage(atlasSource, xShape * 32, yShape * 32, 32, 32);
            int xCell = i % 8;
            int yCell = 7 - i / 8;
            ImageUtils.paint(source, selectorRaster, xCell * 32, yCell * 32);
        }
        this.shapeSelector = (CellSelector)this.window.addChild((Node)new CellSelector((Texture)t, 8, 8, 32), new Object[0]);
        FabricInfo fabric = new FabricInfo("base");
        fabric.setBaseTexture("textures/BaseSkin.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.6);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("bleached-linen");
        fabric.setBaseColor(ClothingState.parseColor("#c8c5bb"));
        fabric.setNormalTexture("textures/burlap-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("linen");
        fabric.setBaseColor(ClothingState.parseColor("#bdaf93"));
        fabric.setNormalTexture("textures/burlap-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave");
        fabric.setBaseColor(ClothingState.parseColor("#bdaf93"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-red");
        fabric.setBaseColor(ClothingState.parseColor("#af3636"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-dark-red");
        fabric.setBaseColor(ClothingState.parseColor("#6a0404"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-green");
        fabric.setBaseColor(ClothingState.parseColor("#3d752f"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-dark-green");
        fabric.setBaseColor(ClothingState.parseColor("#063e06"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-blue");
        fabric.setBaseColor(ClothingState.parseColor("#4d6995"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-dark-blue");
        fabric.setBaseColor(ClothingState.parseColor("#040e17"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-yellow");
        fabric.setBaseColor(ClothingState.parseColor("#cfc86d"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-dark-yellow");
        fabric.setBaseColor(ClothingState.parseColor("#5c5716"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-pink");
        fabric.setBaseColor(ClothingState.parseColor("#b66992"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-dark-pink");
        fabric.setBaseColor(ClothingState.parseColor("#850c5f"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-orange");
        fabric.setBaseColor(ClothingState.parseColor("#c77932"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-dark-orange");
        fabric.setBaseColor(ClothingState.parseColor("#9f3c0c"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-purple");
        fabric.setBaseColor(ClothingState.parseColor("#8045a7"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("weave-dark-purple");
        fabric.setBaseColor(ClothingState.parseColor("#310e48"));
        fabric.setNormalTexture("textures/weave4-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("heavy-weave");
        fabric.setBaseColor(ClothingState.parseColor("#bdaf93"));
        fabric.setNormalTexture("textures/cloth1-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("textile");
        fabric.setBaseColor(ClothingState.parseColor("#bdaf93"));
        fabric.setNormalTexture("textures/heavy-weave-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("green-plaid");
        fabric.setBaseTexture("textures/green-plaid.png");
        fabric.setNormalTexture("textures/heavy-weave-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("red-plaid");
        fabric.setBaseTexture("textures/red-plaid.png");
        fabric.setNormalTexture("textures/heavy-weave-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("blue-plaid");
        fabric.setBaseTexture("textures/blue-plaid.png");
        fabric.setNormalTexture("textures/heavy-weave-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.9);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("leather");
        fabric.setBaseTexture("textures/leather-gradient.jpg");
        fabric.setNormalTexture("textures/leather-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.5);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("dark-leather");
        fabric.setBaseColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        fabric.setBaseTexture("textures/leather-gradient.jpg");
        fabric.setNormalTexture("textures/leather-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.6);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("black-leather");
        fabric.setBaseColor(new ColorRGBA(0.05f, 0.05f, 0.05f, 1.0f));
        fabric.setBaseTexture("textures/leather-gradient.jpg");
        fabric.setNormalTexture("textures/leather-normals.png");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.6);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("rough-leather");
        fabric.setBaseTexture("textures/leather-gradient.jpg");
        fabric.setNormalTexture("textures/ROCK6-norm.jpg");
        fabric.setMetallic(0.0);
        fabric.setRoughness(0.65);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("suede");
        fabric.setBaseTexture("textures/leather-gradient.jpg");
        fabric.setMetallic(0.0);
        fabric.setRoughness(1.0);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("dark-suede");
        fabric.setBaseColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        fabric.setBaseTexture("textures/leather-gradient.jpg");
        fabric.setMetallic(0.0);
        fabric.setRoughness(1.0);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("black-suede");
        fabric.setBaseColor(new ColorRGBA(0.05f, 0.05f, 0.05f, 1.0f));
        fabric.setBaseTexture("textures/leather-gradient.jpg");
        fabric.setMetallic(0.0);
        fabric.setRoughness(1.0);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("steel");
        fabric.setBaseTexture("textures/medium-steel.jpg");
        fabric.setMetallic(1.0);
        fabric.setRoughness(0.3);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("metal");
        fabric.setBaseTexture("textures/metal-base.png");
        fabric.setMetallic(1.0);
        fabric.setRoughness(0.5);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("rusted-metal");
        fabric.setBaseTexture("textures/rust-base.png");
        fabric.setNormalTexture("textures/rust-normals.png");
        fabric.setMetallicRoughnessTexture("textures/rust-mr.png");
        fabric.setMetallic(1.0);
        fabric.setRoughness(1.0);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("chainmail");
        fabric.setBaseTexture("textures/metal-base.png");
        fabric.setNormalTexture("textures/chainmail1024-normals.png");
        fabric.setMetallic(1.0);
        fabric.setRoughness(0.5);
        this.fabricInfos.add((Object)fabric);
        fabric = new FabricInfo("dark-chainmail");
        fabric.setBaseColor(new ColorRGBA(0.25f, 0.25f, 0.25f, 1.0f));
        fabric.setBaseTexture("textures/metal-base.png");
        fabric.setNormalTexture("textures/chainmail1024-normals.png");
        fabric.setMetallic(1.0);
        fabric.setRoughness(0.5);
        this.fabricInfos.add((Object)fabric);
        for (FabricInfo info : this.fabricInfos) {
            this.fabrics.add(new Fabric(info, (AssetManager)this.assetReader.getAssetManager()));
        }
        this.fabricInfos.remove(0);
        this.clothingFormat = new ClothingFormat((List<FabricInfo>)this.fabricInfos, this.shapeIndex);
        this.resetWorkspace();
        File temp = this.currentFile;
        File f = new File("last.clothing");
        if (f.exists()) {
            this.doOpen(f);
        }
        this.currentFile = temp;
        this.resetRig((Rig)this.rigRef.get());
    }

    protected void cleanup(Application app) {
        try {
            this.saveCells(new File("last.clothing"), this.clothingBuilder.getCells());
        }
        catch (IOException e) {
            log.error("Error saving cells", (Throwable)e);
        }
        try {
            ImageUtils.writeImage(new File("test-base.png"), this.clothingPainter.getBaseTexture());
            ImageUtils.writeImage(new File("test-normal.png"), this.clothingPainter.getNormalTexture());
            ImageUtils.writeImage(new File("test-mr.png"), this.clothingPainter.getMetalRoughnessTexture());
        }
        catch (Exception e) {
            log.error("Error writing test images", (Throwable)e);
        }
    }

    protected void onEnable() {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(MainAppFunctions.F_SAVE, (Object)this, "save");
        inputMapper.addDelegate(MainAppFunctions.F_UNDO, (Object)this, "undo");
        inputMapper.addDelegate(MainAppFunctions.F_REDO, (Object)this, "redo");
    }

    protected void onDisable() {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeDelegate(MainAppFunctions.F_SAVE, (Object)this, "save");
        inputMapper.removeDelegate(MainAppFunctions.F_UNDO, (Object)this, "undo");
        inputMapper.removeDelegate(MainAppFunctions.F_REDO, (Object)this, "redo");
    }

    public void update(float tpf) {
        if (this.rigRef.update()) {
            this.resetRig((Rig)this.rigRef.get());
        }
        if (this.selectedTabRef.update()) {
            this.tabChanged((TabbedPanel.Tab)this.selectedTabRef.get());
        }
        if (this.selectedFabricRef.update()) {
            this.setFabric((Integer)this.selectedFabricRef.get());
        }
        if (this.builderRef.update()) {
            this.repaint(false);
        }
        for (Geometry geom : this.geometryList) {
            geom.getMesh().clearCollisionData();
            geom.getMesh().createCollisionData();
        }
    }

    protected void saveCells(File f, CellArray cells) throws IOException {
        this.clothingFormat.writeCells(new FileOutputStream(f), cells);
    }

    protected CellArray readCells(File f) throws IOException {
        return this.clothingFormat.readCells(new FileInputStream(f));
    }

    protected void setFabric(int fabricIndex) {
        if (this.currentFabricIndex == fabricIndex) {
            return;
        }
        this.currentFabricIndex = fabricIndex;
        this.currentFabricInfo = (FabricInfo)this.fabricInfos.get(fabricIndex);
        this.currentFabric = new Fabric(this.currentFabricInfo, (AssetManager)this.assetReader.getAssetManager());
    }

    public void undo() {
        this.history.undo();
        this.repaint(true);
    }

    public void redo() {
        this.history.redo();
        this.repaint(true);
    }

    protected void resetWorkspace() {
        this.clothingBuilder.clear();
        this.history.clear();
        try {
            CellArray cells = this.clothingFormat.readCells(((Object)((Object)this)).getClass().getResourceAsStream("/Clothing/female-underwear1.clothing"));
            this.clothingBuilder.setCells(cells);
        }
        catch (IOException e) {
            log.error("Error reading cells", (Throwable)e);
        }
        this.repaint(true);
    }

    protected void repaint(boolean forceReset) {
        long start = System.nanoTime();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int value;
                if (!forceReset && !this.changedCells[i][j]) continue;
                int bottom = this.clothingBuilder.getValue(i, j, 0);
                if (forceReset || bottom != 0 || this.filledCells[i][j] && bottom == 0) {
                    ImageSource shape = this.shapeIndex.getShapeSource(0);
                    Fabric fabric = this.fabrics.get(0);
                    fabric.paint(this.clothingPainter, i * 32, j * 32, shape);
                }
                this.filledCells[i][j] = bottom != 0;
                this.changedCells[i][j] = false;
                for (int k = 0; k < 32 && (value = this.clothingBuilder.getValue(i, j, k)) != 0; ++k) {
                    ImageSource shape = this.shapeIndex.getShapeSource(ClothingBuilder.toShape(value));
                    Fabric fabric = this.fabrics.get(ClothingBuilder.toFabric(value));
                    fabric.paint(this.clothingPainter, i * 32, j * 32, shape);
                }
            }
        }
        long end = System.nanoTime();
        log.info("repainted in " + (double)(end - start) / 1000000.0 + " ms");
    }

    protected void clickCell(int xCell, int yCell, int x, int y, int buttonIndex) {
        log.info("paintCell(" + xCell + ", " + yCell + ", " + buttonIndex + ")");
        if (xCell > 32 || yCell > 32) {
            return;
        }
        Vec3i shapeCell = this.shapeSelector.getSelectedCell();
        int xShape = 0;
        int yShape = 0;
        if (shapeCell != null) {
            xShape = shapeCell.x;
            yShape = shapeCell.y;
        }
        int index = yShape * 8 + xShape;
        log.info("index:" + index + "  cell:" + shapeCell);
        SwatchShape shape = this.shapeIndex.getBaseShape(index);
        int dirMask = this.dirMaskEditor.getDirMask();
        log.info("dir mask:" + dirMask);
        int constraint = SwatchShape.dirsToMask(shape.getEdges());
        log.info("contraint:" + constraint);
        int variantMask = constraint & dirMask;
        log.info("variantMask:" + variantMask);
        Integer variant = shape.getVariantIndex(variantMask);
        if (variant == null) {
            log.info("No variant 0 found in:" + shape.getVariants());
            variant = 0;
        }
        if (buttonIndex == 1) {
            this.history.addEdit(new AddSwatch(this.clothingBuilder, xCell, yCell, variant, this.currentFabricIndex + 1));
        } else if (buttonIndex == 0) {
            this.history.addEdit(new RemoveSwatch(this.clothingBuilder, xCell, yCell));
        } else if (buttonIndex == 2) {
            this.history.addEdit(new RemoveSwatch(this.clothingBuilder, xCell, yCell));
            this.history.addEdit(new AddSwatch(this.clothingBuilder, xCell, yCell, variant, this.currentFabricIndex + 1));
        }
        this.changedCells[xCell][yCell] = true;
    }

    protected void resetRig(Rig rig) {
        if (rig == null) {
            return;
        }
        this.rig = rig;
        this.rigInfo = rig.getRigInfo();
        TangentBinormalGenerator.generate((Spatial)rig.getView());
        this.geometryList.clear();
        rig.getView().depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                ClothingState.this.geometryList.add(geom);
                if (geom.getMaterial().getParamsMap().containsKey((Object)"BaseColorMap")) {
                    Texture existing = (Texture)geom.getMaterial().getParamValue("BaseColorMap");
                    log.info("Existing base map:" + existing);
                    if (existing == null || "Grid-x.png".equals(existing.getName())) {
                        log.info("Setting up clothing texture.");
                        geom.getMaterial().setTexture("BaseColorMap", ClothingState.this.clothingPainter.getBaseTexture());
                        geom.getMaterial().setTexture("NormalMap", ClothingState.this.clothingPainter.getNormalTexture());
                        geom.getMaterial().setTexture("MetallicRoughnessMap", ClothingState.this.clothingPainter.getMetalRoughnessTexture());
                        geom.getMaterial().setFloat("Metallic", 1.0f);
                        geom.getMaterial().setFloat("Roughness", 1.0f);
                    } else {
                        log.info("Material values:");
                        for (Map.Entry e : geom.getMaterial().getParamsMap().entrySet()) {
                            log.info("    " + e);
                        }
                    }
                }
            }
        });
        this.setFabric(0);
        this.repaint(true);
        this.setClothingEnabled(this.tabEnabled);
    }

    protected void tabChanged(TabbedPanel.Tab tab) {
        boolean bl = this.tabEnabled = this.window == tab.getContents();
        if (this.rig != null) {
            this.setClothingEnabled(this.tabEnabled);
        }
        ((ColliderViewState)this.getState(ColliderViewState.class)).setCollidersEnabled(!this.tabEnabled);
    }

    protected void setClothingEnabled(boolean clothingEnabled) {
        if (this.clothingEnabled == clothingEnabled) {
            return;
        }
        this.clothingEnabled = clothingEnabled;
        if (clothingEnabled) {
            CursorEventControl.addListenersToSpatial((Spatial)this.rig.getView(), (CursorListener[])new CursorListener[]{this.paintListener});
            this.originalAction = this.rig.getCurrentAction();
            if (this.rig.getClipNames().contains("default pose")) {
                this.rig.setCurrentAction("default pose");
            }
        } else {
            CursorEventControl.removeListenersFromSpatial((Spatial)this.rig.getView(), (CursorListener[])new CursorListener[]{this.paintListener});
            if (this.originalAction != null) {
                this.rig.setCurrentAction(this.originalAction);
            }
        }
    }

    private class PaintListener
    extends DefaultCursorListener {
        private CollisionResult collision = null;

        private PaintListener() {
        }

        protected void click(CursorButtonEvent event, Spatial target, Spatial capture) {
            log.info("event:" + event);
            if (this.collision == null) {
                return;
            }
            int ti = this.collision.getTriangleIndex();
            Mesh mesh = this.collision.getGeometry().getMesh();
            Vector3f cp = this.collision.getGeometry().worldToLocal(this.collision.getContactPoint(), null);
            Vector2f bary = MeshUtils.getBarycentricCoord((Mesh)mesh, (int)ti, (Vector3f)cp);
            Vector2f uv = MeshUtils.getTextureCoordinate((Mesh)mesh, (int)ti, (Vector2f)bary);
            int x = Math.round((float)ClothingState.this.clothingPainter.getWidth() * uv.x);
            int y = Math.round((float)ClothingState.this.clothingPainter.getHeight() * uv.y);
            log.info("texture coord:" + uv + "   xy:" + x + ", " + y);
            int xCell = x / 32;
            int yCell = y / 32;
            log.info("cell:" + xCell + ", " + yCell);
            ClothingState.this.clickCell(xCell, yCell, x, y, event.getButtonIndex());
        }

        public void cursorExited(CursorMotionEvent event, Spatial target, Spatial capture) {
            this.collision = null;
        }

        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            this.collision = event.getCollision();
        }
    }
}

