/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.tool.ColliderInfo;
import com.simsilica.tool.EulerRotationEditor;
import com.simsilica.tool.Vec3dEditor;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(ColliderEditor.class);
    private ColliderInfo collider;
    private VersionedList<String> jointNames = new VersionedList();
    private VersionedList<String> shapeNames = new VersionedList();
    private Selector<String> jointField;
    private Selector<String> shapeField;
    private Spinner<Double> scaleField;
    private Vec3dEditor offsetEditor;
    private EulerRotationEditor orientEditor;
    private VersionedReference<String> jointRef;
    private VersionedReference<String> shapeRef;
    private VersionedReference<Double> scaleRef;
    private VersionedReference<Vec3d> offsetRef;
    private VersionedReference<Quatd> orientRef;

    public ColliderEditor() {
        this.jointNames = new VersionedList();
        this.shapeNames = new VersionedList();
        Container props = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        props.addChild((Node)new Label("Joint:"), new Object[0]);
        this.jointField = (Selector)props.addChild((Node)new Selector(this.jointNames), new Object[]{1});
        this.jointRef = this.jointField.createSelectedItemReference();
        props.addChild((Node)new Label("Shape:"), new Object[0]);
        this.shapeField = (Selector)props.addChild((Node)new Selector(this.shapeNames), new Object[]{1});
        this.shapeRef = this.shapeField.createSelectedItemReference();
        props.addChild((Node)new Label("Scale:"), new Object[0]);
        SequenceModel scaleModel = SequenceModels.rangedSequence((RangedValueModel)new DefaultRangedValueModel(0.05, 0.25, 0.1), (double)0.01, (double)0.01);
        this.scaleRef = scaleModel.createReference();
        DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)"%.2f", (String)"error");
        this.scaleField = (Spinner)props.addChild((Node)new Spinner(scaleModel, (ValueRenderer)renderer), new Object[]{1});
        this.scaleField.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)"%.2f"));
        props.addChild((Node)new Label("Offset:"), new Object[0]);
        this.offsetEditor = (Vec3dEditor)props.addChild((Node)new Vec3dEditor(Axis.X, -1.0, 1.0, 0.01, 0.01), new Object[]{1});
        this.offsetRef = this.offsetEditor.createReference();
        props.addChild((Node)new Label("Orient:"), new Object[0]);
        this.orientEditor = (EulerRotationEditor)props.addChild((Node)new EulerRotationEditor(Axis.X), new Object[]{1});
        this.orientRef = this.orientEditor.createReference();
    }

    public void setJointNames(Collection<String> jointNames) {
        this.jointNames.clear();
        this.jointNames.addAll(jointNames);
    }

    public void setShapeNames(Collection<String> shapeNames) {
        this.shapeNames.clear();
        this.shapeNames.addAll(shapeNames);
    }

    public void setCollider(ColliderInfo collider) {
        this.collider = collider;
        this.resetFields();
    }

    public ColliderInfo getCollider() {
        return this.collider;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.jointRef.update()) {
            this.collider.setJoint((String)this.jointRef.get());
        }
        if (this.shapeRef.update()) {
            this.collider.setShape((String)this.shapeRef.get());
        }
        if (this.scaleRef.update()) {
            this.collider.setScale((Double)this.scaleField.getValue());
        }
        if (this.offsetRef.update()) {
            this.collider.setOffset((Vec3d)this.offsetRef.get());
        }
        if (this.orientRef.update()) {
            this.collider.setOrientation((Quatd)this.orientRef.get());
        }
    }

    protected void resetFields() {
        if (this.collider == null) {
            this.jointField.setSelectedItem(null);
            this.shapeField.setSelectedItem(null);
            this.offsetEditor.setObject(new Vec3d());
            this.orientEditor.setObject(new Quatd());
        } else {
            this.jointField.setSelectedItem((Object)this.collider.getJoint());
            this.shapeField.setSelectedItem((Object)this.collider.getShape());
            this.scaleField.getModel().setObject((Object)this.collider.getScale());
            this.offsetEditor.setObject(this.collider.getOffset());
            this.orientEditor.setObject(this.collider.getOrientation());
        }
    }
}

