/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.tool.ColliderShapes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderInfo
implements VersionedObject<ColliderInfo> {
    static Logger log = LoggerFactory.getLogger(ColliderInfo.class);
    private transient long version;
    private String shape;
    private double scale = 0.1;
    private String joint;
    private Vec3d offset = new Vec3d();
    private Quatd orientation = new Quatd();

    public com.simsilica.crig.ColliderInfo convert(ColliderShapes shapes) {
        com.simsilica.crig.ColliderInfo result = new com.simsilica.crig.ColliderInfo();
        result.setShape(shapes.getCells(this.shape));
        result.setScale(this.scale);
        result.setJoint(this.joint);
        result.setOffset(this.offset);
        result.setOrientation(this.orientation);
        return result;
    }

    public long getVersion() {
        return this.version;
    }

    public ColliderInfo getObject() {
        return this;
    }

    public VersionedReference<ColliderInfo> createReference() {
        return new VersionedReference((VersionedObject)this);
    }

    public void setShape(String shape) {
        this.shape = shape;
        ++this.version;
    }

    public String getShape() {
        return this.shape;
    }

    public void setScale(double scale) {
        this.scale = scale;
        ++this.version;
    }

    public double getScale() {
        return this.scale;
    }

    public void setJoint(String joint) {
        this.joint = joint;
        ++this.version;
    }

    public String getJoint() {
        return this.joint;
    }

    public void setOffset(Vec3d offset) {
        this.offset.set(offset);
        ++this.version;
    }

    public Vec3d getOffset() {
        return this.offset;
    }

    public void setOrientation(Quatd orientation) {
        this.orientation.set(orientation);
        ++this.version;
    }

    public Quatd getOrientation() {
        return this.orientation;
    }

    public String toString() {
        return "ColliderInfo[" + this.joint + ":" + this.shape + "]";
    }
}

