/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.google.common.collect.Iterables;
import com.jme3.scene.Node;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GridPanel;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.tool.ColliderEditor;
import com.simsilica.tool.ColliderInfo;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderManager
extends Container {
    static Logger log = LoggerFactory.getLogger(ColliderManager.class);
    private Rig rig;
    private RigInfo rigInfo;
    private VersionedReference<ColliderInfo> selectedColliderRef;
    private ListBox<ColliderInfo> colliderList = (ListBox)this.addChild((Node)new ListBox(), new Object[0]);
    private VersionedReference<Integer> listSelectionRef = this.colliderList.getSelectionModel().createSelectionReference();
    private Container editorHolder;
    private ColliderEditor colliderEditor;
    private VersionedReference<ColliderInfo> attRef;

    public ColliderManager() {
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("New", (Object)this, "addCollider")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Remove", (Object)this, "removeCollider")), new Object[0]);
        this.editorHolder = (Container)this.addChild((Node)new Container(), new Object[0]);
        this.editorHolder.setBackground(null);
        this.colliderEditor = new ColliderEditor();
    }

    public void setRig(Rig rig) {
        if (this.rig == rig) {
            return;
        }
        this.rig = rig;
        if (rig == null) {
            this.rigInfo = null;
            this.selectedColliderRef = null;
            this.colliderList.setModel(new VersionedList());
            this.colliderEditor.setCollider(null);
        } else {
            this.rigInfo = rig.getRigInfo();
            this.colliderList.setModel(this.rigInfo.getColliders());
            this.colliderEditor.setJointNames(rig.getJointNames());
            this.colliderEditor.setShapeNames(rig.getColliders().getShapeNames());
            this.selectedColliderRef = rig.createSelectedColliderReference();
        }
    }

    public Rig getRig() {
        return this.rig;
    }

    protected void addCollider() {
        int index = this.rigInfo.getColliders().size();
        ColliderInfo item = new ColliderInfo();
        item.setShape("sphere");
        item.setJoint((String)Iterables.getFirst(this.rig.getJointNames(), null));
        this.rigInfo.getColliders().add((Object)item);
        this.colliderList.getSelectionModel().setSelection(Integer.valueOf(index));
    }

    protected void removeCollider() {
        this.rigInfo.getColliders().remove(this.colliderList.getSelectedItem());
    }

    protected void selectCollider() {
        ColliderInfo item = (ColliderInfo)this.colliderList.getSelectedItem();
        this.rig.setSelectedCollider(item);
        this.attRef = item == null ? null : item.createReference();
    }

    protected void editCollider() {
        ColliderInfo item = (ColliderInfo)this.selectedColliderRef.get();
        log.info("editCollider():" + item);
        int index = this.rigInfo.getColliders().indexOf((Object)item);
        Integer selection = this.colliderList.getSelectionModel().getSelection();
        selection = selection == null ? -1 : selection;
        if (selection != index) {
            this.colliderList.getSelectionModel().setSelection(Integer.valueOf(index));
        }
        this.colliderEditor.setCollider(item);
        if (item == null) {
            this.colliderEditor.removeFromParent();
        } else {
            this.editorHolder.addChild((Node)this.colliderEditor, new Object[0]);
        }
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.listSelectionRef.update()) {
            this.selectCollider();
        }
        if (this.selectedColliderRef != null && this.selectedColliderRef.update()) {
            this.editCollider();
        }
        if (this.attRef != null && this.attRef.update()) {
            log.info("refresh list");
            GridPanel grid = this.colliderList.getGridPanel();
            grid.setVisibleRows(grid.getVisibleRows());
        }
    }
}

