/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.config.DefaultBlockSet;
import com.simsilica.mblock.phys.CellArrayPart;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderShapes {
    static Logger log = LoggerFactory.getLogger(ColliderShapes.class);
    private Map<String, CellArray> blocks = new LinkedHashMap<String, CellArray>();

    public ColliderShapes() {
        if (!BlockTypeIndex.isInitialized()) {
            DefaultBlockSet.initializeBlockTypes();
        }
        this.blocks.put("sphere", null);
        this.blocks.put("cube", ColliderShapes.cells(1, 1, 1, 1));
        this.blocks.put("block-1x2x1", ColliderShapes.cells(1, 2, 1, 1));
        this.blocks.put("block-1x3x1", ColliderShapes.cells(1, 3, 1, 1));
        this.blocks.put("block-1x4x1", ColliderShapes.cells(1, 4, 1, 1));
        this.blocks.put("block-2x2x1", ColliderShapes.cells(2, 2, 1, 1));
        this.blocks.put("block-2x3x1", ColliderShapes.cells(2, 3, 1, 1));
        this.blocks.put("block-2x4x1", ColliderShapes.cells(2, 4, 1, 1));
    }

    public Set<String> getShapeNames() {
        return this.blocks.keySet();
    }

    public CellArray getCells(String name) {
        return this.blocks.get(name);
    }

    public CellArrayPart createShape(String name, double scale, double mass) {
        CellArray array = this.blocks.get(name);
        if (array == null) {
            return CellArrayPart.createSphere((String)name, (double)scale, (double)mass);
        }
        return CellArrayPart.createShape((String)name, (CellArray)array, (double)scale, (double)mass);
    }

    private static CellArray cells(int x, int y, int z, int value) {
        CellArray array = new CellArray(x, y, z);
        array.clear(value);
        MaskUtils.calculateSideMasks((CellArray)array);
        return array;
    }
}

