/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Part;
import com.simsilica.tool.ColliderInfo;
import com.simsilica.tool.GeomUtils;
import com.simsilica.tool.PartUtils;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigViewState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ColliderViewState.class);
    private VersionedReference<Rig> rigRef;
    private Rig rig;
    private VersionedReference<List<ColliderInfo>> collidersRef;
    private VersionedReference<ColliderInfo> selectedRef;
    private VersionedReference<ColliderInfo> colliderRef;
    private Node selectionCursor;
    private Map<ColliderInfo, View> viewIndex = new HashMap<ColliderInfo, View>();
    private SafeArrayList<View> views = new SafeArrayList(View.class);
    private View selectedView;
    private boolean collidersEnabled = true;

    public void setCollidersEnabled(boolean enabled) {
        if (this.collidersEnabled == enabled) {
            return;
        }
        this.collidersEnabled = enabled;
        this.resetCollidersEnabled();
    }

    protected void resetCollidersEnabled() {
        for (View view : (View[])this.views.getArray()) {
            view.setEnabled(this.collidersEnabled);
        }
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void setRig(Rig rig) {
        if (this.rig == rig) {
            return;
        }
        this.rig = rig;
        this.viewIndex.clear();
        for (View view : this.views) {
            view.release();
        }
        this.views.clear();
        if (rig != null) {
            this.collidersRef = rig.getRigInfo().getColliders().createReference();
            this.selectedRef = rig.createSelectedColliderReference();
            this.updateViews((List)this.collidersRef.get());
            this.updateSelection((ColliderInfo)this.selectedRef.get());
            this.updateCursor();
            this.resetCollidersEnabled();
        } else {
            this.collidersRef = null;
            this.selectedRef = null;
            this.updateSelection(null);
            this.updateCursor();
        }
    }

    protected void initialize(Application app) {
        this.selectionCursor = new Node("selectedCollider");
        ColorRGBA[] colors = new ColorRGBA[]{ColorRGBA.Red, ColorRGBA.Green, ColorRGBA.Blue};
        float size = 0.25f;
        Geometry opaque = GeomUtils.createAxis((float)size, (ColorRGBA)colors[0], (ColorRGBA)colors[1], (ColorRGBA)colors[2]);
        this.selectionCursor.attachChild((Spatial)opaque);
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colors[i].clone();
            colors[i].a = 0.3f;
        }
        Geometry alpha = GeomUtils.createAxis((float)size, (ColorRGBA)colors[0], (ColorRGBA)colors[1], (ColorRGBA)colors[2]);
        alpha.setQueueBucket(RenderQueue.Bucket.Translucent);
        alpha.getMaterial().getAdditionalRenderState().setDepthTest(false);
        alpha.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.selectionCursor.attachChild((Spatial)alpha);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.rigRef = ((RigViewState)this.getState(RigViewState.class, true)).createRigReference();
        this.setRig((Rig)this.rigRef.get());
    }

    protected void onDisable() {
        this.rigRef = null;
        this.setRig(null);
    }

    public void update(float tpf) {
        if (this.rigRef.update()) {
            this.setRig((Rig)this.rigRef.get());
        }
        if (this.rig == null) {
            return;
        }
        if (this.collidersRef.update()) {
            this.updateViews((List)this.collidersRef.get());
        }
        if (this.selectedRef.update()) {
            this.updateSelection((ColliderInfo)this.selectedRef.get());
        }
        if (this.colliderRef != null && this.colliderRef.update()) {
            this.updateCursor();
        }
        for (View view : (View[])this.views.getArray()) {
            view.update();
        }
    }

    protected void updateSelection(ColliderInfo collider) {
        log.info("updateSelection(" + collider + ")");
        if (collider == null) {
            this.colliderRef = null;
            return;
        }
        this.colliderRef = collider.createReference();
        this.updateCursor();
    }

    protected void updateCursor() {
        if (this.selectedView != null) {
            this.selectedView.setColor(ColorRGBA.Gray);
        }
        if (this.colliderRef == null) {
            this.selectionCursor.removeFromParent();
            return;
        }
        ColliderInfo collider = (ColliderInfo)this.colliderRef.get();
        Node node = this.rig.getAttachmentNode(collider.getJoint());
        if (node == null) {
            this.selectionCursor.removeFromParent();
            return;
        }
        node.attachChild((Spatial)this.selectionCursor);
        this.selectionCursor.setLocalTranslation(collider.getOffset().toVector3f());
        this.selectionCursor.setLocalRotation(collider.getOrientation().toQuaternion());
        this.selectedView = this.viewIndex.get(collider);
        if (this.selectedView != null) {
            this.selectedView.setColor(ColorRGBA.Yellow);
        }
    }

    protected void updateViews(List<ColliderInfo> list) {
        View view;
        HashSet<ColliderInfo> toRemove = new HashSet<ColliderInfo>(this.viewIndex.keySet());
        for (ColliderInfo info : list) {
            toRemove.remove(info);
            view = this.viewIndex.get(info);
            if (view != null) continue;
            view = new View(info);
            this.viewIndex.put(info, view);
            this.views.add((Object)view);
        }
        for (ColliderInfo remove : toRemove) {
            view = this.viewIndex.remove(remove);
            if (view == null) continue;
            view.release();
            this.views.remove((Object)view);
        }
    }

    protected Geometry createDebugView(Part part) {
        return PartUtils.createWire((CellArrayPart)part);
    }

    private class View {
        ColliderInfo info;
        VersionedReference<ColliderInfo> infoRef;
        Node holder;
        Vector3f rescale = new Vector3f(1.0f, 1.0f, 1.0f);
        String joint;
        String shape;
        double scale;
        Part part;
        boolean enabled = true;
        Geometry geom1;
        Geometry geom2;
        ColorRGBA color = ColorRGBA.Gray;

        public View(ColliderInfo info) {
            this.info = info;
            this.infoRef = info.createReference();
            this.holder = new Node("colliderHolder");
            this.updateShape();
            this.updateJoint();
        }

        public void setEnabled(boolean enabled) {
            if (this.enabled == enabled) {
                return;
            }
            this.enabled = enabled;
            if (enabled) {
                this.holder.attachChild((Spatial)this.geom1);
                this.holder.attachChild((Spatial)this.geom2);
            } else {
                this.geom1.removeFromParent();
                this.geom2.removeFromParent();
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setColor(ColorRGBA color) {
            if (Objects.equals(this.color, color)) {
                return;
            }
            this.color = color;
            this.geom2.getMaterial().setColor("Color", color);
            ColorRGBA trans = color.clone();
            trans.a = 0.25f;
            this.geom1.getMaterial().setColor("Color", trans);
        }

        protected void updateShape() {
            if (Objects.equals(this.shape, this.info.getShape()) && this.info.getScale() == this.scale) {
                return;
            }
            this.shape = this.info.getShape();
            this.scale = this.info.getScale();
            this.part = ColliderViewState.this.rig.getColliders().createShape(this.shape, this.scale, 0.1);
            if (this.geom1 != null) {
                this.geom1.removeFromParent();
                this.geom2.removeFromParent();
            }
            this.geom1 = ColliderViewState.this.createDebugView(this.part);
            this.geom2 = this.geom1.clone(true);
            this.geom2.getMaterial().setColor("Color", this.color);
            if (this.enabled) {
                this.holder.attachChild((Spatial)this.geom1);
                this.holder.attachChild((Spatial)this.geom2);
            }
            this.geom1.setQueueBucket(RenderQueue.Bucket.Translucent);
            this.geom1.getMaterial().getAdditionalRenderState().setDepthTest(false);
            this.geom1.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
            ColorRGBA trans = this.color.clone();
            trans.a = 0.25f;
            this.geom1.getMaterial().setColor("Color", trans);
        }

        protected void updateJoint() {
            if (!Objects.equals(this.joint, this.info.getJoint())) {
                this.joint = this.info.getJoint();
                Node node = ColliderViewState.this.rig.getAttachmentNode(this.joint);
                node.attachChild((Spatial)this.holder);
                this.rescale = node.getWorldScale().clone();
                this.rescale.x = 1.0f / this.rescale.x;
                this.rescale.y = 1.0f / this.rescale.y;
                this.rescale.z = 1.0f / this.rescale.z;
                this.holder.setLocalScale(this.rescale);
            }
            this.holder.setLocalTranslation(this.info.getOffset().toVector3f().multLocal(this.rescale));
            this.holder.setLocalRotation(this.info.getOrientation().toQuaternion());
        }

        public void update() {
            if (this.infoRef.update()) {
                this.updateShape();
                this.updateJoint();
            }
        }

        public void release() {
            this.holder.removeFromParent();
        }
    }
}

