/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.simsilica.tool.Edit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeEdit
implements Edit {
    static Logger log = LoggerFactory.getLogger(CompositeEdit.class);
    private List<Edit> edits = new ArrayList<Edit>();

    public void addEdit(Edit edit) {
        this.edits.add(edit);
    }

    @Override
    public String toDisplay() {
        return this.edits.size() + " edits";
    }

    @Override
    public void doEdit() {
        for (Edit e : this.edits) {
            e.doEdit();
        }
    }

    @Override
    public void undoEdit() {
        for (int i = this.edits.size() - 1; i >= 0; --i) {
            Edit e = this.edits.get(i);
            e.undoEdit();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.toDisplay() + "]";
    }
}

