/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.scene.Node;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.mblock.CellArray;
import com.simsilica.tool.AddSwatch;
import com.simsilica.tool.ClothingBuilder;
import com.simsilica.tool.ClothingState;
import com.simsilica.tool.CompositeEdit;
import com.simsilica.tool.EditHistory;
import com.simsilica.tool.FabricInfo;
import com.simsilica.tool.RiggerConfig;
import com.simsilica.tool.io.ClothingFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateClothingDialog
extends Container {
    static Logger log = LoggerFactory.getLogger(CreateClothingDialog.class);
    private ClothingState parent;
    private List<FabricInfo> fabrics;
    private ClothingBuilder target;
    private EditHistory history;
    private ClothingFormat clothingFormat;
    private Selector<File> templateSelector;
    private Selector<FabricInfo> fabricSelector;

    public CreateClothingDialog(ClothingState parent, ClothingBuilder target, EditHistory history, VersionedList<FabricInfo> fabrics, ClothingFormat clothingFormat) {
        this.parent = parent;
        this.target = target;
        this.history = history;
        this.fabrics = fabrics;
        this.clothingFormat = clothingFormat;
        this.addChild((Node)new Label("Create Clothing", new ElementId("window.title"), null), new Object[0]);
        Container properties = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Last, FillMode.Last)), new Object[0]);
        properties.addChild((Node)new Label("Template:"), new Object[0]);
        this.templateSelector = (Selector)properties.addChild((Node)new Selector(new VersionedList(CreateClothingDialog.findTemplates())), new Object[]{1});
        properties.addChild((Node)new Label("Fabric:"), new Object[0]);
        this.fabricSelector = (Selector)properties.addChild((Node)new Selector(fabrics), new Object[]{1});
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "create")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "cancel")), new Object[0]);
    }

    protected void create() {
        File f = (File)this.templateSelector.getSelectedItem();
        if (f == null) {
            return;
        }
        try {
            CellArray cells = this.clothingFormat.readCells(new FileInputStream(f));
            log.info("Loaded:" + cells);
            int replace = this.fabricSelector.getSelectionModel().getSelection() + 1;
            CompositeEdit edit = new CompositeEdit();
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    int value;
                    for (int k = 0; k < 32 && (value = cells.getCell(i, j, k)) != 0; ++k) {
                        int shape = ClothingBuilder.toShape(value);
                        int fabric = ClothingBuilder.toFabric(value);
                        edit.addEdit(new AddSwatch(this.target, i, j, shape, replace));
                    }
                }
            }
            this.history.addEdit(edit);
            this.parent.repaint(true);
            this.removeFromParent();
        }
        catch (IOException e) {
            String msg = "Error loading:" + f;
            log.error(msg, (Throwable)e);
        }
    }

    public void cancel() {
        this.removeFromParent();
    }

    public static List<File> findTemplates() {
        File root = RiggerConfig.getInstance().getProjectDir();
        root = new File(root, "templates");
        ArrayList<File> results = new ArrayList<File>();
        for (File f : root.listFiles()) {
            if (f.isDirectory() || !f.getName().endsWith(".clothing")) continue;
            results.add(f);
        }
        return results;
    }
}

