/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ImageRaster;
import com.simsilica.tool.ClothingPainter;
import com.simsilica.tool.FabricInfo;
import com.simsilica.tool.ImageSource;
import com.simsilica.tool.ImageSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fabric {
    static Logger log = LoggerFactory.getLogger(Fabric.class);
    private static final ColorRGBA DEFAULT_NORMAL = new ColorRGBA(0.5f, 0.5f, 1.0f, 1.0f);
    private FabricInfo info;
    private ImageSource baseSource;
    private ImageSource normalSource;
    private ImageSource metalRoughSource;

    public Fabric(FabricInfo info, AssetManager assets) {
        this.baseSource = Fabric.loadTexture(assets, info.getBaseTexture(), info.getBaseColor(), null);
        this.normalSource = Fabric.loadTexture(assets, info.getNormalTexture(), new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f), DEFAULT_NORMAL);
        ColorRGBA metalRough = new ColorRGBA(0.0f, (float)info.getRoughness(), (float)info.getMetallic(), 1.0f);
        this.metalRoughSource = Fabric.loadTexture(assets, info.getMetallicRoughnessTexture(), metalRough, null);
    }

    protected static ImageSource loadTexture(AssetManager assets, String texture, ColorRGBA mult, ColorRGBA fallback) {
        if (texture != null) {
            Texture t = assets.loadTexture(new TextureKey(texture, false));
            if (mult != null) {
                return ImageSources.mult(ImageSources.texture(t), mult);
            }
            return ImageSources.texture(t);
        }
        if (fallback != null) {
            if (mult != null) {
                return ImageSources.color(fallback.mult(mult));
            }
            return ImageSources.color(fallback);
        }
        return ImageSources.color(mult);
    }

    public FabricInfo getInfo() {
        return this.info;
    }

    protected int clamp(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    protected ColorRGBA combineNormals(ColorRGBA base, ColorRGBA detail) {
        Vector3f result = new Vector3f(base.r * 2.0f - 1.0f, base.g * 2.0f - 1.0f, base.b * 2.0f - 1.0f);
        result.x += detail.r * 2.0f - 1.0f;
        result.y += detail.g * 2.0f - 1.0f;
        result.normalizeLocal();
        return new ColorRGBA((result.x + 1.0f) * 0.5f, (result.y + 1.0f) * 0.5f, (result.z + 1.0f) * 0.5f, base.a);
    }

    public void paint(ClothingPainter target, int x, int y, ImageSource shape) {
        ColorRGBA mask = new ColorRGBA();
        ColorRGBA base = new ColorRGBA();
        ColorRGBA normal = new ColorRGBA();
        ColorRGBA metalRough = new ColorRGBA();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int u = x + i;
                int v = y + j;
                mask = shape.getPixel(i, 31 - j, mask);
                if (mask.a == 0.0f) continue;
                base = this.baseSource.getPixel(u, v, base);
                normal = this.normalSource.getPixel(u, v, normal);
                base.a = base.a * mask.a * normal.a;
                metalRough = this.metalRoughSource.getPixel(u, v, metalRough);
                metalRough.a = base.a;
                normal = this.combineNormals(mask, normal);
                target.paint(u, v, base, normal, metalRough);
            }
        }
    }

    public void paint(ImageRaster baseTarget, ImageRaster normalTarget, ImageRaster metalRoughTarget, int x, int y, ImageSource shape) {
        ColorRGBA mask = new ColorRGBA();
        ColorRGBA base = new ColorRGBA();
        ColorRGBA normal = new ColorRGBA();
        ColorRGBA metalRough = new ColorRGBA();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                int u = x + i;
                int v = y + j;
                mask = shape.getPixel(i, 31 - j, mask);
                if (mask.a == 0.0f) continue;
                base = this.baseSource.getPixel(u, v, base);
                normal = this.normalSource.getPixel(u, v, normal);
                metalRough = this.metalRoughSource.getPixel(u, v, metalRough);
                normal = this.combineNormals(mask, normal);
                u = this.clamp(u, 0, baseTarget.getWidth() - 1);
                v = this.clamp(v, 0, baseTarget.getHeight() - 1);
                baseTarget.setPixel(u, v, base);
                normalTarget.setPixel(u, v, normal);
                metalRoughTarget.setPixel(u, v, metalRough);
            }
        }
    }
}

