/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.style.ElementId;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDialog
extends Container {
    static Logger log = LoggerFactory.getLogger(FileDialog.class);
    public static final ElementId BASE_ID = new ElementId("file.dialog");
    private ListBox<String> fileList;
    private String selectedFile;
    private Runnable close;

    public FileDialog(String titleText, List<String> files, String actionName, Runnable close) {
        super(null, true, BASE_ID.child("container"), null);
        this.close = close;
        Label title = (Label)this.addChild((Node)new Label(titleText, BASE_ID.child("title.label")), new Object[0]);
        Vector3f pref = title.getPreferredSize();
        pref.x = Math.max(pref.x, 200.0f);
        title.setPreferredSize(pref);
        this.fileList = (ListBox)this.addChild((Node)new ListBox(new VersionedList(files)), new Object[0]);
        this.fileList.setVisibleItems(10);
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction(actionName, (Object)this, "ok")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Cancel", (Object)this, "cancel")), new Object[0]);
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    protected void ok() {
        this.selectedFile = (String)this.fileList.getSelectedItem();
        this.removeFromParent();
        this.close.run();
    }

    protected void cancel() {
        this.selectedFile = null;
        this.removeFromParent();
        this.close.run();
    }
}

