/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.tool.MainMenuState;
import com.simsilica.tool.RigInfo;
import com.simsilica.tool.RigViewState;
import com.simsilica.tool.RiggerConfig;
import com.simsilica.tool.io.RigInfoJson;
import java.io.File;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMenuState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(FileMenuState.class);
    private Container fileMenu;
    private String fileName;
    private int lastSavedCount;
    private Container fileSaveDialog;
    private TextField fileEntry;
    private Container fileLoadDialog;
    private ListBox<String> files;
    private File rootDir = RiggerConfig.getInstance().getProjectDir();
    private boolean exitOnSave;

    public FileMenuState() {
        if (!this.rootDir.exists()) {
            this.rootDir.mkdirs();
        }
    }

    public Container getMenu() {
        return this.fileMenu;
    }

    protected File toFile(String f) {
        if (f == null) {
            return null;
        }
        if (!f.toLowerCase().endsWith(".rig")) {
            f = f + ".rig";
        }
        File file = new File(this.rootDir, f);
        return file;
    }

    protected String stripExtension(String f) {
        if (f == null) {
            return null;
        }
        if (!f.toLowerCase().endsWith(".rig")) {
            f = f.substring(0, f.length() - 4);
        }
        return f;
    }

    public void open() {
        System.out.println("open()");
        this.selectFile();
    }

    public void save() {
        System.out.println("save()");
        if (this.fileName == null) {
            this.saveAs();
        } else {
            this.saveRig(this.fileName);
        }
    }

    public void saveAs() {
        System.out.println("saveAs()");
        if (this.fileName != null) {
            this.fileEntry.setText(this.fileName);
        }
        Vector3f pref = this.fileSaveDialog.getPreferredSize();
        Vector3f loc = new Vector3f((float)this.getApplication().getCamera().getWidth() * 0.5f, (float)this.getApplication().getCamera().getHeight() * 0.5f, 0.0f);
        loc.x -= pref.x * 0.5f;
        loc.y += pref.y * 0.5f;
        this.fileSaveDialog.setLocalTranslation(loc);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.fileSaveDialog);
    }

    public void exit() {
        this.getApplication().stop();
    }

    protected void cancelExit() {
        this.exitOnSave = false;
    }

    protected void cancelSave() {
        this.exitOnSave = false;
        this.fileSaveDialog.removeFromParent();
    }

    protected void selectFile() {
        System.out.println("selectFile()");
        ArrayList<String> objects = new ArrayList<String>();
        for (String s : this.rootDir.list()) {
            if (!s.toLowerCase().endsWith(".rig")) continue;
            s = s.substring(0, s.length() - ".rig".length());
            objects.add(s);
        }
        this.files.getModel().clear();
        this.files.getModel().addAll(objects);
        this.files.getSelectionModel().clear();
        Vector3f pref = this.fileLoadDialog.getPreferredSize();
        Vector3f loc = new Vector3f((float)this.getApplication().getCamera().getWidth() * 0.5f, (float)this.getApplication().getCamera().getHeight() * 0.5f, 0.0f);
        loc.x -= pref.x * 0.5f;
        loc.y += pref.y * 0.5f;
        this.fileLoadDialog.setLocalTranslation(loc);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.fileLoadDialog);
    }

    protected void saveCurrentFile() {
        System.out.println("Save current file:" + this.fileEntry.getText());
        this.fileSaveDialog.removeFromParent();
        String name = this.fileEntry.getText();
        File file = this.toFile(name);
        if (file.exists()) {
            ((OptionPanelState)this.getState(OptionPanelState.class)).show("Overwrite?", "Really overwrite existing file:" + name + "?", new Action[]{new CallMethodAction("Yes", (Object)this, "saveRig"), new CallMethodAction("No", (Object)this, "saveAs"), new CallMethodAction("Cancel", (Object)this, "cancelExit")});
        } else {
            this.saveRig(name);
        }
    }

    protected void saveRig() {
        this.saveRig(this.fileEntry.getText());
    }

    protected void saveRig(String f) {
        System.out.println("Save rig:" + f);
        this.fileName = f;
        File file = this.toFile(f);
        System.out.println("Write to:" + file);
        try {
            RigInfoJson.store(((RigViewState)this.getState(RigViewState.class)).getRigInfo(), file);
            if (this.exitOnSave) {
                this.exit();
            }
        }
        catch (Exception e) {
            log.error("Error saving file:" + file, (Throwable)e);
            ((OptionPanelState)this.getState(OptionPanelState.class)).showError("Error saving:" + file, (Throwable)e);
        }
    }

    protected void loadSelectedFile() {
        System.out.println("loadSelectedFile()");
        this.fileLoadDialog.removeFromParent();
        Integer selection = this.files.getSelectionModel().getSelection();
        if (selection == null) {
            ((OptionPanelState)this.getState(OptionPanelState.class)).show("Not Loaded", "Object not loaded.  No file was selected.", new Action[0]);
            return;
        }
        String s = (String)this.files.getModel().get(selection.intValue());
        this.loadFile(s);
    }

    protected void loadFile(String s) {
        log.info("loadFile(" + s + ")");
        File file = this.toFile(s);
        try {
            RigInfo info = RigInfoJson.load(file);
            ((RigViewState)this.getState(RigViewState.class)).setRigInfo(info);
            this.lastSavedCount = 0;
            this.fileName = s;
        }
        catch (Exception e) {
            log.error("Error reading file:" + file, (Throwable)e);
            ((OptionPanelState)this.getState(OptionPanelState.class)).showError("Error reading:" + file, (Throwable)e);
        }
    }

    protected void compileBinary() {
        ((RigViewState)this.getState(RigViewState.class)).compileBinary();
    }

    protected void initialize(Application app) {
        this.fileMenu = new Container();
        ((MainMenuState)this.getState(MainMenuState.class)).getTabs().addTab("File", (Panel)this.fileMenu);
        this.fileMenu.addChild((Node)new ActionButton((Action)new CallMethodAction("Open Rig...", (Object)this, "open")), new Object[0]);
        this.fileMenu.addChild((Node)new Container(), new Object[0]);
        this.fileMenu.addChild((Node)new ActionButton((Action)new CallMethodAction("Save Rig", (Object)this, "save")), new Object[0]);
        this.fileMenu.addChild((Node)new ActionButton((Action)new CallMethodAction("Save As Rig...", (Object)this, "saveAs")), new Object[0]);
        this.fileMenu.addChild((Node)new Container(), new Object[0]);
        this.fileMenu.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "compileBinary")), new Object[0]);
        this.fileMenu.addChild((Node)new Container(), new Object[0]);
        this.fileMenu.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "exit")), new Object[0]);
        this.fileSaveDialog = new Container();
        this.fileSaveDialog.addChild((Node)new Label("Save As...", new ElementId("title.label")), new Object[0]);
        this.fileEntry = (TextField)this.fileSaveDialog.addChild((Node)new TextField("MyFile"), new Object[0]);
        Container buttons = (Container)this.fileSaveDialog.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Save", (Object)this, "saveCurrentFile")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Cancel", (Object)this, "cancelSave")), new Object[0]);
        this.fileLoadDialog = new Container();
        Label title = (Label)this.fileLoadDialog.addChild((Node)new Label("Load Object", new ElementId("title.label")), new Object[0]);
        Vector3f pref = title.getPreferredSize();
        pref.x = Math.max(pref.x, 200.0f);
        title.setPreferredSize(pref);
        this.files = (ListBox)this.fileLoadDialog.addChild((Node)new ListBox(), new Object[0]);
        this.files.setVisibleItems(10);
        buttons = (Container)this.fileLoadDialog.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Load", (Object)this, "loadSelectedFile")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Cancel", (Object)this.fileLoadDialog, "removeFromParent")), new Object[0]);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }
}

