/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.google.common.base.Joiner;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.input.KeyNames;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.tool.MainAppFunctions;
import com.simsilica.tool.MainMenuState;
import com.simsilica.tool.OrbitCameraFunctions;
import com.simsilica.tool.Rigger;
import java.util.ArrayList;

public class HelpState
extends BaseAppState {
    private Container helpWindow;
    private boolean movementState = false;
    private KeyHelp[] keyHelp = new KeyHelp[]{new KeyHelp(MainAppFunctions.F_HELP, "Opens this help window."), new KeyHelp(MainAppFunctions.F_SAVE, "Saves the current clothing."), new KeyHelp(MainAppFunctions.F_SAVE_AS, "Opens the save clothing dialog."), new KeyHelp(MainAppFunctions.F_EXIT, "Exits the application"), new KeyHelp(OrbitCameraFunctions.F_YAW, "Rotates left/right."), new KeyHelp(OrbitCameraFunctions.F_PITCH, "Rotates up/down."), new KeyHelp(OrbitCameraFunctions.F_STRAFE, "Moves left/right."), new KeyHelp(OrbitCameraFunctions.F_ELEVATE, "Moves up/down."), new KeyHelp(OrbitCameraFunctions.F_ZOOM, "Moves in/out."), new KeyHelp(MainAppFunctions.F_UNDO, "Undoes the last clothing edit"), new KeyHelp(MainAppFunctions.F_REDO, "Redoes the last clothing edit"), new KeyHelp("PrtScrn", "Takes a screen shot."), new KeyHelp("F5", "Toggles display stats."), new KeyHelp("F6", "Toggles rendering frame timings.")};

    public HelpState() {
        this.setEnabled(false);
    }

    public void close() {
        this.setEnabled(false);
    }

    public void toggleEnabled() {
        this.setEnabled(!this.isEnabled());
    }

    protected void initialize(Application app) {
        Container helpTab = new Container();
        helpTab.addChild((Node)new ActionButton((Action)new CallMethodAction("Key Mappings", (Object)this, "toggleEnabled")), new Object[0]);
        ((MainMenuState)this.getState(MainMenuState.class)).getTabs().addTab("Help", (Panel)helpTab);
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.addDelegate(MainAppFunctions.F_HELP, (Object)this, "toggleEnabled");
        this.helpWindow = new Container();
        Label title = (Label)this.helpWindow.addChild((Node)new Label("Help", new ElementId("title")), new Object[0]);
        title.setInsets(new Insets3f(2.0f, 2.0f, 0.0f, 2.0f));
        Container columns = (Container)this.helpWindow.addChild((Node)new Container(), new Object[0]);
        Container sub = (Container)columns.addChild((Node)new Container(), new Object[0]);
        sub.setInsets(new Insets3f(10.0f, 10.0f, 10.0f, 10.0f));
        sub.addChild((Node)new Label("Key Bindings"), new Object[0]);
        Container keys = (Container)sub.addChild((Node)new Container(), new Object[0]);
        Joiner commas = Joiner.on((String)", ");
        Joiner lines = Joiner.on((String)"\n");
        for (KeyHelp help : this.keyHelp) {
            help.updateKeys(inputMapper);
            String s = commas.join((Object[])help.keyNames);
            keys.addChild((Node)new Label(s, new ElementId("help.key.label")), new Object[0]);
            s = lines.join((Object[])help.description);
            keys.addChild((Node)new Label(s, new ElementId("help.description.label")), new Object[]{1});
        }
        sub = (Container)columns.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.None, FillMode.Last)), new Object[]{1});
        sub.setInsets(new Insets3f(10.0f, 10.0f, 10.0f, 10.0f));
        sub.addChild((Node)new Label("Clothing Tool Mouse Bindings"), new Object[0]);
        Container tools = (Container)sub.addChild((Node)new Container(), new Object[0]);
        tools.addChild((Node)new Label("Left Mouse", new ElementId("help.key.label")), new Object[0]);
        tools.addChild((Node)new Label("Removes swatches.", new ElementId("help.description.label")), new Object[]{1});
        tools.addChild((Node)new Label("Right Mouse", new ElementId("help.key.label")), new Object[0]);
        tools.addChild((Node)new Label("Places swatches.", new ElementId("help.description.label")), new Object[]{1});
        tools.addChild((Node)new Label("Middle Mouse", new ElementId("help.key.label")), new Object[0]);
        tools.addChild((Node)new Label("Replaces swatchess.", new ElementId("help.description.label")), new Object[]{1});
        this.helpWindow.addChild((Node)new ActionButton((Action)new CallMethodAction("Done", (Object)this, "close")), new Object[0]);
        System.out.println("All InputMapper function mappings:");
        for (FunctionId id : inputMapper.getFunctionIds()) {
            System.out.println(id);
            System.out.println("  mappings:");
            for (InputMapper.Mapping m : inputMapper.getMappings(id)) {
                System.out.println("    " + m);
                Object o = m.getPrimaryActivator();
                if (o instanceof Integer) {
                    Integer keyCode = (Integer)o;
                    System.out.println("      primary:" + KeyNames.getName((int)keyCode));
                } else {
                    System.out.println("      primary:" + o);
                }
                for (Object mod : m.getModifiers()) {
                    if (!(mod instanceof Integer)) continue;
                    Integer keyCode = (Integer)mod;
                    System.out.println("      modifier:" + KeyNames.getName((int)keyCode));
                }
            }
        }
    }

    protected void cleanup(Application app) {
        InputMapper inputMapper = GuiGlobals.getInstance().getInputMapper();
        inputMapper.removeDelegate(MainAppFunctions.F_HELP, (Object)this, "toggleEnabled");
    }

    protected void onEnable() {
        Node gui = ((Rigger)this.getApplication()).getGuiNode();
        int width = this.getApplication().getCamera().getWidth();
        int height = this.getApplication().getCamera().getHeight();
        Vector3f pref = this.helpWindow.getPreferredSize();
        this.helpWindow.setLocalTranslation((float)width * 0.5f - pref.x * 0.5f, (float)height * 0.5f + pref.y * 0.5f, 100.0f);
        gui.attachChild((Spatial)this.helpWindow);
        GuiGlobals.getInstance().requestFocus((Spatial)this.helpWindow);
    }

    protected void onDisable() {
        this.helpWindow.removeFromParent();
    }

    private class KeyHelp {
        FunctionId function;
        String[] keyNames;
        String[] description;

        public KeyHelp(FunctionId function, String ... description) {
            this.function = function;
            this.description = description;
        }

        public KeyHelp(String keys, String ... description) {
            this.keyNames = new String[]{keys};
            this.description = description;
        }

        public void updateKeys(InputMapper inputMapper) {
            if (this.function == null) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>();
            for (InputMapper.Mapping m : inputMapper.getMappings(this.function)) {
                Object o = m.getPrimaryActivator();
                if (!(o instanceof Integer)) continue;
                Integer primary = (Integer)o;
                StringBuilder sb = new StringBuilder(KeyNames.getName((int)primary));
                for (Object mod : m.getModifiers()) {
                    if (!(mod instanceof Integer)) continue;
                    sb.append("+");
                    sb.append(KeyNames.getName((int)((Integer)mod)));
                }
                names.add(sb.toString());
            }
            this.keyNames = new String[names.size()];
            this.keyNames = names.toArray(this.keyNames);
        }
    }
}

