/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.math.ColorRGBA;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ImageRaster;
import com.simsilica.tool.ImageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSources {
    static Logger log = LoggerFactory.getLogger(ImageSources.class);

    public static ImageSource<ColorRGBA> color(ColorRGBA color) {
        return new ColorImageSource(color);
    }

    public static ImageSource<Texture> texture(Texture texture) {
        return new TextureImageSource(texture);
    }

    public static ImageSource<ImageRaster> raster(ImageRaster raster) {
        return new RasterImageSource(raster);
    }

    public static ImageSource<ImageSource> subimage(ImageSource source, int x, int y, int width, int height) {
        return new SubimageSource(source, x, y, width, height);
    }

    public static ImageSource<ImageSource> mult(ImageSource source, ColorRGBA mult) {
        return new MultiplySource(source, mult);
    }

    private static class RasterImageSource
    extends AbstractImageSource<ImageRaster> {
        public RasterImageSource(ImageRaster raster) {
            super(raster);
        }

        @Override
        public int getWidth() {
            return ((ImageRaster)this.getSourceData()).getWidth();
        }

        @Override
        public int getHeight() {
            return ((ImageRaster)this.getSourceData()).getHeight();
        }

        @Override
        public ColorRGBA getPixel(int x, int y) {
            return ((ImageRaster)this.getSourceData()).getPixel(x %= ((ImageRaster)this.getSourceData()).getWidth(), y %= ((ImageRaster)this.getSourceData()).getHeight());
        }

        @Override
        public ColorRGBA getPixel(int x, int y, ColorRGBA store) {
            return ((ImageRaster)this.getSourceData()).getPixel(x %= ((ImageRaster)this.getSourceData()).getWidth(), y %= ((ImageRaster)this.getSourceData()).getHeight(), store);
        }
    }

    private static class TextureImageSource
    extends AbstractImageSource<Texture> {
        private ImageRaster raster;

        public TextureImageSource(Texture texture) {
            super(texture);
            this.raster = ImageRaster.create((Image)texture.getImage());
        }

        @Override
        public int getWidth() {
            return this.raster.getWidth();
        }

        @Override
        public int getHeight() {
            return this.raster.getHeight();
        }

        @Override
        public ColorRGBA getPixel(int x, int y) {
            return this.raster.getPixel(x %= this.raster.getWidth(), y %= this.raster.getHeight());
        }

        @Override
        public ColorRGBA getPixel(int x, int y, ColorRGBA store) {
            return this.raster.getPixel(x %= this.raster.getWidth(), y %= this.raster.getHeight(), store);
        }
    }

    private static class ColorImageSource
    extends AbstractImageSource<ColorRGBA> {
        public ColorImageSource(ColorRGBA color) {
            super(color);
        }

        @Override
        public int getWidth() {
            return 1;
        }

        @Override
        public int getHeight() {
            return 1;
        }

        @Override
        public ColorRGBA getPixel(int x, int y) {
            return this.getPixel(x, y, new ColorRGBA());
        }

        @Override
        public ColorRGBA getPixel(int x, int y, ColorRGBA store) {
            if (store == null) {
                store = new ColorRGBA();
            }
            store.set((ColorRGBA)this.getSourceData());
            return store;
        }
    }

    private static class SubimageSource
    extends AbstractImageSource<ImageSource> {
        private int xOrigin;
        private int yOrigin;
        private int width;
        private int height;

        public SubimageSource(ImageSource source, int xOrigin, int yOrigin, int width, int height) {
            super(source);
            this.xOrigin = xOrigin;
            this.yOrigin = yOrigin;
            this.width = width;
            this.height = height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public ColorRGBA getPixel(int x, int y) {
            return ((ImageSource)this.getSourceData()).getPixel(this.xOrigin + (x %= this.width), this.yOrigin + (y %= this.height));
        }

        @Override
        public ColorRGBA getPixel(int x, int y, ColorRGBA store) {
            return ((ImageSource)this.getSourceData()).getPixel(this.xOrigin + (x %= this.width), this.yOrigin + (y %= this.height), store);
        }
    }

    private static class MultiplySource
    extends AbstractImageSource<ImageSource> {
        private ColorRGBA mult;

        public MultiplySource(ImageSource source, ColorRGBA mult) {
            super(source);
            this.mult = mult;
        }

        @Override
        public int getWidth() {
            return ((ImageSource)this.getSourceData()).getWidth();
        }

        @Override
        public int getHeight() {
            return ((ImageSource)this.getSourceData()).getHeight();
        }

        @Override
        public ColorRGBA getPixel(int x, int y) {
            ColorRGBA result = ((ImageSource)this.getSourceData()).getPixel(x, y);
            return result.mult(this.mult);
        }

        @Override
        public ColorRGBA getPixel(int x, int y, ColorRGBA store) {
            ColorRGBA result = ((ImageSource)this.getSourceData()).getPixel(x, y, store);
            return result.mult(this.mult);
        }
    }

    private static abstract class AbstractImageSource<T>
    implements ImageSource<T> {
        private T data;

        public AbstractImageSource(T data) {
            this.data = data;
        }

        @Override
        public final T getSourceData() {
            return this.data;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.data + "]";
        }
    }
}

