/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.math.ColorRGBA;
import com.jme3.system.JmeSystem;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import com.jme3.texture.image.ImageRaster;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.util.BufferUtils;
import com.simsilica.tool.ImageSource;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import jme3tools.converters.ImageToAwt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    static Logger log = LoggerFactory.getLogger(ImageUtils.class);

    public static Image createImage(Image.Format format, int width, int height) {
        int bytes = format.getBitsPerPixel() / 8;
        int size = width * height * bytes;
        ByteBuffer data = BufferUtils.createByteBuffer((int)size);
        return new Image(format, width, height, data, ColorSpace.Linear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(File f, int width, int height, ByteBuffer data) throws IOException {
        try (FileOutputStream out = new FileOutputStream(f);){
            JmeSystem.writeImageFile((OutputStream)out, (String)"png", (ByteBuffer)data, (int)width, (int)height);
        }
    }

    public static void writeImage(File f, Texture texture) throws IOException {
        ImageUtils.writeImage(f, texture.getImage());
    }

    public static void writeImage(File f, Image image) throws IOException {
        BufferedImage bimg = ImageToAwt.convert((Image)image, (boolean)false, (boolean)true, (int)0);
        ImageIO.write((RenderedImage)bimg, "PNG", f);
    }

    public static Image loadImage(File f) {
        if (!f.exists()) {
            return null;
        }
        try {
            BufferedImage bimg = ImageIO.read(f);
            return new AWTLoader().load(bimg, false);
        }
        catch (IOException e) {
            log.error("Error reading:" + f, (Throwable)e);
            return null;
        }
    }

    public static void paint(ImageSource source, ImageRaster target, int x, int y) {
        for (int i = 0; i < source.getWidth(); ++i) {
            for (int j = 0; j < source.getHeight(); ++j) {
                ColorRGBA pixel = source.getPixel(i, j);
                target.setPixel(x + i, y + j, pixel);
            }
        }
    }

    public static void copy(ImageRaster source, ImageRaster target, int skip, boolean average) {
        for (int i = 0; i < target.getWidth(); ++i) {
            for (int j = 0; j < target.getHeight(); ++j) {
                ColorRGBA pixel;
                if (average) {
                    pixel = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
                    int count = 0;
                    for (int x = 0; x < skip; ++x) {
                        for (int y = 0; y < skip; ++y) {
                            pixel.addLocal(source.getPixel(i * skip + x, j * skip + y));
                            ++count;
                        }
                    }
                    pixel.multLocal(1.0f / (float)count);
                } else {
                    pixel = source.getPixel(i * skip, j * skip);
                }
                target.setPixel(i, j, pixel);
            }
        }
    }

    public static void fillRaster(ImageRaster raster, ColorRGBA value) {
        int width = raster.getWidth();
        int height = raster.getHeight();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < width; ++j) {
                raster.setPixel(i, j, value);
            }
        }
    }

    public static void box(ImageRaster out, int x, int y, int size, ColorRGBA color) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                out.setPixel(x + i, j + y, color);
            }
        }
    }

    public static void makeTestImage() {
        int width = 512;
        int size = width * width * 4;
        ByteBuffer data = BufferUtils.createByteBuffer((int)size);
        Image image = new Image(Image.Format.RGBA8, width, width, data, ColorSpace.Linear);
        ImageRaster raster = ImageRaster.create((Image)image);
        ColorRGBA on = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        ColorRGBA off = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f);
        int b = 8;
        for (int i = 0; i < 256; ++i) {
            int xCell = i % 16;
            int yCell = i / 16;
            int x = xCell * 32;
            int y = yCell * 32;
            ImageUtils.box(raster, x, y, 32, on);
            ImageUtils.box(raster, x + 1, y + 1, 30, off);
            ImageUtils.box(raster, x + 2 + b, y + 2 + b, b - 1, on);
            if ((i & 1) != 0) {
                ImageUtils.box(raster, x + 2, y + 2, b - 1, on);
            }
            if ((i & 2) != 0) {
                ImageUtils.box(raster, x + 2 + b, y + 2, b - 1, on);
            }
            if ((i & 4) != 0) {
                ImageUtils.box(raster, x + 2 + b + b, y + 2, b - 1, on);
            }
            if ((i & 8) != 0) {
                ImageUtils.box(raster, x + 2, y + 2 + b, b - 1, on);
            }
            if ((i & 0x10) != 0) {
                ImageUtils.box(raster, x + 2 + b + b, y + 2 + b, b - 1, on);
            }
            if ((i & 0x20) != 0) {
                ImageUtils.box(raster, x + 2, y + 2 + b + b, b - 1, on);
            }
            if ((i & 0x40) != 0) {
                ImageUtils.box(raster, x + 2 + b, y + 2 + b + b, b - 1, on);
            }
            if ((i & 0x80) == 0) continue;
            ImageUtils.box(raster, x + 2 + b + b, y + 2 + b + b, b - 1, on);
        }
        try {
            data.rewind();
            ImageUtils.writeImage(new File("shape-index.png"), width, width, data);
        }
        catch (IOException e) {
            log.error("Error writing shape index", (Throwable)e);
        }
    }
}

