/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.jme.AnimComposerRig;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.RollupPanel;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.TabbedPanel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import com.simsilica.tool.GridState;
import com.simsilica.tool.Movement;
import com.simsilica.tool.MovementAnimation;
import com.simsilica.tool.MovementMode;
import com.simsilica.tool.MovementModeEditor;
import com.simsilica.tool.PhysicsState;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigInfo;
import com.simsilica.tool.RigViewState;
import com.simsilica.tool.ToolState;
import com.simsilica.tool.Vec3dEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobilityState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MobilityState.class);
    private VersionedReference<Rig> rigRef;
    private Rig rig;
    private RigInfo rigInfo;
    private Container window;
    private VersionedReference<TabbedPanel.Tab> tabRef;
    private VersionedReference<Boolean> collidersOpen;
    private VersionedList<String> clipNames = new VersionedList();
    private Selector<MovementMode> modeSelector;
    private VersionedReference<MovementMode> selectedModeRef;
    private MovementModeEditor modeEditor;
    private MovementAnimation movementAnim;
    private PhysicsState physics;
    private boolean tabVisible = false;
    private VersionedHolder<Vec3d> position = new VersionedHolder((Object)new Vec3d(5.0, 0.0, 5.0));
    private Movement movement = new Movement();
    private Vec3dEditor velocityEditor;
    private VersionedReference<Vec3d> velocityRef;
    private Quad grid;
    private Node modelRoot;
    private CharacterRig cRig;

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void initialize(Application app) {
        this.rigRef = ((RigViewState)this.getState(RigViewState.class, true)).createRigReference();
        this.physics = (PhysicsState)this.getState(PhysicsState.class, true);
        this.modelRoot = this.physics.getModelRoot();
        this.window = new Container();
        ((ToolState)this.getState(ToolState.class)).getTabs().addTab("Movement", (Panel)this.window);
        this.tabRef = ((ToolState)this.getState(ToolState.class)).getTabs().getSelectionModel().createReference();
        Container panel = new Container();
        this.window.addChild((Node)new RollupPanel("Animation", (Panel)panel, null), new Object[0]);
        Container properties = (Container)panel.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        properties.addChild((Node)new Label("Mode:"), new Object[0]);
        this.modeSelector = (Selector)properties.addChild((Node)new Selector(), new Object[]{1});
        this.selectedModeRef = this.modeSelector.createSelectedItemReference();
        this.modeEditor = (MovementModeEditor)panel.addChild((Node)new MovementModeEditor(), new Object[0]);
        this.modeEditor.setClipNames(this.clipNames);
        Container movementPanel = new Container();
        RollupPanel movementRollup = (RollupPanel)this.window.addChild((Node)new RollupPanel("Simulated Movement", (Panel)movementPanel, null), new Object[0]);
        movementPanel.addChild((Node)new Label("Velocity:"), new Object[0]);
        this.velocityEditor = (Vec3dEditor)movementPanel.addChild((Node)new Vec3dEditor(Axis.X, -10.0, 10.0, 0.1, 0.01), new Object[0]);
        this.velocityRef = this.velocityEditor.createReference();
        this.resetRig((Rig)this.rigRef.get());
        this.grid = ((GridState)this.getState(GridState.class, true)).getQuad();
    }

    protected void resetRig(Rig rig) {
        if (rig == null) {
            return;
        }
        this.rig = rig;
        this.rigInfo = rig.getRigInfo();
        this.clipNames.clear();
        this.clipNames.addAll(rig.getClipNames());
        this.modeSelector.setModel(this.rigInfo.getMovementModes());
    }

    protected void tabVisible() {
        this.tabVisible = true;
        this.physics.setMovementMode((MovementMode)this.selectedModeRef.get());
        this.cRig = AnimComposerRig.createRig((Spatial)this.rig.getView());
        this.physics.setRig(this.rig);
        this.physics.setEnabled(true);
        this.getRoot().attachChild((Spatial)this.modelRoot);
    }

    protected void tabInvisible() {
        if (this.cRig != null) {
            ((AnimComposerRig)this.cRig).release();
            this.modelRoot.removeFromParent();
        }
        this.physics.setEnabled(false);
        this.tabVisible = false;
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    public void update(float tpf) {
        if (this.rigRef.update()) {
            this.resetRig((Rig)this.rigRef.get());
        }
        if (this.tabRef.update()) {
            if (this.tabRef.get() != null && ((TabbedPanel.Tab)this.tabRef.get()).getContents() == this.window) {
                this.tabVisible();
            } else {
                this.tabInvisible();
            }
        }
        if (this.selectedModeRef.update()) {
            this.modeEditor.setMovementMode((MovementMode)this.selectedModeRef.get());
            this.physics.setMovementMode((MovementMode)this.selectedModeRef.get());
        }
        if (this.velocityRef.update()) {
            this.movement.setVelocity((Vec3d)this.velocityRef.get());
        }
        if (this.tabVisible) {
            this.integrate(tpf);
        }
    }

    protected void onDisable() {
    }

    protected void integrate(double tpf) {
        this.cRig.setLayerAction(null, this.physics.getCurrentAction());
        this.cRig.setTime(null, this.physics.getCurrentTime());
        Vec3d pos = this.physics.getRigPosition();
        this.physics.setRigVelocity(this.movement.getVelocity());
        float u = (float)(1.0 + pos.x / 10.0);
        float v = (float)(2.0 - pos.z / 10.0);
        this.grid.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{u, v, u + 1.0f, v, u + 1.0f, v + 1.0f, u, v + 1.0f});
    }
}

