/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.bounding.BoundingBox;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigInfo;
import com.simsilica.tool.RigViewState;
import com.simsilica.tool.SourceModelInfo;
import com.simsilica.tool.TargetModelInfo;
import com.simsilica.tool.ToolState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelInfoState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ModelInfoState.class);
    private VersionedReference<Rig> rigRef;
    private VersionedReference<SourceModelInfo> modelRef;
    private VersionedReference<TargetModelInfo> targetModelRef;
    private Rig rig;
    private RigInfo rigInfo;
    private Label sourceModelLabel;
    private Label sourceRootLabel;
    private Label sizeLabel;
    private ListBox<String> scriptList;
    private Label targetModelLabel;
    private Label targetRootLabel;
    private ListBox<String> targetScriptList;

    protected void initialize(Application app) {
        this.rigRef = ((RigViewState)this.getState(RigViewState.class, true)).createRigReference();
        Container window = new Container();
        ((ToolState)this.getState(ToolState.class)).getTabs().addTab("Model", (Panel)window);
        window.addChild((Node)new Label("Source"), new Object[0]);
        Container props = (Container)window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        props.addChild((Node)new Label("Model:"), new Object[0]);
        this.sourceModelLabel = (Label)props.addChild((Node)new Label(""), new Object[]{1});
        props.addChild((Node)new Label("Root:"), new Object[0]);
        this.sourceRootLabel = (Label)props.addChild((Node)new Label(""), new Object[]{1});
        props.addChild((Node)new Label("Size:"), new Object[0]);
        this.sizeLabel = (Label)props.addChild((Node)new Label(""), new Object[]{1});
        this.scriptList = (ListBox)window.addChild((Node)new ListBox(new VersionedList()), new Object[0]);
        window.addChild((Node)new Label("Target"), new Object[0]);
        props = (Container)window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        props.addChild((Node)new Label("Model:"), new Object[0]);
        this.targetModelLabel = (Label)props.addChild((Node)new Label(""), new Object[]{1});
        props.addChild((Node)new Label("Root:"), new Object[0]);
        this.targetRootLabel = (Label)props.addChild((Node)new Label(""), new Object[]{1});
        this.targetScriptList = (ListBox)window.addChild((Node)new ListBox(new VersionedList()), new Object[0]);
        this.resetRig((Rig)this.rigRef.get());
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    public void update(float tpf) {
        if (this.rigRef != null && this.rigRef.update()) {
            this.resetRig((Rig)this.rigRef.get());
        }
        if (this.modelRef != null && this.modelRef.update()) {
            this.updateSourceFields();
        }
        if (this.targetModelRef != null && this.targetModelRef.update()) {
            this.updateTargetFields();
        }
    }

    protected void resetRig(Rig rig) {
        if (rig == null) {
            this.modelRef = null;
            this.targetModelRef = null;
            return;
        }
        this.rig = rig;
        this.rigInfo = rig.getRigInfo();
        this.modelRef = this.rigInfo.getSourceModel().createReference();
        this.targetModelRef = this.rigInfo.getTargetModel().createReference();
        this.updateSourceFields();
        this.updateTargetFields();
    }

    protected void updateSourceFields() {
        if (this.modelRef == null) {
            this.sourceModelLabel.setText("");
            this.sourceRootLabel.setText("");
            this.sizeLabel.setText("");
            this.scriptList.getModel().clear();
        } else {
            SourceModelInfo model = (SourceModelInfo)this.modelRef.get();
            this.sourceModelLabel.setText(model.getModel());
            this.sourceRootLabel.setText(model.getSourceRoot());
            BoundingBox bb = this.rig.getBoundingBox();
            Vector3f size = bb.getMax(null).subtract(bb.getMin(null));
            this.sizeLabel.setText(String.format("x:%.02f y:%.02f z:%.02f", Float.valueOf(size.x), Float.valueOf(size.y), Float.valueOf(size.z)));
            this.scriptList.getModel().clear();
            this.scriptList.getModel().addAll(model.getScripts());
        }
    }

    protected void updateTargetFields() {
        if (this.targetModelRef == null) {
            this.targetModelLabel.setText("");
            this.targetRootLabel.setText("");
            this.targetScriptList.getModel().clear();
        } else {
            TargetModelInfo target = this.rigInfo.getTargetModel();
            this.targetModelLabel.setText(target.getModel());
            this.targetRootLabel.setText(target.getTargetRoot());
            this.targetScriptList.getModel().clear();
            this.targetScriptList.getModel().addAll(target.getScripts());
        }
    }
}

