/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.DefaultRangedValueModel;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.RangedValueModel;
import com.simsilica.lemur.Selector;
import com.simsilica.lemur.SequenceModel;
import com.simsilica.lemur.SequenceModels;
import com.simsilica.lemur.Spinner;
import com.simsilica.lemur.ValueEditor;
import com.simsilica.lemur.ValueEditors;
import com.simsilica.lemur.ValueRenderer;
import com.simsilica.lemur.ValueRenderers;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.value.DefaultValueRenderer;
import com.simsilica.mathd.Vec3d;
import com.simsilica.tool.MovementAnimation;
import com.simsilica.tool.Vec3dEditor;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovementAnimationTable
extends Container {
    static Logger log = LoggerFactory.getLogger(MovementAnimationTable.class);
    private VersionedList<MovementAnimation> animation;
    private List<Row> rows = new ArrayList<Row>();
    private VersionedList<String> clipNames;

    public void setClipNames(VersionedList<String> clipNames) {
        this.clipNames = clipNames;
        for (Row row : this.rows) {
            row.clip.setModel(clipNames);
        }
    }

    public void setList(VersionedList<MovementAnimation> animation) {
        if (this.animation == animation) {
            return;
        }
        this.animation = animation;
        this.updateComponents();
    }

    public VersionedList<MovementAnimation> getList() {
        return this.animation;
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        for (Row row : this.rows) {
            row.update(tpf);
        }
    }

    protected void updateComponents() {
        this.clearChildren();
        this.addChild((Node)new Label("Animation:"), new Object[0]);
        this.addChild((Node)new Label("Velocity:"), new Object[]{1});
        this.addChild((Node)new Label("Scale:"), new Object[]{2});
        if (this.animation == null) {
            return;
        }
        for (MovementAnimation anim : this.animation) {
            Row row = new Row(anim);
            this.rows.add(row);
            this.addChild((Node)row.clip, new Object[0]);
            this.addChild((Node)row.velocity, new Object[]{1});
            this.addChild((Node)row.scale, new Object[]{2});
        }
    }

    private class Row {
        private MovementAnimation animation;
        private Selector<String> clip;
        private VersionedReference<String> clipRef;
        private Vec3dEditor velocity;
        private VersionedReference<Vec3d> velocityRef;
        private Spinner<Double> scale;
        private VersionedReference<Double> scaleRef;

        public Row(MovementAnimation animation) {
            this.animation = animation;
            this.clip = new Selector(MovementAnimationTable.this.clipNames);
            this.clip.setSelectedItem((Object)animation.getAnimation());
            this.clipRef = this.clip.createSelectedItemReference();
            this.velocity = new Vec3dEditor(Axis.X, -10.0, 10.0, 0.1, 0.01);
            this.velocity.setObject(animation.getBaseVelocity());
            this.velocityRef = this.velocity.createReference();
            SequenceModel model = SequenceModels.rangedSequence((RangedValueModel)new DefaultRangedValueModel(0.0, 10.0, 0.0), (double)0.1, (double)0.01);
            DefaultValueRenderer renderer = ValueRenderers.formattedRenderer((String)"%.2f", (String)"error");
            this.scale = new Spinner(model, (ValueRenderer)renderer);
            this.scale.setValueEditor((ValueEditor)ValueEditors.doubleEditor((String)"%.2f"));
            this.scale.setValue((Object)animation.getScale());
            this.scaleRef = this.scale.getModel().createReference();
        }

        public void update(float tpf) {
            if (this.clipRef.update()) {
                this.animation.setAnimation((String)this.clipRef.get());
            }
            if (this.velocityRef.update()) {
                this.animation.setBaseVelocity((Vec3d)this.velocityRef.get());
            }
            if (this.scaleRef.update()) {
                this.animation.setScale((Double)this.scaleRef.get());
            }
        }
    }
}

