/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.scene.Node;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.text.DocumentModel;
import com.simsilica.tool.MovementAnimationTable;
import com.simsilica.tool.MovementMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovementModeEditor
extends Container {
    static Logger log = LoggerFactory.getLogger(MovementModeEditor.class);
    private MovementMode mode;
    private TextField nameEditor;
    private VersionedReference<DocumentModel> nameRef;
    private MovementAnimationTable basicAnimation;
    private MovementAnimationTable mixAnimation;

    public MovementModeEditor() {
        Container properties = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.Y, Axis.X, FillMode.Even, FillMode.Last)), new Object[0]);
        properties.addChild((Node)new Label("Name:"), new Object[0]);
        this.nameEditor = (TextField)properties.addChild((Node)new TextField(""), new Object[]{1});
        this.nameRef = this.nameEditor.getDocumentModel().createReference();
        this.addChild((Node)new Label("Basic:"), new Object[0]);
        this.basicAnimation = (MovementAnimationTable)this.addChild((Node)new MovementAnimationTable(), new Object[0]);
        this.addChild((Node)new Label("Mix:"), new Object[0]);
        this.mixAnimation = (MovementAnimationTable)this.addChild((Node)new MovementAnimationTable(), new Object[0]);
    }

    public void setClipNames(VersionedList<String> clipNames) {
        this.basicAnimation.setClipNames(clipNames);
        this.mixAnimation.setClipNames(clipNames);
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.mode == null) {
            return;
        }
        if (this.nameRef.update()) {
            this.mode.setName(this.nameEditor.getText());
            log.info("new mode name:" + this.mode.getName());
        }
    }

    public void setMovementMode(MovementMode mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        this.updateComponents();
    }

    public MovementMode getMovementMode() {
        return this.mode;
    }

    protected void updateComponents() {
        if (this.mode == null) {
            this.nameEditor.setText("");
            this.basicAnimation.setList(null);
            this.mixAnimation.setList(null);
        } else {
            this.nameEditor.setText(this.mode.getName());
            this.basicAnimation.setList(this.mode.getBasicAnimation());
            this.mixAnimation.setList(this.mode.getMixAnimation());
        }
    }
}

