/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.scene.Node;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GridPanel;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.tool.OverlayEditor;
import com.simsilica.tool.OverlayInfo;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlayManager
extends Container {
    static Logger log = LoggerFactory.getLogger(OverlayManager.class);
    private Rig rig;
    private RigInfo rigInfo;
    private VersionedList<String> jointNames = new VersionedList();
    private VersionedReference<OverlayInfo> selectedOverlayRef;
    private ListBox<OverlayInfo> overlayList = (ListBox)this.addChild((Node)new ListBox(), new Object[0]);
    private VersionedReference<Integer> listSelectionRef = this.overlayList.getSelectionModel().createSelectionReference();
    private Container editorHolder;
    private OverlayEditor overlayEditor;
    private VersionedReference<OverlayInfo> attRef;

    public OverlayManager() {
        Container buttons = (Container)this.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("New", (Object)this, "addOverlay")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction("Remove", (Object)this, "removeOverlay")), new Object[0]);
        this.editorHolder = (Container)this.addChild((Node)new Container(), new Object[0]);
        this.editorHolder.setBackground(null);
        this.overlayEditor = new OverlayEditor(this.jointNames);
    }

    public void setRig(Rig rig) {
        if (this.rig == rig) {
            return;
        }
        this.rig = rig;
        if (rig == null) {
            this.rigInfo = null;
            this.jointNames.clear();
            this.selectedOverlayRef = null;
            this.overlayList.setModel(new VersionedList());
            this.overlayEditor.setOverlay(null);
        } else {
            this.rigInfo = rig.getRigInfo();
            this.overlayList.setModel(this.rigInfo.getOverlays());
            this.jointNames.clear();
            this.jointNames.addAll(rig.getJointNames());
            this.selectedOverlayRef = rig.createSelectedOverlayReference();
        }
    }

    public Rig getRig() {
        return this.rig;
    }

    protected void addOverlay() {
        int index = this.rigInfo.getOverlays().size();
        OverlayInfo item = new OverlayInfo("att_" + index);
        this.rigInfo.getOverlays().add((Object)item);
        this.overlayList.getSelectionModel().setSelection(Integer.valueOf(index));
    }

    protected void removeOverlay() {
        this.rigInfo.getOverlays().remove(this.overlayList.getSelectedItem());
    }

    protected void selectOverlay() {
        OverlayInfo item = (OverlayInfo)this.overlayList.getSelectedItem();
        this.rig.setSelectedOverlay(item);
        this.attRef = item == null ? null : item.createReference();
    }

    protected void editOverlay() {
        OverlayInfo item = (OverlayInfo)this.selectedOverlayRef.get();
        log.info("editOverlay():" + item);
        int index = this.rigInfo.getOverlays().indexOf((Object)item);
        Integer selection = this.overlayList.getSelectionModel().getSelection();
        selection = selection == null ? -1 : selection;
        if (selection != index) {
            this.overlayList.getSelectionModel().setSelection(Integer.valueOf(index));
        }
        this.overlayEditor.setOverlay(item);
        if (item == null) {
            this.overlayEditor.removeFromParent();
        } else {
            this.editorHolder.addChild((Node)this.overlayEditor, new Object[0]);
        }
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.listSelectionRef.update()) {
            this.selectOverlay();
        }
        if (this.selectedOverlayRef != null && this.selectedOverlayRef.update()) {
            this.editOverlay();
        }
        if (this.attRef != null && this.attRef.update()) {
            log.info("refresh list");
            GridPanel grid = this.overlayList.getGridPanel();
            grid.setVisibleRows(grid.getVisibleRows());
        }
    }
}

