/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.BufferUtils;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomReq;
import com.simsilica.mblock.geom.MaterialType;
import com.simsilica.mblock.phys.CellArrayPart;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartUtils {
    static Logger log = LoggerFactory.getLogger(PartUtils.class);
    private static Sphere sphere = new Sphere(8, 8, 1.0f);

    public static Geometry createWire(CellArrayPart part) {
        float scale = (float)part.getScale();
        float radius = (float)part.getRadius();
        if (part.getType() == CellArrayPart.Type.Sphere) {
            Geometry geom = new Geometry(part.getName(), (Mesh)sphere);
            geom.setMaterial(GuiGlobals.getInstance().createMaterial(ColorRGBA.White, false).getMaterial());
            geom.setLocalScale(radius);
            geom.getMaterial().getAdditionalRenderState().setWireframe(true);
            return geom;
        }
        ListMultimap map = MultimapBuilder.hashKeys().arrayListValues().build();
        CellArray cells = part.getCells();
        int xSize = cells.getSizeX();
        int ySize = cells.getSizeY();
        int zSize = cells.getSizeZ();
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int val = cells.getCell(i, j, k);
                    int mask = MaskUtils.getSideMask((int)val);
                    for (Direction dir : Direction.values()) {
                        if ((dir.getBitMask() & mask) == 0) continue;
                        GeomPart gp = GeomPart.createFace((MaterialType)new MaterialType("waste", new GeomReq[0]), (Direction)dir);
                        float[] coords = gp.getCoords();
                        Vec3d v1 = PartUtils.round(new Vec3d((double)((float)i + coords[0]), (double)((float)j + coords[1]), (double)((float)k + coords[2])));
                        Vec3d v2 = PartUtils.round(new Vec3d((double)((float)i + coords[3]), (double)((float)j + coords[4]), (double)((float)k + coords[5])));
                        Vec3d v3 = PartUtils.round(new Vec3d((double)((float)i + coords[6]), (double)((float)j + coords[7]), (double)((float)k + coords[8])));
                        Vec3d v4 = PartUtils.round(new Vec3d((double)((float)i + coords[9]), (double)((float)j + coords[10]), (double)((float)k + coords[11])));
                        Edge e1 = new Edge(v1, v2, dir.getVec3i().toVec3d());
                        Edge e2 = new Edge(v2, v3, dir.getVec3i().toVec3d());
                        Edge e3 = new Edge(v3, v4, dir.getVec3i().toVec3d());
                        Edge e4 = new Edge(v4, v1, dir.getVec3i().toVec3d());
                        map.put((Object)e1, (Object)"");
                        map.put((Object)e2, (Object)"");
                        map.put((Object)e3, (Object)"");
                        map.put((Object)e4, (Object)"");
                    }
                }
            }
        }
        ArrayList<Vector3f> verts = new ArrayList<Vector3f>();
        for (Edge edge : map.keySet()) {
            List list = map.get((Object)edge);
            if (list.size() > 1) continue;
            verts.add(edge.v1.toVector3f());
            verts.add(edge.v2.toVector3f());
        }
        Vector3f[] array = verts.toArray(new Vector3f[0]);
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((Vector3f[])array));
        mesh.updateBound();
        Geometry geom = new Geometry(part.getName(), mesh);
        geom.setMaterial(GuiGlobals.getInstance().createMaterial(ColorRGBA.White, false).getMaterial());
        geom.setLocalScale(scale);
        geom.getMaterial().getAdditionalRenderState().setWireframe(true);
        return geom;
    }

    private static Vec3d round(Vec3d v) {
        v.x = Math.round(v.x);
        v.y = Math.round(v.y);
        v.z = Math.round(v.z);
        return v;
    }

    private static class Edge {
        Vec3d v1;
        Vec3d v2;
        Vec3d normal;

        public Edge(Vec3d v1, Vec3d v2, Vec3d normal) {
            if (v1.hashCode() < v2.hashCode()) {
                this.v1 = v1;
                this.v2 = v2;
            } else {
                this.v1 = v2;
                this.v2 = v1;
            }
            this.normal = normal;
        }

        public int hashCode() {
            return Objects.hash(this.v1, this.v2, this.normal);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            Edge other = (Edge)o;
            if (!Objects.equals(other.v1, this.v1)) {
                return false;
            }
            if (!Objects.equals(other.v2, this.v2)) {
                return false;
            }
            return Objects.equals(other.normal, this.normal);
        }
    }
}

