/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.RigType;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.base.DefaultEntityData;
import com.simsilica.es.common.Decay;
import com.simsilica.ext.mblock.SphereFactory;
import com.simsilica.ext.mphys.EntityBodyFactory;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ObjectStatusAdapter;
import com.simsilica.ext.mphys.ObjectStatusListener;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.ext.mphys.ShapeFactoryRegistry;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.config.DefaultBlockSet;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Collider;
import com.simsilica.mblock.phys.MBlockCollisionSystem;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mblock.phys.collision.ColliderFactories;
import com.simsilica.mphys.AbstractControlDriver;
import com.simsilica.mphys.CollisionSystem;
import com.simsilica.mphys.ControlDriver;
import com.simsilica.mphys.PhysicsListener;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mworld.World;
import com.simsilica.mworld.base.DefaultLeafWorld;
import com.simsilica.mworld.db.LeafDb;
import com.simsilica.mworld.db.LeafDbCache;
import com.simsilica.mworld.db.TestLeafDb;
import com.simsilica.sim.GameSystem;
import com.simsilica.sim.GameSystemManager;
import com.simsilica.sim.common.DecaySystem;
import com.simsilica.tool.ColliderInfo;
import com.simsilica.tool.MovementAnimation;
import com.simsilica.tool.MovementMode;
import com.simsilica.tool.Rig;
import com.simsilica.tool.SpatialFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicsState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(PhysicsState.class);
    private GameSystemManager systems;
    private EntityData ed;
    private MPhysSystem<MBlockShape> mphys;
    private PhysicsSpace<EntityId, MBlockShape> phys;
    private Grid grid = new Grid(100, 0, 100);
    private Rig rig;
    private RigShapeFactory rigShapeFactory;
    private EntityId rigEntity;
    private RigidBody<EntityId, MBlockShape> rigBody;
    private Vec3d rigVelocity = new Vec3d();
    private Node modelRoot;
    private ShapeFactoryRegistry<MBlockShape> shapeFactory;
    private RigType rigType;
    private SpatialFactory modelFactory;
    private Map<EntityId, Spatial> views = new HashMap<EntityId, Spatial>();
    private Map<EntityId, RigidBody<EntityId, MBlockShape>> bodies = new HashMap<EntityId, RigidBody<EntityId, MBlockShape>>();
    private Map<Part, Spatial> rigViewIndex;
    private MovementMode mode;
    private RigShape shapeRig;
    private AnimDriver animDriver;

    public PhysicsState() {
        this.setEnabled(false);
    }

    public RigShape getShapeRig() {
        return this.shapeRig;
    }

    public Node getModelRoot() {
        return this.modelRoot;
    }

    public void setRigVelocity(Vec3d velocity) {
        this.rigVelocity.set(velocity);
    }

    public Vec3d getRigPosition() {
        return this.rigBody == null ? new Vec3d() : this.rigBody.position;
    }

    public void setRig(Rig rig) {
        this.rig = rig;
    }

    public void setMovementMode(MovementMode mode) {
        this.mode = mode;
        if (this.rigBody != null) {
            ((RigDriver)this.rigBody.getControlDriver()).setMovementMode(mode);
        }
    }

    public String getCurrentAction() {
        return this.animDriver == null ? null : this.animDriver.getCurrentAction();
    }

    public double getCurrentTime() {
        return this.animDriver == null ? 0.0 : this.animDriver.getTime();
    }

    protected void initialize(Application app) {
        DefaultBlockSet dbs = new DefaultBlockSet(app.getAssetManager(), "Textures/palette1.png", "Textures/palette2.png", "Textures/bad.jpg");
        this.systems = new GameSystemManager();
        this.ed = new DefaultEntityData();
        this.systems.register(EntityData.class, (Object)this.ed);
        this.systems.addSystem((GameSystem)new DecaySystem());
        this.shapeFactory = new ShapeFactoryRegistry();
        this.shapeFactory.registerFactory(ShapeInfo.create((String)"sphere", (double)1.0, (EntityData)this.ed), (ShapeFactory)new SphereFactory(this.ed));
        this.rigShapeFactory = new RigShapeFactory();
        this.shapeFactory.registerFactory(ShapeInfo.create((String)"rig", (double)1.0, (EntityData)this.ed), (ShapeFactory)this.rigShapeFactory);
        this.systems.register(ShapeFactory.class, this.shapeFactory);
        EntityBodyFactory bodyFactory = new EntityBodyFactory(this.ed, new Vec3d(0.0, -10.0, 0.0), this.shapeFactory);
        LeafDbCache leafDb = new LeafDbCache((LeafDb)new TestLeafDb());
        DefaultLeafWorld world = new DefaultLeafWorld((LeafDb)leafDb, 256);
        this.systems.register(World.class, (Object)world);
        this.mphys = new MPhysSystem(this.grid, bodyFactory);
        Collider[] colliders = new ColliderFactories(true).createColliders(BlockTypeIndex.getTypes());
        this.mphys.setCollisionSystem((CollisionSystem)new MBlockCollisionSystem((World)world, colliders));
        this.systems.register(MPhysSystem.class, this.mphys);
        this.systems.register(PhysicsSpace.class, (Object)this.mphys.getPhysicsSpace());
        this.systems.register(EntityBodyFactory.class, (Object)bodyFactory);
        this.phys = this.mphys.getPhysicsSpace();
        GeometryFactory geomFactory = new GeometryFactory(dbs.getMaterials().getMaterials());
        this.modelFactory = new SpatialFactory(geomFactory);
        this.modelRoot = new Node("modelRoot");
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        if (!this.systems.isInitialized()) {
            this.systems.initialize();
            PhysicsObserver po = new PhysicsObserver();
            this.phys.addPhysicsListener((PhysicsListener)po);
            this.mphys.getBinEntityManager().addObjectStatusListener((ObjectStatusListener)po);
        }
        if (!this.systems.isStarted()) {
            this.systems.start();
        }
        this.rigType = this.rig.getRigType();
        long gameTime = this.systems.getStepTime().getTime();
        this.systems.getStepTime().setCurrentTime(gameTime);
        EntityId test = this.ed.createEntity();
        this.ed.setComponents(test, new EntityComponent[]{new SpawnPosition(this.phys.getGrid(), 0.5, 85.0, 0.5), ShapeInfo.create((String)"sphere", (double)1.0, (EntityData)this.ed), new Mass(10.0), Decay.duration((long)this.systems.getStepTime().getTime(), (long)this.systems.getStepTime().toSimTime(15.0))});
        test = this.ed.createEntity();
        this.ed.setComponents(test, new EntityComponent[]{new SpawnPosition(this.phys.getGrid(), 5.0, 75.0, 6.0), ShapeInfo.create((String)"sphere", (double)0.1, (EntityData)this.ed), new Mass(10.0)});
        if (this.rigEntity == null) {
            this.rigEntity = this.ed.createEntity();
        }
        this.ed.setComponents(this.rigEntity, new EntityComponent[]{new SpawnPosition(this.phys.getGrid(), 5.0, 66.0, 5.0), ShapeInfo.create((String)"rig", (double)1.0, (EntityData)this.ed), new Mass(60.0)});
    }

    public void update(float tpf) {
        this.systems.update();
        this.mphys.getBinEntityManager().tempActivate(new Vec3d(0.0, 0.0, 0.0));
        if (this.rigBody != null) {
            for (Map.Entry<EntityId, Spatial> entry : this.views.entrySet()) {
                Spatial view = entry.getValue();
                RigidBody<EntityId, MBlockShape> body = this.bodies.get(entry.getKey());
                if (body == null) {
                    log.warn("No body for view:" + entry);
                    continue;
                }
                Vec3d pos = ((MBlockShape)body.shape).getWorldShapeOrigin(body);
                Vec3d relative = pos.subtract(this.rigBody.position.x, 64.0, this.rigBody.position.z);
                if (relative.x < -5.0) {
                    relative.x += 10.0;
                } else if (relative.x > 5.0) {
                    relative.x -= 10.0;
                }
                if (relative.z < -5.0) {
                    relative.z += 10.0;
                } else if (relative.z > 5.0) {
                    relative.z -= 10.0;
                }
                view.setLocalTranslation(relative.toVector3f());
                view.setLocalRotation(body.orientation.toQuaternion());
            }
            for (Map.Entry<EntityId, Spatial> entry : this.rigViewIndex.entrySet()) {
                Spatial s = entry.getValue();
                Part child = (Part)entry.getKey();
                s.setLocalTranslation(child.getShapeRelativePosition().toVector3f());
                s.setLocalRotation(child.getShapeRelativeOrientation().toQuaternion());
            }
        }
    }

    protected void onDisable() {
    }

    protected void addModel(EntityId id, RigidBody<EntityId, MBlockShape> body) {
        HashMap<Part, Spatial> index = new HashMap<Part, Spatial>();
        if (id == this.rigEntity) {
            this.rigBody = body;
            this.rigBody.setControlDriver((ControlDriver)new RigDriver(this.mode));
        }
        Mass mass = (Mass)this.ed.getComponent(id, Mass.class);
        Spatial model = this.modelFactory.createModel(id, (MBlockShape)body.shape, mass, index);
        model.setLocalTranslation(body.position.toVector3f());
        this.views.put(id, model);
        this.bodies.put(id, body);
        this.modelRoot.attachChild(model);
        if (id == this.rigEntity) {
            this.rigViewIndex = index;
        }
    }

    protected void removeModel(EntityId id) {
        Spatial model = this.views.remove(id);
        this.bodies.remove(id);
        if (model != null) {
            model.removeFromParent();
        }
    }

    private class RigShapeFactory
    implements ShapeFactory<MBlockShape> {
        private RigShapeFactory() {
        }

        public MBlockShape createShape(ShapeInfo info, Mass mass) {
            if (PhysicsState.this.rig == null) {
                double m = mass == null ? 0.0 : mass.getMass();
                return new MBlockShape((Part)CellArrayPart.createSphere((double)0.15, (double)m));
            }
            return PhysicsState.this.rigType.createShape(info, mass);
        }
    }

    private class ColliderView {
        Spatial root;
        ColliderInfo info;
        Node attachment;
        CellArrayPart part;

        public ColliderView(Spatial root, ColliderInfo info, Node attachment, CellArrayPart part) {
            this.root = root;
            this.info = info;
            this.attachment = attachment;
            this.part = part;
        }

        public void update() {
            Vec3d offset = this.info.getOffset();
            Quatd orient = this.info.getOrientation();
            Vector3f local = this.attachment.localToWorld(offset.toVector3f(), null);
            this.root.worldToLocal(local, local);
            Quaternion localRot = this.attachment.getWorldRotation().mult(orient.toQuaternion());
            localRot = this.root.getWorldRotation().inverse().mult(localRot);
            this.part.setLocalPosition(new Vec3d(local));
            this.part.setLocalOrientation(new Quatd(localRot));
        }
    }

    private class RigDriver
    extends AbstractControlDriver<EntityId, MBlockShape> {
        private double[] angles = new double[3];
        private MovementMode mode;
        private MovementAnimation currentAnim;
        private AnimDriver animDriver;
        private Vec3d localVelocity = new Vec3d();
        private Vec3d lastVelocity = new Vec3d(1000.0, 1000.0, 1000.0);

        public RigDriver(MovementMode mode) {
            this.mode = mode;
        }

        public void setMovementMode(MovementMode mode) {
            this.mode = mode;
        }

        public void initialize(RigidBody<EntityId, MBlockShape> body) {
            super.initialize(body);
            if (body.shape instanceof RigShape) {
                this.animDriver = new AnimDriver((RigShape)body.shape);
                PhysicsState.this.animDriver = this.animDriver;
            }
        }

        protected void resetAnimation(Vec3d velocity) {
            if (this.mode == null) {
                return;
            }
            double speed = velocity.length();
            double forward = velocity.dot(Vec3d.UNIT_Z);
            MovementAnimation best = null;
            double maxDot = -1.0;
            for (MovementAnimation ma : this.mode.getBasicAnimation()) {
                double length = ma.getBaseVelocity().length();
                double dot = 0.0;
                if (length != 0.0) {
                    dot = ma.getBaseVelocity().divide(length).dot(velocity);
                }
                if (dot > length && best != null || !(dot > maxDot)) continue;
                maxDot = dot;
                best = ma;
            }
            if (best == null) {
                log.warn("No animation found for:" + velocity);
                return;
            }
            log.info("best:" + best);
            double animSpeed = best.getScale();
            if (maxDot != 0.0) {
                animSpeed *= maxDot / best.getBaseVelocity().length();
            }
            this.animDriver.setCurrentAction(best.getAnimation(), animSpeed);
            this.currentAnim = best;
        }

        protected void killVerticalRotation(RigidBody<EntityId, MBlockShape> body) {
            body.orientation.toAngles(this.angles);
            if (this.angles[0] != 0.0 || this.angles[2] != 0.0) {
                this.angles[0] = 0.0;
                this.angles[2] = 0.0;
                body.orientation.fromAngles(this.angles);
            }
            Vec3d rot = body.getRotationalVelocity();
            if (rot.x != 0.0 || rot.z != 0.0) {
                rot.x = 0.0;
                rot.z = 0.0;
                body.setRotationalVelocity(rot);
            }
        }

        public void update(long frameTime, double step) {
            RigidBody body = this.getBody();
            this.killVerticalRotation((RigidBody<EntityId, MBlockShape>)body);
            body.orientation.set(0.0, 0.0, 0.0, 1.0);
            double y = body.getLinearVelocity().y;
            body.setVelocity(((PhysicsState)PhysicsState.this).rigVelocity.x, y, ((PhysicsState)PhysicsState.this).rigVelocity.z);
            body.wakeUp(true);
            this.localVelocity = body.orientation.mult(body.getLinearVelocity(), this.localVelocity);
            if (this.lastVelocity.distanceSq(this.localVelocity) > 0.0025000000000000005) {
                log.info("lastVelocity:" + this.lastVelocity + " new velocity:" + this.localVelocity + " distance:" + this.lastVelocity.distanceSq(this.localVelocity));
                this.lastVelocity.set(this.localVelocity);
                this.resetAnimation(this.localVelocity);
            }
            this.animDriver.update(step);
        }
    }

    private class AnimDriver {
        private RigShape cRig;
        private double time;
        private String action;
        private double speed;
        private double length;

        public AnimDriver(RigShape cRig) {
            this.cRig = cRig;
        }

        public void setCurrentAction(String action, double speed) {
            this.speed = speed;
            if (Objects.equals(this.action, action)) {
                return;
            }
            this.time = 0.0;
            this.action = action;
            if (action != null) {
                this.cRig.setLayerAction(null, action);
                this.length = this.cRig.getLayerDuration(null);
            }
        }

        public String getCurrentAction() {
            return this.action;
        }

        public double getTime() {
            return this.time;
        }

        public void setSpeed(double speed) {
            this.speed = speed;
        }

        public void update(double tpf) {
            if (this.action == null) {
                return;
            }
            this.time += tpf * this.speed;
            this.time %= this.length;
            if (this.time < 0.0) {
                this.time = (this.time + this.length) % this.length;
            }
            this.cRig.setTime(null, this.time);
            this.cRig.update();
        }
    }

    private class PhysicsObserver
    extends ObjectStatusAdapter<MBlockShape>
    implements PhysicsListener<EntityId, MBlockShape> {
        private PhysicsObserver() {
        }

        public void startFrame(long frameTime, double stepSize) {
        }

        public void update(RigidBody<EntityId, MBlockShape> body) {
            body.position.x %= 10.0;
            if (body.position.x < 0.0) {
                body.position.x += 10.0;
            }
            body.position.z %= 10.0;
            if (body.position.z < 0.0) {
                body.position.z += 10.0;
            }
        }

        public void endFrame() {
        }

        public void objectLoaded(EntityId entity, RigidBody<EntityId, MBlockShape> body) {
            log.info("Loaded:" + entity);
            PhysicsState.this.addModel(entity, body);
        }

        public void objectUnloaded(EntityId entity, RigidBody<EntityId, MBlockShape> body) {
            log.info("Unloaded:" + entity);
            PhysicsState.this.removeModel(entity);
        }
    }
}

