/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.anim.tween.action.Action;
import com.jme3.anim.tween.action.BlendAction;
import com.jme3.bounding.BoundingBox;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.simsilica.crig.RigType;
import com.simsilica.crig.jme.AnimComposerRig;
import com.simsilica.crig.jme.SpatialRigType;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.tool.AttachmentInfo;
import com.simsilica.tool.ColliderInfo;
import com.simsilica.tool.ColliderShapes;
import com.simsilica.tool.OverlayInfo;
import com.simsilica.tool.RigInfo;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rig {
    static Logger log = LoggerFactory.getLogger(Rig.class);
    private RigInfo info;
    private ColliderShapes colliders = new ColliderShapes();
    private Spatial model;
    private Spatial originalModel;
    private AnimComposer anim;
    private SkinningControl skin;
    private String currentAction;
    private Action animAction;
    private double currentSpeed;
    private VersionedHolder<AttachmentInfo> selectedAttachment = new VersionedHolder();
    private VersionedHolder<ColliderInfo> selectedCollider = new VersionedHolder();
    private VersionedHolder<OverlayInfo> selectedOverlay = new VersionedHolder();

    public Rig(RigInfo info, Spatial model) {
        this.info = info;
        this.originalModel = model.clone();
        this.model = model;
        this.anim = (AnimComposer)AnimComposerRig.findControl((Spatial)model, AnimComposer.class);
        this.skin = (SkinningControl)AnimComposerRig.findControl((Spatial)model, SkinningControl.class);
        if (this.skin != null) {
            this.skin.setHardwareSkinningPreferred(false);
        }
    }

    public AnimComposer getAnimComposer() {
        return this.anim;
    }

    public SkinningControl getSkinningControl() {
        return this.skin;
    }

    public RigInfo getRigInfo() {
        return this.info;
    }

    public Spatial getView() {
        return this.model;
    }

    public Spatial getOriginalModel() {
        return this.originalModel;
    }

    public RigType getRigType() {
        ArrayList<com.simsilica.crig.ColliderInfo> colliders = new ArrayList<com.simsilica.crig.ColliderInfo>();
        for (ColliderInfo info : this.getRigInfo().getColliders()) {
            colliders.add(info.convert(this.getColliders()));
        }
        ArrayList<com.simsilica.crig.AttachmentInfo> attachments = new ArrayList<com.simsilica.crig.AttachmentInfo>();
        for (AttachmentInfo info : this.getRigInfo().getAttachments()) {
            attachments.add(info.convert());
        }
        return new SpatialRigType(this.originalModel, colliders, attachments);
    }

    public BoundingBox getBoundingBox() {
        return (BoundingBox)this.model.getWorldBound();
    }

    public ColliderShapes getColliders() {
        return this.colliders;
    }

    public Node getAttachmentNode(String joint) {
        if (this.skin.getArmature().getJoint(joint) == null) {
            return null;
        }
        return this.skin.getAttachmentsNode(joint);
    }

    public void setSelectedAttachment(AttachmentInfo info) {
        this.selectedAttachment.updateObject((Object)info);
    }

    public AttachmentInfo getSelectedAttachment() {
        return (AttachmentInfo)this.selectedAttachment.getObject();
    }

    public VersionedReference<AttachmentInfo> createSelectedAttachmentReference() {
        return this.selectedAttachment.createReference();
    }

    public void setSelectedCollider(ColliderInfo info) {
        this.selectedCollider.updateObject((Object)info);
    }

    public ColliderInfo getSelectedCollider() {
        return (ColliderInfo)this.selectedCollider.getObject();
    }

    public VersionedReference<ColliderInfo> createSelectedColliderReference() {
        return this.selectedCollider.createReference();
    }

    public void setSelectedOverlay(OverlayInfo info) {
        this.selectedOverlay.updateObject((Object)info);
    }

    public OverlayInfo getSelectedOverlay() {
        return (OverlayInfo)this.selectedOverlay.getObject();
    }

    public VersionedReference<OverlayInfo> createSelectedOverlayReference() {
        return this.selectedOverlay.createReference();
    }

    public Set<String> getClipNames() {
        return this.anim.getAnimClipsNames();
    }

    public void setCurrentAction(String action) {
        this.setCurrentAction(action, 1.0);
    }

    public void setCurrentAction(String action, double speed) {
        log.info("setCurrentAction(" + action + ", " + speed + ")");
        if (action != null) {
            if (!Objects.equals(this.currentAction, action)) {
                this.animAction = this.anim.setCurrentAction(action);
                this.currentSpeed = speed;
                this.animAction.setSpeed(speed);
            } else if (this.animAction != null && speed != this.currentSpeed) {
                this.currentSpeed = speed;
                this.animAction.setSpeed(speed);
            }
        }
        this.currentAction = action;
        this.currentSpeed = speed;
    }

    public boolean isBlendable(String action) {
        return this.anim.action(action) instanceof BlendAction;
    }

    public void setBlendFactor(String action, double value) {
        Action a = this.anim.action(action);
        if (a instanceof BlendAction) {
            ((BlendAction)a).getBlendSpace().setValue((float)value);
        }
    }

    public void setSpeed(double speed) {
        if (this.currentSpeed == speed) {
            return;
        }
        log.info("setSpeed(" + speed + ")");
        this.currentSpeed = speed;
        if (this.animAction != null) {
            this.animAction.setSpeed(this.currentSpeed);
        }
    }

    public double getSpeed() {
        return this.currentSpeed;
    }

    public String getCurrentAction() {
        return this.currentAction;
    }

    public Set<String> getJointNames() {
        TreeSet<String> results = new TreeSet<String>();
        if (this.skin == null) {
            return results;
        }
        Rig.collectJointNames(this.skin.getArmature(), results);
        return results;
    }

    protected static void collectJointNames(Armature armature, Set<String> results) {
        for (Joint j : armature.getJointList()) {
            results.add(j.getName());
        }
    }

    public static <T extends Control> T findControl(Spatial s, Class<T> type) {
        Object result = s.getControl(type);
        if (result != null) {
            return (T)result;
        }
        if (s instanceof Node) {
            for (Spatial child : ((Node)s).getChildren()) {
                result = Rig.findControl(child, type);
                if (result == null) continue;
                return (T)result;
            }
        }
        return null;
    }
}

