/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.google.common.io.Files;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.tool.AttachmentInfo;
import com.simsilica.tool.ColliderInfo;
import com.simsilica.tool.MovementMode;
import com.simsilica.tool.OverlayInfo;
import com.simsilica.tool.SourceModelInfo;
import com.simsilica.tool.TargetModelInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigInfo {
    static Logger log = LoggerFactory.getLogger(RigInfo.class);
    private SourceModelInfo sourceModel;
    private TargetModelInfo targetModel;
    private VersionedList<AttachmentInfo> attachments = new VersionedList();
    private VersionedList<ColliderInfo> colliders = new VersionedList();
    private VersionedList<OverlayInfo> overlays = new VersionedList();
    private VersionedList<MovementMode> movementModes;

    public void upgrade() {
        if (this.targetModel == null) {
            String base = Files.getNameWithoutExtension((String)this.sourceModel.getModel());
            this.targetModel = new TargetModelInfo(base + ".rig", "Models");
        }
    }

    public void setSourceModel(SourceModelInfo sourceModel) {
        log.info("setSourceModel(" + sourceModel + ")");
        this.sourceModel = sourceModel;
    }

    public SourceModelInfo getSourceModel() {
        return this.sourceModel;
    }

    public TargetModelInfo getTargetModel() {
        return this.targetModel;
    }

    public VersionedList<AttachmentInfo> getAttachments() {
        return this.attachments;
    }

    public VersionedList<ColliderInfo> getColliders() {
        return this.colliders;
    }

    public VersionedList<OverlayInfo> getOverlays() {
        return this.overlays;
    }

    public VersionedList<MovementMode> getMovementModes() {
        if (this.movementModes == null) {
            this.movementModes = new VersionedList();
            this.movementModes.add((Object)MovementMode.createDefault("Walk", "Idle", "Walk"));
        }
        return this.movementModes;
    }
}

