/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.tool;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.crig.RigProtocol;
import com.simsilica.crig.RigType;
import com.simsilica.jmec.Convert;
import com.simsilica.jmec.ModelInfo;
import com.simsilica.jmec.ModelScript;
import com.simsilica.jmec.Probe;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.tool.AttachmentInfo;
import com.simsilica.tool.GeomUtils;
import com.simsilica.tool.Rig;
import com.simsilica.tool.RigInfo;
import com.simsilica.tool.RiggerConfig;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RigViewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(RigViewState.class);
    private Node viewRoot = new Node("viewRoot");
    private VersionedHolder<RigInfo> rigInfo = new VersionedHolder();
    private VersionedHolder<Rig> rig = new VersionedHolder();
    private VersionedReference<AttachmentInfo> selectedAttachmentRef;
    private VersionedReference<AttachmentInfo> attRef;
    private Node selectionAxes;

    public void setRigInfo(RigInfo info) {
        this.rigInfo.setObject((Object)info);
        this.loadModel();
        this.selectionAxes.removeFromParent();
    }

    public RigInfo getRigInfo() {
        return (RigInfo)this.rigInfo.getObject();
    }

    public Rig getRig() {
        return (Rig)this.rig.getObject();
    }

    public VersionedReference<Rig> createRigReference() {
        return this.rig.createReference();
    }

    public VersionedReference<RigInfo> createRigInfoReference() {
        return this.rigInfo.createReference();
    }

    public Spatial getModel() {
        return ((Rig)this.rig.getObject()).getView();
    }

    protected Node getRoot() {
        return ((SimpleApplication)this.getApplication()).getRootNode();
    }

    protected void compileBinary() {
        log.info("compileBinary()");
        this.saveRigType();
        this.saveModel();
    }

    protected void saveRigType() {
        File file;
        RigInfo ri = this.getRigInfo();
        String f = ri.getTargetModel().getModel();
        if (!f.toLowerCase().endsWith(".rt")) {
            f = f + ".rt";
        }
        if (ri.getTargetModel().getTargetRoot() != null) {
            f = ri.getTargetModel().getTargetRoot() + "/" + f;
        }
        if (!(file = new File(RiggerConfig.getInstance().getRigBinaryDir(), f)).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        log.info("Write to:" + file);
        RigType rigType = this.getRig().getRigType();
        try {
            RigProtocol.saveRigType((RigType)rigType, (File)file);
            log.info("Saved:" + file);
        }
        catch (Exception e) {
            log.error("Error writing binary:" + file, (Throwable)e);
            ((OptionPanelState)this.getState(OptionPanelState.class)).showError("Error writing:" + file, (Throwable)e);
        }
        try {
            RigType e = RigProtocol.loadRigType((File)file);
        }
        catch (Exception e) {
            log.error("Error reading back binary:" + file, (Throwable)e);
            ((OptionPanelState)this.getState(OptionPanelState.class)).showError("Error in readback for:" + file, (Throwable)e);
        }
    }

    protected void saveModel() {
        RigInfo ri = this.getRigInfo();
        Convert jmec = new Convert();
        File sourceRoot = RiggerConfig.getInstance().getFile(ri.getSourceModel().getSourceRoot());
        jmec.setSourceRoot(sourceRoot);
        jmec.setTargetRoot(RiggerConfig.getInstance().getModelBinaryDir());
        jmec.setTargetAssetPath(ri.getTargetModel().getTargetRoot());
        for (Object s : ri.getSourceModel().getScripts()) {
            try {
                File scriptFile = RiggerConfig.getInstance().getFile((String)s);
                ModelScript script = new ModelScript(jmec, (String)s, Files.toString((File)scriptFile, (Charset)Charsets.UTF_8));
                jmec.addModelScript(script);
            }
            catch (Exception e) {
                log.error("Error loading script:" + (String)s, (Throwable)e);
            }
        }
        String targetName = ri.getTargetModel().getModel();
        if (targetName != null) {
            jmec.addModelScript(new ModelScript(jmec, "rename.groovy", "model.modelName = '" + targetName + "';"));
        }
        for (String s : ri.getTargetModel().getScripts()) {
            try {
                File scriptFile = RiggerConfig.getInstance().getFile(s);
                ModelScript script = new ModelScript(jmec, s, Files.toString((File)scriptFile, (Charset)Charsets.UTF_8));
                jmec.addModelScript(script);
            }
            catch (Exception e) {
                log.error("Error loading script:" + s, (Throwable)e);
            }
        }
        File modelFile = RiggerConfig.getInstance().getFile(ri.getSourceModel().getModel());
        try {
            jmec.convert(modelFile);
        }
        catch (IOException e) {
            log.error("Error saving j3o", (Throwable)e);
            ((OptionPanelState)this.getState(OptionPanelState.class)).showError("Error saving j3o", (Throwable)e);
        }
    }

    protected void loadModel() {
        Convert jmec = new Convert();
        RigInfo ri = (RigInfo)this.rigInfo.getObject();
        File f = RiggerConfig.getInstance().getFile(ri.getSourceModel().getModel());
        File sourceRoot = RiggerConfig.getInstance().getFile(ri.getSourceModel().getSourceRoot());
        jmec.setSourceRoot(sourceRoot);
        Spatial spatial = jmec.getAssetReader().loadModel(f);
        log.info("loaded model:" + spatial);
        ModelInfo info = new ModelInfo(sourceRoot, f.getName(), spatial);
        for (String s : ri.getSourceModel().getScripts()) {
            try {
                File scriptFile = RiggerConfig.getInstance().getFile(s);
                ModelScript script = new ModelScript(jmec, s, Files.toString((File)scriptFile, (Charset)Charsets.UTF_8));
                jmec.addModelScript(script);
            }
            catch (Exception e) {
                log.error("Error loading script:" + s, (Throwable)e);
            }
        }
        jmec.runProcessors(info);
        Probe probe = new Probe();
        probe.setShowControls(true);
        probe.setShowAllMaterialParameters(true);
        probe.apply(info);
        this.rig.setObject((Object)new Rig((RigInfo)this.rigInfo.getObject(), spatial));
        this.selectedAttachmentRef = ((Rig)this.rig.getObject()).createSelectedAttachmentReference();
        this.updateSelection((AttachmentInfo)this.selectedAttachmentRef.get());
        this.viewRoot.detachAllChildren();
        this.viewRoot.attachChild(spatial);
    }

    protected void initialize(Application app) {
        this.selectionAxes = new Node("selected");
        ColorRGBA[] colors = new ColorRGBA[]{ColorRGBA.Red, ColorRGBA.Green, ColorRGBA.Blue};
        float size = 0.25f;
        Geometry opaque = GeomUtils.createAxis((float)size, (ColorRGBA)colors[0], (ColorRGBA)colors[1], (ColorRGBA)colors[2]);
        this.selectionAxes.attachChild((Spatial)opaque);
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = colors[i].clone();
            colors[i].a = 0.3f;
        }
        Geometry alpha = GeomUtils.createAxis((float)size, (ColorRGBA)colors[0], (ColorRGBA)colors[1], (ColorRGBA)colors[2]);
        alpha.setQueueBucket(RenderQueue.Bucket.Translucent);
        alpha.getMaterial().getAdditionalRenderState().setDepthTest(false);
        alpha.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.selectionAxes.attachChild((Spatial)alpha);
        this.getRoot().attachChild((Spatial)this.selectionAxes);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getRoot().attachChild((Spatial)this.viewRoot);
    }

    protected void onDisable() {
        this.viewRoot.removeFromParent();
    }

    public void update(float tpf) {
        if (this.selectedAttachmentRef != null && this.selectedAttachmentRef.update()) {
            this.updateSelection((AttachmentInfo)this.selectedAttachmentRef.get());
        }
        if (this.attRef != null && this.attRef.update()) {
            this.updateJointSelection();
        }
    }

    protected void updateSelection(AttachmentInfo attachment) {
        log.info("updateSelection(" + attachment + ")");
        if (attachment == null) {
            this.attRef = null;
            return;
        }
        this.attRef = attachment.createReference();
        this.updateJointSelection();
    }

    protected void updateJointSelection() {
        if (this.attRef == null) {
            this.selectionAxes.removeFromParent();
            return;
        }
        log.info("rig:" + this.rig.getObject());
        Node node = ((Rig)this.rig.getObject()).getAttachmentNode(((AttachmentInfo)this.attRef.get()).getJoint());
        log.info("att node:" + node);
        if (node == null) {
            this.selectionAxes.removeFromParent();
            return;
        }
        Vector3f rescale = node.getWorldScale().clone();
        rescale.x = 1.0f / rescale.x;
        rescale.y = 1.0f / rescale.y;
        rescale.z = 1.0f / rescale.z;
        log.info("rescale:" + rescale);
        this.selectionAxes.setLocalScale(rescale);
        node.attachChild((Spatial)this.selectionAxes);
        this.selectionAxes.setLocalTranslation(((AttachmentInfo)this.attRef.get()).getOffset().toVector3f().multLocal(rescale));
        this.selectionAxes.setLocalRotation(((AttachmentInfo)this.attRef.get()).getOrientation().toQuaternion());
    }
}

